/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionSplitRestriction;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KeyPrefixRegionSplitRestriction
extends RegionSplitRestriction {
    private static final Logger LOG = LoggerFactory.getLogger(KeyPrefixRegionSplitRestriction.class);
    public static final String PREFIX_LENGTH_KEY = "hbase.regionserver.region.split_restriction.prefix_length";
    private int prefixLength;

    @Override
    public void initialize(TableDescriptor tableDescriptor, Configuration conf) throws IOException {
        String prefixLengthString = tableDescriptor.getValue(PREFIX_LENGTH_KEY);
        if (prefixLengthString == null && (prefixLengthString = conf.get(PREFIX_LENGTH_KEY)) == null) {
            LOG.error("{} not specified for table {}. Using the default RegionSplitRestriction", (Object)PREFIX_LENGTH_KEY, (Object)tableDescriptor.getTableName());
            return;
        }
        try {
            this.prefixLength = Integer.parseInt(prefixLengthString);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (this.prefixLength <= 0) {
            LOG.error("Invalid value for {} for table {}:{}. Using the default RegionSplitRestriction", PREFIX_LENGTH_KEY, tableDescriptor.getTableName(), prefixLengthString);
        }
    }

    @Override
    public byte[] getRestrictedSplitPoint(byte[] splitPoint) {
        if (this.prefixLength > 0) {
            return Arrays.copyOf(splitPoint, Math.min(this.prefixLength, splitPoint.length));
        }
        return splitPoint;
    }
}

