/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.NonLazyKeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.NonReversedNonLazyKeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class KeyValueHeap
extends NonReversedNonLazyKeyValueScanner
implements KeyValueScanner,
InternalScanner {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueHeap.class);
    protected PriorityQueue<KeyValueScanner> heap = null;
    protected List<KeyValueScanner> scannersForDelayedClose = null;
    protected KeyValueScanner current = null;
    protected KVScannerComparator comparator;

    public KeyValueHeap(List<? extends KeyValueScanner> scanners, CellComparator comparator) throws IOException {
        this(scanners, new KVScannerComparator(comparator));
    }

    KeyValueHeap(List<? extends KeyValueScanner> scanners, KVScannerComparator comparator) throws IOException {
        this.comparator = comparator;
        this.scannersForDelayedClose = new ArrayList<KeyValueScanner>(scanners.size());
        if (!scanners.isEmpty()) {
            this.heap = new PriorityQueue<KeyValueScanner>(scanners.size(), this.comparator);
            for (KeyValueScanner keyValueScanner : scanners) {
                if (keyValueScanner.peek() != null) {
                    this.heap.add(keyValueScanner);
                    continue;
                }
                this.scannersForDelayedClose.add(keyValueScanner);
            }
            this.current = this.pollRealKV();
        }
    }

    @Override
    public Cell peek() {
        if (this.current == null) {
            return null;
        }
        return this.current.peek();
    }

    boolean isLatestCellFromMemstore() {
        return !this.current.isFileScanner();
    }

    @Override
    public Cell next() throws IOException {
        if (this.current == null) {
            return null;
        }
        Cell kvReturn = this.current.next();
        Cell kvNext = this.current.peek();
        if (kvNext == null) {
            this.scannersForDelayedClose.add(this.current);
            this.current = null;
            this.current = this.pollRealKV();
        } else {
            KeyValueScanner topScanner = this.heap.peek();
            if (topScanner != null && this.comparator.compare(kvNext, topScanner.peek()) >= 0) {
                this.heap.add(this.current);
                this.current = null;
                this.current = this.pollRealKV();
            }
        }
        return kvReturn;
    }

    @Override
    public boolean next(List<Cell> result, ScannerContext scannerContext) throws IOException {
        if (this.current == null) {
            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
        }
        InternalScanner currentAsInternal = (InternalScanner)((Object)this.current);
        boolean moreCells = currentAsInternal.next(result, scannerContext);
        Cell pee = this.current.peek();
        if (pee == null || !moreCells) {
            this.scannersForDelayedClose.add(this.current);
        } else {
            this.heap.add(this.current);
        }
        this.current = null;
        this.current = this.pollRealKV();
        if (this.current == null) {
            moreCells = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
        }
        return moreCells;
    }

    @Override
    public void close() {
        for (KeyValueScanner scanner : this.scannersForDelayedClose) {
            scanner.close();
        }
        this.scannersForDelayedClose.clear();
        if (this.current != null) {
            this.current.close();
        }
        if (this.heap != null) {
            for (KeyValueScanner scanner : this.heap) {
                scanner.close();
            }
        }
    }

    @Override
    public boolean seek(Cell seekKey) throws IOException {
        return this.generalizedSeek(false, seekKey, false, false);
    }

    @Override
    public boolean reseek(Cell seekKey) throws IOException {
        return this.generalizedSeek(false, seekKey, true, false);
    }

    @Override
    public boolean requestSeek(Cell key, boolean forward, boolean useBloom) throws IOException {
        return this.generalizedSeek(true, key, forward, useBloom);
    }

    private boolean generalizedSeek(boolean isLazy, Cell seekKey, boolean forward, boolean useBloom) throws IOException {
        if (!isLazy && useBloom) {
            throw new IllegalArgumentException("Multi-column Bloom filter optimization requires a lazy seek");
        }
        if (this.current == null) {
            return false;
        }
        KeyValueScanner scanner = this.current;
        try {
            while (scanner != null) {
                Cell topKey = scanner.peek();
                if (this.comparator.getComparator().compare(seekKey, topKey) <= 0) {
                    this.heap.add(scanner);
                    scanner = null;
                    this.current = this.pollRealKV();
                    return this.current != null;
                }
                boolean seekResult = isLazy && this.heap.size() > 0 ? scanner.requestSeek(seekKey, forward, useBloom) : NonLazyKeyValueScanner.doRealSeek(scanner, seekKey, forward);
                if (!seekResult) {
                    this.scannersForDelayedClose.add(scanner);
                } else {
                    this.heap.add(scanner);
                }
                if ((scanner = this.heap.poll()) != null) continue;
                this.current = null;
            }
        }
        catch (Exception e) {
            if (scanner != null) {
                try {
                    scanner.close();
                }
                catch (Exception ce) {
                    LOG.warn("close KeyValueScanner error", ce);
                }
            }
            throw e;
        }
        return false;
    }

    protected KeyValueScanner pollRealKV() throws IOException {
        KeyValueScanner kvScanner = this.heap.poll();
        if (kvScanner == null) {
            return null;
        }
        while (kvScanner != null && !kvScanner.realSeekDone()) {
            if (kvScanner.peek() != null) {
                try {
                    kvScanner.enforceSeek();
                }
                catch (IOException ioe) {
                    this.scannersForDelayedClose.add(kvScanner);
                    throw ioe;
                }
                Cell curKV = kvScanner.peek();
                if (curKV != null) {
                    KeyValueScanner nextEarliestScanner = this.heap.peek();
                    if (nextEarliestScanner == null) {
                        return kvScanner;
                    }
                    Cell nextKV = nextEarliestScanner.peek();
                    if (nextKV == null || this.comparator.compare(curKV, nextKV) < 0) {
                        return kvScanner;
                    }
                    this.heap.add(kvScanner);
                } else {
                    this.scannersForDelayedClose.add(kvScanner);
                }
            } else {
                this.scannersForDelayedClose.add(kvScanner);
            }
            kvScanner = this.heap.poll();
        }
        return kvScanner;
    }

    public PriorityQueue<KeyValueScanner> getHeap() {
        return this.heap;
    }

    KeyValueScanner getCurrentForTesting() {
        return this.current;
    }

    @Override
    public Cell getNextIndexedKey() {
        return this.current == null ? null : this.current.getNextIndexedKey();
    }

    @Override
    public void shipped() throws IOException {
        for (KeyValueScanner scanner : this.scannersForDelayedClose) {
            scanner.close();
        }
        this.scannersForDelayedClose.clear();
        if (this.current != null) {
            this.current.shipped();
        }
        if (this.heap != null) {
            for (KeyValueScanner scanner : this.heap) {
                scanner.shipped();
            }
        }
    }

    protected static class KVScannerComparator
    implements Comparator<KeyValueScanner> {
        protected CellComparator kvComparator;

        public KVScannerComparator(CellComparator kvComparator) {
            this.kvComparator = kvComparator;
        }

        @Override
        public int compare(KeyValueScanner left, KeyValueScanner right) {
            int comparison = this.compare(left.peek(), right.peek());
            if (comparison != 0) {
                return comparison;
            }
            return Long.compare(right.getScannerOrder(), left.getScannerOrder());
        }

        @Override
        public int compare(Cell left, Cell right) {
            return this.kvComparator.compare(left, right);
        }

        public CellComparator getComparator() {
            return this.kvComparator;
        }
    }
}

