/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class MemStoreCompactionStrategy {
    protected static final Logger LOG = LoggerFactory.getLogger(MemStoreCompactionStrategy.class);
    public static final String COMPACTING_MEMSTORE_THRESHOLD_KEY = "hbase.hregion.compacting.pipeline.segments.limit";
    public static final int COMPACTING_MEMSTORE_THRESHOLD_DEFAULT = 2;
    protected final String cfName;
    protected final int pipelineThreshold;

    public MemStoreCompactionStrategy(Configuration conf, String cfName) {
        this.cfName = cfName;
        this.pipelineThreshold = conf == null ? 2 : conf.getInt(COMPACTING_MEMSTORE_THRESHOLD_KEY, 2);
    }

    public String toString() {
        return this.getName() + ", pipelineThreshold=" + this.pipelineThreshold;
    }

    protected abstract String getName();

    public abstract Action getAction(VersionedSegmentsList var1);

    public void updateStats(Segment replacement) {
    }

    public void resetStats() {
    }

    protected Action simpleMergeOrFlatten(VersionedSegmentsList versionedList, String strategy) {
        int numOfSegments = versionedList.getNumOfSegments();
        if (numOfSegments > this.pipelineThreshold) {
            LOG.trace("Strategy={}, store={}; merging {} segments", strategy, this.cfName, numOfSegments);
            return this.getMergingAction();
        }
        LOG.trace("Strategy={}, store={}; flattening a segment", (Object)strategy, (Object)this.cfName);
        return this.getFlattenAction();
    }

    protected Action getMergingAction() {
        return Action.MERGE;
    }

    protected Action getFlattenAction() {
        return Action.FLATTEN;
    }

    protected Action compact(VersionedSegmentsList versionedList, String strategyInfo) {
        int numOfSegments = versionedList.getNumOfSegments();
        LOG.trace("{} in-memory compaction for store={} compacting {} segments", strategyInfo, this.cfName, numOfSegments);
        return Action.COMPACT;
    }

    public static enum Action {
        NOOP,
        FLATTEN,
        FLATTEN_COUNT_UNIQUE_KEYS,
        MERGE,
        MERGE_COUNT_UNIQUE_KEYS,
        COMPACT;

    }
}

