/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.AbstractMemStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.io.Closeables;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MemStoreCompactorSegmentsIterator
extends MemStoreSegmentsIterator {
    private static final Logger LOG = LoggerFactory.getLogger(MemStoreCompactorSegmentsIterator.class);
    private final List<Cell> kvs = new ArrayList<Cell>();
    private boolean hasMore = true;
    private Iterator<Cell> kvsIterator;
    private InternalScanner compactingScanner;

    public MemStoreCompactorSegmentsIterator(List<ImmutableSegment> segments, CellComparator comparator, int compactionKVMax, HStore store) throws IOException {
        super(compactionKVMax);
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
        AbstractMemStore.addToScanners(segments, Long.MAX_VALUE, scanners);
        this.compactingScanner = this.createScanner(store, scanners);
        this.refillKVS();
    }

    @Override
    public boolean hasNext() {
        if (this.kvsIterator == null) {
            return false;
        }
        return this.kvsIterator.hasNext() || this.refillKVS();
    }

    @Override
    public Cell next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.kvsIterator.next();
    }

    @Override
    public void close() {
        try {
            this.compactingScanner.close();
        }
        catch (IOException e) {
            LOG.warn("close store scanner failed", e);
        }
        this.compactingScanner = null;
        this.kvs.clear();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InternalScanner createScanner(HStore store, List<KeyValueScanner> scanners) throws IOException {
        StoreScanner storeScanner;
        block7: {
            boolean success;
            StoreScanner scanner;
            block5: {
                InternalScanner internalScanner;
                block6: {
                    scanner = null;
                    success = false;
                    try {
                        RegionCoprocessorHost cpHost = store.getCoprocessorHost();
                        ScanInfo scanInfo = cpHost != null ? cpHost.preMemStoreCompactionCompactScannerOpen(store) : store.getScanInfo();
                        scanner = new StoreScanner(store, scanInfo, scanners, ScanType.COMPACT_RETAIN_DELETES, store.getSmallestReadPoint(), Long.MIN_VALUE);
                        if (cpHost == null) break block5;
                        InternalScanner scannerFromCp = cpHost.preMemStoreCompactionCompact(store, scanner);
                        if (scannerFromCp == null) {
                            throw new CoprocessorException("Got a null InternalScanner when calling preMemStoreCompactionCompact which is not acceptable");
                        }
                        success = true;
                        internalScanner = scannerFromCp;
                        if (success) break block6;
                    }
                    catch (Throwable throwable) {
                        if (!success) {
                            Closeables.close(scanner, true);
                            scanners.forEach(KeyValueScanner::close);
                        }
                        throw throwable;
                    }
                    Closeables.close(scanner, true);
                    scanners.forEach(KeyValueScanner::close);
                }
                return internalScanner;
            }
            success = true;
            storeScanner = scanner;
            if (success) break block7;
            Closeables.close(scanner, true);
            scanners.forEach(KeyValueScanner::close);
        }
        return storeScanner;
    }

    private boolean refillKVS() {
        if (!this.hasMore) {
            return false;
        }
        this.kvs.clear();
        do {
            try {
                this.hasMore = this.compactingScanner.next(this.kvs, this.scannerContext);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            if (this.kvs.isEmpty()) continue;
            this.kvsIterator = this.kvs.iterator();
            return true;
        } while (this.hasMore);
        return false;
    }
}

