/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobCell;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HMobStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MobStoreScanner
extends StoreScanner {
    private static final Logger LOG = LoggerFactory.getLogger(MobStoreScanner.class);
    private boolean cacheMobBlocks = false;
    private boolean rawMobScan = false;
    private boolean readEmptyValueOnMobCellMiss = false;
    private final HMobStore mobStore;
    private final List<MobCell> referencedMobCells;

    public MobStoreScanner(HStore store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
        super(store, scanInfo, scan, columns, readPt);
        this.cacheMobBlocks = MobUtils.isCacheMobBlocks(scan);
        this.rawMobScan = MobUtils.isRawMobScan(scan);
        this.readEmptyValueOnMobCellMiss = MobUtils.isReadEmptyValueOnMobCellMiss(scan);
        if (!(store instanceof HMobStore)) {
            throw new IllegalArgumentException("The store " + store + " is not a HMobStore");
        }
        this.mobStore = (HMobStore)store;
        this.referencedMobCells = new ArrayList<MobCell>();
    }

    @Override
    public boolean next(List<Cell> outResult, ScannerContext ctx) throws IOException {
        boolean result = super.next(outResult, ctx);
        if (!this.rawMobScan) {
            if (outResult.isEmpty()) {
                return result;
            }
            long mobKVCount = 0L;
            long mobKVSize = 0L;
            for (int i = 0; i < outResult.size(); ++i) {
                Cell cell = outResult.get(i);
                if (!MobUtils.isMobReferenceCell(cell)) continue;
                MobCell mobCell = this.mobStore.resolve(cell, this.cacheMobBlocks, this.readPt, this.readEmptyValueOnMobCellMiss);
                ++mobKVCount;
                mobKVSize += (long)mobCell.getCell().getValueLength();
                outResult.set(i, mobCell.getCell());
                this.referencedMobCells.add(mobCell);
            }
            this.mobStore.updateMobScanCellsCount(mobKVCount);
            this.mobStore.updateMobScanCellsSize(mobKVSize);
        }
        return result;
    }

    private void freeAllReferencedMobCells() throws IOException {
        for (MobCell cell : this.referencedMobCells) {
            cell.close();
        }
        this.referencedMobCells.clear();
    }

    @Override
    public void shipped() throws IOException {
        super.shipped();
        this.freeAllReferencedMobCells();
    }

    @Override
    public void close() {
        super.close();
        try {
            this.freeAllReferencedMobCells();
        }
        catch (IOException e) {
            LOG.warn("Failed to free referenced mob cells: ", e);
        }
    }
}

