/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.hudi.org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerNotRunningYetException;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.TextFormat;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class RemoteProcedureResultReporter
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteProcedureResultReporter.class);
    private static final int INIT_PAUSE_TIME_MS = 1000;
    private static final int MAX_BATCH = 100;
    private final HRegionServer server;
    private final LinkedBlockingQueue<RegionServerStatusProtos.RemoteProcedureResult> results = new LinkedBlockingQueue();

    public RemoteProcedureResultReporter(HRegionServer server) {
        this.server = server;
    }

    public void complete(long procId, Throwable error) {
        RegionServerStatusProtos.RemoteProcedureResult.Builder builder = RegionServerStatusProtos.RemoteProcedureResult.newBuilder().setProcId(procId);
        if (error != null) {
            LOG.debug("Failed to complete execution of pid={}", (Object)procId, (Object)error);
            builder.setStatus(RegionServerStatusProtos.RemoteProcedureResult.Status.ERROR).setError(ForeignExceptionUtil.toProtoForeignException(this.server.getServerName().toString(), error));
        } else {
            LOG.debug("Successfully complete execution of pid={}", (Object)procId);
            builder.setStatus(RegionServerStatusProtos.RemoteProcedureResult.Status.SUCCESS);
        }
        this.results.add(builder.build());
    }

    @Override
    public void run() {
        RegionServerStatusProtos.ReportProcedureDoneRequest.Builder builder = RegionServerStatusProtos.ReportProcedureDoneRequest.newBuilder();
        int tries = 0;
        while (!this.server.isStopped()) {
            RegionServerStatusProtos.RemoteProcedureResult result;
            if (builder.getResultCount() == 0) {
                try {
                    builder.addResult(this.results.take());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue;
                }
            }
            while (builder.getResultCount() < 100 && (result = this.results.poll()) != null) {
                builder.addResult(result);
            }
            RegionServerStatusProtos.ReportProcedureDoneRequest request = builder.build();
            try {
                this.server.reportProcedureDone(builder.build());
                builder.clear();
                tries = 0;
            }
            catch (IOException e) {
                boolean pause = e instanceof ServerNotRunningYetException || e instanceof PleaseHoldException;
                long pauseTime = pause ? ConnectionUtils.getPauseTime(1000L, tries) : 1000L;
                LOG.info("Failed procedure report " + TextFormat.shortDebugString(request) + "; retry (#" + tries + ")" + (pause ? " after " + pauseTime + "ms delay (Master is coming online...)." : " immediately."), e);
                Threads.sleep(pauseTime);
                ++tries;
            }
        }
    }
}

