/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.util.concurrent.locks.Lock;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventType;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.RSProcedureCallable;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.SplitLogWorker;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.KeyLocker;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class SplitWALCallable
implements RSProcedureCallable {
    private static final Logger LOG = LoggerFactory.getLogger(SplitWALCallable.class);
    private String walPath;
    private Exception initError;
    private HRegionServer rs;
    private final KeyLocker<String> splitWALLocks = new KeyLocker();
    private volatile Lock splitWALLock = null;

    @Override
    public void init(byte[] parameter, HRegionServer rs) {
        try {
            this.rs = rs;
            MasterProcedureProtos.SplitWALParameter param = MasterProcedureProtos.SplitWALParameter.parseFrom(parameter);
            this.walPath = param.getWalPath();
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error("Parse proto buffer of split WAL request failed ", e);
            this.initError = e;
        }
    }

    @Override
    public EventType getEventType() {
        return EventType.RS_LOG_REPLAY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Void call() throws Exception {
        if (this.initError != null) {
            throw this.initError;
        }
        this.splitWALLock = this.splitWALLocks.acquireLock(this.walPath);
        try {
            switch (SplitLogWorker.splitLog(this.walPath, null, this.rs.getConfiguration(), this.rs, this.rs, this.rs.getWalFactory())) {
                case DONE: {
                    return null;
                }
                case PREEMPTED: {
                    throw new PreemptedWALSplitException(this.walPath);
                }
                case RESIGNED: {
                    throw new ResignedWALSplitException(this.walPath);
                }
                default: {
                    throw new ErrorWALSplitException(this.walPath);
                }
            }
        }
        finally {
            this.splitWALLock.unlock();
        }
    }

    public String getWalPath() {
        return this.walPath;
    }

    public static class ErrorWALSplitException
    extends HBaseIOException {
        ErrorWALSplitException(String wal) {
            super(wal);
        }
    }

    public static class ResignedWALSplitException
    extends HBaseIOException {
        ResignedWALSplitException(String wal) {
            super(wal);
        }
    }

    public static class PreemptedWALSplitException
    extends HBaseIOException {
        PreemptedWALSplitException(String wal) {
            super(wal);
        }
    }
}

