/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.CellSink;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ShipperListener;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomContext;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.RowBloomContext;
import org.apache.hudi.org.apache.hadoop.hbase.util.RowColBloomContext;
import org.apache.hudi.org.apache.hadoop.hbase.util.RowPrefixFixedLengthBloomContext;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Strings;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class StoreFileWriter
implements CellSink,
ShipperListener {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFileWriter.class.getName());
    private static final Pattern dash = Pattern.compile("-");
    private final BloomFilterWriter generalBloomFilterWriter;
    private final BloomFilterWriter deleteFamilyBloomFilterWriter;
    private final BloomType bloomType;
    private byte[] bloomParam;
    private long earliestPutTs;
    private long deleteFamilyCnt;
    private BloomContext bloomContext;
    private BloomContext deleteFamilyBloomContext;
    private final TimeRangeTracker timeRangeTracker;
    private final Supplier<Collection<HStoreFile>> compactedFilesSupplier;
    protected HFile.Writer writer;

    private StoreFileWriter(FileSystem fs, Path path, Configuration conf, CacheConfig cacheConf, BloomType bloomType, long maxKeys, InetSocketAddress[] favoredNodes, HFileContext fileContext, boolean shouldDropCacheBehind, Supplier<Collection<HStoreFile>> compactedFilesSupplier) throws IOException {
        block10: {
            block9: {
                this.bloomParam = null;
                this.earliestPutTs = Long.MAX_VALUE;
                this.deleteFamilyCnt = 0L;
                this.bloomContext = null;
                this.deleteFamilyBloomContext = null;
                this.compactedFilesSupplier = compactedFilesSupplier;
                this.timeRangeTracker = TimeRangeTracker.create(TimeRangeTracker.Type.NON_SYNC);
                this.writer = HFile.getWriterFactory(conf, cacheConf).withPath(fs, path).withFavoredNodes(favoredNodes).withFileContext(fileContext).withShouldDropCacheBehind(shouldDropCacheBehind).create();
                this.generalBloomFilterWriter = BloomFilterFactory.createGeneralBloomAtWrite(conf, cacheConf, bloomType, (int)Math.min(maxKeys, Integer.MAX_VALUE), this.writer);
                if (this.generalBloomFilterWriter == null) break block9;
                this.bloomType = bloomType;
                this.bloomParam = BloomFilterUtil.getBloomFilterParam(bloomType, conf);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Bloom filter type for " + path + ": " + (Object)((Object)this.bloomType) + ", param: " + (bloomType == BloomType.ROWPREFIX_FIXED_LENGTH ? Integer.valueOf(Bytes.toInt(this.bloomParam)) : Bytes.toStringBinary(this.bloomParam)) + ", " + this.generalBloomFilterWriter.getClass().getSimpleName());
                }
                switch (bloomType) {
                    case ROW: {
                        this.bloomContext = new RowBloomContext(this.generalBloomFilterWriter, fileContext.getCellComparator());
                        break block10;
                    }
                    case ROWCOL: {
                        this.bloomContext = new RowColBloomContext(this.generalBloomFilterWriter, fileContext.getCellComparator());
                        break block10;
                    }
                    case ROWPREFIX_FIXED_LENGTH: {
                        this.bloomContext = new RowPrefixFixedLengthBloomContext(this.generalBloomFilterWriter, fileContext.getCellComparator(), Bytes.toInt(this.bloomParam));
                        break block10;
                    }
                    default: {
                        throw new IOException("Invalid Bloom filter type: " + (Object)((Object)bloomType) + " (ROW or ROWCOL or ROWPREFIX expected)");
                    }
                }
            }
            this.bloomType = BloomType.NONE;
        }
        if (this.bloomType != BloomType.ROWCOL) {
            this.deleteFamilyBloomFilterWriter = BloomFilterFactory.createDeleteBloomAtWrite(conf, cacheConf, (int)Math.min(maxKeys, Integer.MAX_VALUE), this.writer);
            this.deleteFamilyBloomContext = new RowBloomContext(this.deleteFamilyBloomFilterWriter, fileContext.getCellComparator());
        } else {
            this.deleteFamilyBloomFilterWriter = null;
        }
        if (this.deleteFamilyBloomFilterWriter != null && LOG.isTraceEnabled()) {
            LOG.trace("Delete Family Bloom filter type for " + path + ": " + this.deleteFamilyBloomFilterWriter.getClass().getSimpleName());
        }
    }

    public void appendMetadata(long maxSequenceId, boolean majorCompaction) throws IOException {
        this.appendMetadata(maxSequenceId, majorCompaction, Collections.emptySet());
    }

    public void appendMetadata(long maxSequenceId, boolean majorCompaction, Collection<HStoreFile> storeFiles) throws IOException {
        this.writer.appendFileInfo(HStoreFile.MAX_SEQ_ID_KEY, Bytes.toBytes(maxSequenceId));
        this.writer.appendFileInfo(HStoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes(majorCompaction));
        this.writer.appendFileInfo(HStoreFile.COMPACTION_EVENT_KEY, this.toCompactionEventTrackerBytes(storeFiles));
        this.appendTrackedTimestampsToMetadata();
    }

    private byte[] toCompactionEventTrackerBytes(Collection<HStoreFile> storeFiles) {
        Set notArchivedCompactedStoreFiles = this.compactedFilesSupplier.get().stream().map(sf -> sf.getPath().getName()).collect(Collectors.toSet());
        HashSet<String> compactedStoreFiles = new HashSet<String>();
        for (HStoreFile storeFile : storeFiles) {
            compactedStoreFiles.add(storeFile.getFileInfo().getPath().getName());
            for (String csf : storeFile.getCompactedStoreFiles()) {
                if (!notArchivedCompactedStoreFiles.contains(csf)) continue;
                compactedStoreFiles.add(csf);
            }
        }
        return ProtobufUtil.toCompactionEventTrackerBytes(compactedStoreFiles);
    }

    public void appendMetadata(long maxSequenceId, boolean majorCompaction, long mobCellsCount) throws IOException {
        this.writer.appendFileInfo(HStoreFile.MAX_SEQ_ID_KEY, Bytes.toBytes(maxSequenceId));
        this.writer.appendFileInfo(HStoreFile.MAJOR_COMPACTION_KEY, Bytes.toBytes(majorCompaction));
        this.writer.appendFileInfo(HStoreFile.MOB_CELLS_COUNT, Bytes.toBytes(mobCellsCount));
        this.appendTrackedTimestampsToMetadata();
    }

    public void appendTrackedTimestampsToMetadata() throws IOException {
        this.appendFileInfo(HStoreFile.TIMERANGE_KEY, TimeRangeTracker.toByteArray(this.timeRangeTracker));
        this.appendFileInfo(HStoreFile.EARLIEST_PUT_TS, Bytes.toBytes(this.earliestPutTs));
    }

    public void trackTimestamps(Cell cell) {
        if (KeyValue.Type.Put.getCode() == cell.getTypeByte()) {
            this.earliestPutTs = Math.min(this.earliestPutTs, cell.getTimestamp());
        }
        this.timeRangeTracker.includeTimestamp(cell);
    }

    private void appendGeneralBloomfilter(Cell cell) throws IOException {
        if (this.generalBloomFilterWriter != null) {
            this.bloomContext.writeBloom(cell);
        }
    }

    private void appendDeleteFamilyBloomFilter(Cell cell) throws IOException {
        if (!PrivateCellUtil.isDeleteFamily(cell) && !PrivateCellUtil.isDeleteFamilyVersion(cell)) {
            return;
        }
        ++this.deleteFamilyCnt;
        if (this.deleteFamilyBloomFilterWriter != null) {
            this.deleteFamilyBloomContext.writeBloom(cell);
        }
    }

    @Override
    public void append(Cell cell) throws IOException {
        this.appendGeneralBloomfilter(cell);
        this.appendDeleteFamilyBloomFilter(cell);
        this.writer.append(cell);
        this.trackTimestamps(cell);
    }

    @Override
    public void beforeShipped() throws IOException {
        this.writer.beforeShipped();
        if (this.generalBloomFilterWriter != null) {
            this.generalBloomFilterWriter.beforeShipped();
        }
        if (this.deleteFamilyBloomFilterWriter != null) {
            this.deleteFamilyBloomFilterWriter.beforeShipped();
        }
    }

    public Path getPath() {
        return this.writer.getPath();
    }

    public boolean hasGeneralBloom() {
        return this.generalBloomFilterWriter != null;
    }

    BloomFilterWriter getGeneralBloomWriter() {
        return this.generalBloomFilterWriter;
    }

    private boolean closeBloomFilter(BloomFilterWriter bfw) throws IOException {
        boolean haveBloom;
        boolean bl = haveBloom = bfw != null && bfw.getKeyCount() > 0L;
        if (haveBloom) {
            bfw.compactBloom();
        }
        return haveBloom;
    }

    private boolean closeGeneralBloomFilter() throws IOException {
        boolean hasGeneralBloom = this.closeBloomFilter(this.generalBloomFilterWriter);
        if (hasGeneralBloom) {
            this.writer.addGeneralBloomFilter(this.generalBloomFilterWriter);
            this.writer.appendFileInfo(HStoreFile.BLOOM_FILTER_TYPE_KEY, Bytes.toBytes(this.bloomType.toString()));
            if (this.bloomParam != null) {
                this.writer.appendFileInfo(HStoreFile.BLOOM_FILTER_PARAM_KEY, this.bloomParam);
            }
            this.bloomContext.addLastBloomKey(this.writer);
        }
        return hasGeneralBloom;
    }

    private boolean closeDeleteFamilyBloomFilter() throws IOException {
        boolean hasDeleteFamilyBloom = this.closeBloomFilter(this.deleteFamilyBloomFilterWriter);
        if (hasDeleteFamilyBloom) {
            this.writer.addDeleteFamilyBloomFilter(this.deleteFamilyBloomFilterWriter);
        }
        this.writer.appendFileInfo(HStoreFile.DELETE_FAMILY_COUNT, Bytes.toBytes(this.deleteFamilyCnt));
        return hasDeleteFamilyBloom;
    }

    public void close() throws IOException {
        boolean hasGeneralBloom = this.closeGeneralBloomFilter();
        boolean hasDeleteFamilyBloom = this.closeDeleteFamilyBloomFilter();
        this.writer.close();
        if (LOG.isTraceEnabled()) {
            LOG.trace((hasGeneralBloom ? "" : "NO ") + "General Bloom and " + (hasDeleteFamilyBloom ? "" : "NO ") + "DeleteFamily was added to HFile " + this.getPath());
        }
    }

    public void appendFileInfo(byte[] key, byte[] value) throws IOException {
        this.writer.appendFileInfo(key, value);
    }

    HFile.Writer getHFileWriter() {
        return this.writer;
    }

    static Path getUniqueFile(FileSystem fs, Path dir) throws IOException {
        if (!fs.getFileStatus(dir).isDirectory()) {
            throw new IOException("Expecting " + dir.toString() + " to be a directory");
        }
        return new Path(dir, dash.matcher(UUID.randomUUID().toString()).replaceAll(""));
    }

    @SuppressWarnings(value={"ICAST_INTEGER_MULTIPLY_CAST_TO_LONG"}, justification="Will not overflow")
    public static class Builder {
        private final Configuration conf;
        private final CacheConfig cacheConf;
        private final FileSystem fs;
        private BloomType bloomType = BloomType.NONE;
        private long maxKeyCount = 0L;
        private Path dir;
        private Path filePath;
        private InetSocketAddress[] favoredNodes;
        private HFileContext fileContext;
        private boolean shouldDropCacheBehind;
        private Supplier<Collection<HStoreFile>> compactedFilesSupplier = () -> Collections.emptySet();
        private String fileStoragePolicy;

        public Builder(Configuration conf, CacheConfig cacheConf, FileSystem fs) {
            this.conf = conf;
            this.cacheConf = cacheConf;
            this.fs = fs;
        }

        public Builder(Configuration conf, FileSystem fs) {
            this.conf = conf;
            this.cacheConf = CacheConfig.DISABLED;
            this.fs = fs;
        }

        public Builder withOutputDir(Path dir) {
            Preconditions.checkNotNull(dir);
            this.dir = dir;
            return this;
        }

        public Builder withFilePath(Path filePath) {
            Preconditions.checkNotNull(filePath);
            this.filePath = filePath;
            return this;
        }

        public Builder withFavoredNodes(InetSocketAddress[] favoredNodes) {
            this.favoredNodes = favoredNodes;
            return this;
        }

        public Builder withBloomType(BloomType bloomType) {
            Preconditions.checkNotNull(bloomType);
            this.bloomType = bloomType;
            return this;
        }

        public Builder withMaxKeyCount(long maxKeyCount) {
            this.maxKeyCount = maxKeyCount;
            return this;
        }

        public Builder withFileContext(HFileContext fileContext) {
            this.fileContext = fileContext;
            return this;
        }

        public Builder withShouldDropCacheBehind(boolean shouldDropCacheBehind) {
            this.shouldDropCacheBehind = shouldDropCacheBehind;
            return this;
        }

        public Builder withCompactedFilesSupplier(Supplier<Collection<HStoreFile>> compactedFilesSupplier) {
            this.compactedFilesSupplier = compactedFilesSupplier;
            return this;
        }

        public Builder withFileStoragePolicy(String fileStoragePolicy) {
            this.fileStoragePolicy = fileStoragePolicy;
            return this;
        }

        public StoreFileWriter build() throws IOException {
            String policyName;
            if ((this.dir == null ? 0 : 1) + (this.filePath == null ? 0 : 1) != 1) {
                throw new IllegalArgumentException("Either specify parent directory or file path");
            }
            if (this.dir == null) {
                this.dir = this.filePath.getParent();
            }
            if (!this.fs.exists(this.dir)) {
                HRegionFileSystem.mkdirs(this.fs, this.conf, this.dir);
            }
            if (null == (policyName = this.conf.get("STORAGE_POLICY"))) {
                policyName = this.conf.get("hbase.hstore.block.storage.policy");
            }
            CommonFSUtils.setStoragePolicy(this.fs, this.dir, policyName);
            if (this.filePath == null) {
                if (!Strings.isNullOrEmpty(this.fileStoragePolicy)) {
                    this.dir = new Path(this.dir, "storage_policy_" + this.fileStoragePolicy);
                    if (!this.fs.exists(this.dir)) {
                        HRegionFileSystem.mkdirs(this.fs, this.conf, this.dir);
                        LOG.info("Create tmp dir " + this.dir.toString() + " with storage policy: " + this.fileStoragePolicy);
                    }
                    CommonFSUtils.setStoragePolicy(this.fs, this.dir, this.fileStoragePolicy);
                }
                this.filePath = StoreFileWriter.getUniqueFile(this.fs, this.dir);
                if (!BloomFilterFactory.isGeneralBloomEnabled(this.conf)) {
                    this.bloomType = BloomType.NONE;
                }
            }
            return new StoreFileWriter(this.fs, this.filePath, this.conf, this.cacheConf, this.bloomType, this.maxKeyCount, this.favoredNodes, this.fileContext, this.shouldDropCacheBehind, this.compactedFilesSupplier);
        }
    }
}

