/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver.snapshot;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hudi.org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hudi.org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hudi.org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.ProcedureMember;
import org.apache.hudi.org.apache.hadoop.hbase.procedure.Subprocedure;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.snapshot.RegionServerSnapshotManager;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hudi.org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FlushSnapshotSubprocedure
extends Subprocedure {
    private static final Logger LOG = LoggerFactory.getLogger(FlushSnapshotSubprocedure.class);
    private final List<HRegion> regions;
    private final SnapshotProtos.SnapshotDescription snapshot;
    private final RegionServerSnapshotManager.SnapshotSubprocedurePool taskManager;
    private boolean snapshotSkipFlush = false;
    static final int MAX_RETRIES = 3;

    public FlushSnapshotSubprocedure(ProcedureMember member, ForeignExceptionDispatcher errorListener, long wakeFrequency, long timeout, List<HRegion> regions, SnapshotProtos.SnapshotDescription snapshot, RegionServerSnapshotManager.SnapshotSubprocedurePool taskManager) {
        super(member, snapshot.getName(), errorListener, wakeFrequency, timeout);
        this.snapshot = snapshot;
        if (this.snapshot.getType() == SnapshotProtos.SnapshotDescription.Type.SKIPFLUSH) {
            this.snapshotSkipFlush = true;
        }
        this.regions = regions;
        this.taskManager = taskManager;
    }

    private void flushSnapshot() throws ForeignException {
        if (this.regions.isEmpty()) {
            return;
        }
        this.monitor.rethrowException();
        if (this.taskManager.hasTasks()) {
            throw new IllegalStateException("Attempting to take snapshot " + ClientSnapshotDescriptionUtils.toString(this.snapshot) + " but we currently have outstanding tasks");
        }
        for (HRegion region : this.regions) {
            this.taskManager.submitTask(new RegionSnapshotTask(region, this.snapshot, this.snapshotSkipFlush, this.monitor));
            this.monitor.rethrowException();
        }
        LOG.debug("Flush Snapshot Tasks submitted for " + this.regions.size() + " regions");
        try {
            this.taskManager.waitForOutstandingTasks();
        }
        catch (InterruptedException e) {
            LOG.error("got interrupted exception for " + this.getMemberName());
            throw new ForeignException(this.getMemberName(), e);
        }
    }

    @Override
    public void acquireBarrier() throws ForeignException {
    }

    @Override
    public byte[] insideBarrier() throws ForeignException {
        this.flushSnapshot();
        return new byte[0];
    }

    @Override
    public void cleanup(Exception e) {
        LOG.info("Aborting all online FLUSH snapshot subprocedure task threads for '" + this.snapshot.getName() + "' due to error", e);
        try {
            this.taskManager.cancelTasks();
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
        }
    }

    public void releaseBarrier() {
    }

    public static class RegionSnapshotTask
    implements Callable<Void> {
        private HRegion region;
        private boolean skipFlush;
        private ForeignExceptionDispatcher monitor;
        private SnapshotProtos.SnapshotDescription snapshotDesc;

        public RegionSnapshotTask(HRegion region, SnapshotProtos.SnapshotDescription snapshotDesc, boolean skipFlush, ForeignExceptionDispatcher monitor) {
            this.region = region;
            this.skipFlush = skipFlush;
            this.monitor = monitor;
            this.snapshotDesc = snapshotDesc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            LOG.debug("Starting snapshot operation on " + this.region);
            this.region.startRegionOperation(Region.Operation.SNAPSHOT);
            try {
                if (this.skipFlush) {
                    LOG.debug("take snapshot without flush memstore first");
                } else {
                    LOG.debug("Flush Snapshotting region " + this.region.toString() + " started...");
                    boolean succeeded = false;
                    long readPt = this.region.getReadPoint(IsolationLevel.READ_COMMITTED);
                    for (int i = 0; i < 3; ++i) {
                        HRegion.FlushResult res = this.region.flush(true);
                        if (res.getResult() == HRegion.FlushResult.Result.CANNOT_FLUSH) {
                            this.region.waitForFlushes();
                            if (this.region.getMaxFlushedSeqId() < readPt) continue;
                            succeeded = true;
                            break;
                        }
                        succeeded = true;
                        break;
                    }
                    if (!succeeded) {
                        throw new IOException("Unable to complete flush after 3 attempts");
                    }
                }
                this.region.addRegionToSnapshot(this.snapshotDesc, this.monitor);
                if (this.skipFlush) {
                    LOG.debug("... SkipFlush Snapshotting region " + this.region.toString() + " completed.");
                } else {
                    LOG.debug("... Flush Snapshotting region " + this.region.toString() + " completed.");
                }
            }
            finally {
                LOG.debug("Closing snapshot operation on " + this.region);
                this.region.closeRegionOperation(Region.Operation.SNAPSHOT);
            }
            return null;
        }
    }
}

