/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security.provider;

import java.util.Collection;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hudi.org.apache.hadoop.hbase.security.User;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.AuthenticationProviderSelector;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.DigestSaslAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.DigestSaslClientAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.GssSaslAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.GssSaslClientAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.SimpleSaslAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.SimpleSaslClientAuthenticationProvider;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Authentication"})
@NotThreadSafe
public class BuiltInProviderSelector
implements AuthenticationProviderSelector {
    private static final Logger LOG = LoggerFactory.getLogger(BuiltInProviderSelector.class);
    Configuration conf;
    SimpleSaslClientAuthenticationProvider simpleAuth = null;
    GssSaslClientAuthenticationProvider krbAuth = null;
    DigestSaslClientAuthenticationProvider digestAuth = null;
    Text digestAuthTokenKind = null;

    @Override
    public void configure(Configuration conf, Collection<SaslClientAuthenticationProvider> providers) {
        if (this.conf != null) {
            throw new IllegalStateException("configure() should only be called once");
        }
        this.conf = Objects.requireNonNull(conf);
        for (SaslClientAuthenticationProvider provider : Objects.requireNonNull(providers)) {
            String name = provider.getSaslAuthMethod().getName();
            if (SimpleSaslAuthenticationProvider.SASL_AUTH_METHOD.getName().contentEquals(name)) {
                if (this.simpleAuth != null) {
                    throw new IllegalStateException("Encountered multiple SimpleSaslClientAuthenticationProvider instances");
                }
                this.simpleAuth = (SimpleSaslClientAuthenticationProvider)provider;
                continue;
            }
            if (GssSaslAuthenticationProvider.SASL_AUTH_METHOD.getName().equals(name)) {
                if (this.krbAuth != null) {
                    throw new IllegalStateException("Encountered multiple GssSaslClientAuthenticationProvider instances");
                }
                this.krbAuth = (GssSaslClientAuthenticationProvider)provider;
                continue;
            }
            if (DigestSaslAuthenticationProvider.SASL_AUTH_METHOD.getName().equals(name)) {
                if (this.digestAuth != null) {
                    throw new IllegalStateException("Encountered multiple DigestSaslClientAuthenticationProvider instances");
                }
                this.digestAuth = (DigestSaslClientAuthenticationProvider)provider;
                this.digestAuthTokenKind = new Text(this.digestAuth.getTokenKind());
                continue;
            }
            LOG.warn("Ignoring unknown SaslClientAuthenticationProvider: {}", (Object)provider.getClass());
        }
        if (this.simpleAuth == null || this.krbAuth == null || this.digestAuth == null) {
            throw new IllegalStateException("Failed to load SIMPLE, KERBEROS, and DIGEST authentication providers. Classpath is not sane.");
        }
    }

    @Override
    public Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>> selectProvider(String clusterId, User user) {
        Objects.requireNonNull(clusterId, "Null clusterId was given");
        Objects.requireNonNull(user, "Null user was given");
        if (!User.isHBaseSecurityEnabled(this.conf)) {
            return new Pair<SimpleSaslClientAuthenticationProvider, Object>(this.simpleAuth, null);
        }
        Text clusterIdAsText = new Text(clusterId);
        for (Token<? extends TokenIdentifier> token : user.getTokens()) {
            if (!clusterIdAsText.equals((Object)token.getService()) || !this.digestAuthTokenKind.equals((Object)token.getKind())) continue;
            return new Pair<SaslClientAuthenticationProvider, Token<? extends TokenIdentifier>>(this.digestAuth, token);
        }
        UserGroupInformation currentUser = user.getUGI();
        UserGroupInformation realUser = currentUser.getRealUser();
        if (currentUser.hasKerberosCredentials() || realUser != null && realUser.hasKerberosCredentials()) {
            return new Pair<GssSaslClientAuthenticationProvider, Object>(this.krbAuth, null);
        }
        LOG.warn("No matching SASL authentication provider and supporting token found from providers for user: {}", (Object)user);
        return null;
    }
}

