/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.DataInput;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CompoundBloomFilter;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CompoundBloomFilterWriter;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilter;
import org.apache.hudi.org.apache.hadoop.hbase.util.BloomFilterWriter;
import org.apache.hudi.org.apache.hadoop.hbase.util.Hash;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class BloomFilterFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BloomFilterFactory.class.getName());
    public static final String IO_STOREFILE_BLOOM_ERROR_RATE = "io.storefile.bloom.error.rate";
    public static final String IO_STOREFILE_BLOOM_MAX_FOLD = "io.storefile.bloom.max.fold";
    public static final String IO_STOREFILE_BLOOM_MAX_KEYS = "io.storefile.bloom.max.keys";
    public static final String IO_STOREFILE_BLOOM_ENABLED = "io.storefile.bloom.enabled";
    public static final String IO_STOREFILE_DELETEFAMILY_BLOOM_ENABLED = "io.storefile.delete.family.bloom.enabled";
    public static final String IO_STOREFILE_BLOOM_BLOCK_SIZE = "io.storefile.bloom.block.size";
    private static final int MAX_ALLOWED_FOLD_FACTOR = 7;

    private BloomFilterFactory() {
    }

    public static BloomFilter createFromMeta(DataInput meta, HFile.Reader reader) throws IllegalArgumentException, IOException {
        int version = meta.readInt();
        switch (version) {
            case 3: {
                return new CompoundBloomFilter(meta, reader);
            }
        }
        throw new IllegalArgumentException("Bad bloom filter format version " + version);
    }

    public static boolean isGeneralBloomEnabled(Configuration conf) {
        return conf.getBoolean(IO_STOREFILE_BLOOM_ENABLED, true);
    }

    public static boolean isDeleteFamilyBloomEnabled(Configuration conf) {
        return conf.getBoolean(IO_STOREFILE_DELETEFAMILY_BLOOM_ENABLED, true);
    }

    public static float getErrorRate(Configuration conf) {
        return conf.getFloat(IO_STOREFILE_BLOOM_ERROR_RATE, 0.01f);
    }

    public static int getMaxFold(Configuration conf) {
        return conf.getInt(IO_STOREFILE_BLOOM_MAX_FOLD, 7);
    }

    public static int getBloomBlockSize(Configuration conf) {
        return conf.getInt(IO_STOREFILE_BLOOM_BLOCK_SIZE, 131072);
    }

    public static int getMaxKeys(Configuration conf) {
        return conf.getInt(IO_STOREFILE_BLOOM_MAX_KEYS, 128000000);
    }

    public static BloomFilterWriter createGeneralBloomAtWrite(Configuration conf, CacheConfig cacheConf, BloomType bloomType, int maxKeys, HFile.Writer writer) {
        if (!BloomFilterFactory.isGeneralBloomEnabled(conf)) {
            LOG.trace("Bloom filters are disabled by configuration for " + writer.getPath() + (conf == null ? " (configuration is null)" : ""));
            return null;
        }
        if (bloomType == BloomType.NONE) {
            LOG.trace("Bloom filter is turned off for the column family");
            return null;
        }
        float err = BloomFilterFactory.getErrorRate(conf);
        if (bloomType == BloomType.ROWCOL) {
            err = (float)(1.0 - Math.sqrt(1.0f - err));
        }
        int maxFold = conf.getInt(IO_STOREFILE_BLOOM_MAX_FOLD, 7);
        CompoundBloomFilterWriter bloomWriter = new CompoundBloomFilterWriter(BloomFilterFactory.getBloomBlockSize(conf), err, Hash.getHashType(conf), maxFold, cacheConf.shouldCacheBloomsOnWrite(), bloomType == BloomType.ROWCOL ? CellComparatorImpl.COMPARATOR : null, bloomType);
        writer.addInlineBlockWriter(bloomWriter);
        return bloomWriter;
    }

    public static BloomFilterWriter createDeleteBloomAtWrite(Configuration conf, CacheConfig cacheConf, int maxKeys, HFile.Writer writer) {
        if (!BloomFilterFactory.isDeleteFamilyBloomEnabled(conf)) {
            LOG.info("Delete Bloom filters are disabled by configuration for " + writer.getPath() + (conf == null ? " (configuration is null)" : ""));
            return null;
        }
        float err = BloomFilterFactory.getErrorRate(conf);
        int maxFold = BloomFilterFactory.getMaxFold(conf);
        CompoundBloomFilterWriter bloomWriter = new CompoundBloomFilterWriter(BloomFilterFactory.getBloomBlockSize(conf), err, Hash.getHashType(conf), maxFold, cacheConf.shouldCacheBloomsOnWrite(), null, BloomType.ROW);
        writer.addInlineBlockWriter(bloomWriter);
        return bloomWriter;
    }
}

