/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSDataOutputStreamBuilder;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class CommonFSUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonFSUtils.class);
    public static final String HBASE_WAL_DIR = "hbase.wal.dir";
    public static final String UNSAFE_STREAM_CAPABILITY_ENFORCE = "hbase.unsafe.stream.capability.enforce";
    public static final String FULL_RWX_PERMISSIONS = "777";
    private static final Map<FileSystem, Boolean> warningMap = new ConcurrentHashMap<FileSystem, Boolean>();

    private CommonFSUtils() {
    }

    public static boolean isStartingWithPath(Path rootPath, String path) {
        String uriRootPath = rootPath.toUri().getPath();
        String tailUriPath = new Path(path).toUri().getPath();
        return tailUriPath.startsWith(uriRootPath);
    }

    public static boolean isMatchingTail(Path pathToSearch, String pathTail) {
        return CommonFSUtils.isMatchingTail(pathToSearch, new Path(pathTail));
    }

    public static boolean isMatchingTail(Path pathToSearch, Path pathTail) {
        String toSearchName;
        String tailName;
        if (pathToSearch.depth() != pathTail.depth()) {
            return false;
        }
        Path tailPath = pathTail;
        Path toSearch = pathToSearch;
        boolean result = false;
        do {
            if ((tailName = tailPath.getName()) == null || tailName.length() <= 0) {
                result = true;
                break;
            }
            toSearchName = toSearch.getName();
            if (toSearchName == null || toSearchName.length() <= 0) break;
            tailPath = tailPath.getParent();
            toSearch = toSearch.getParent();
        } while (tailName.equals(toSearchName));
        return result;
    }

    public static boolean deleteDirectory(FileSystem fs, Path dir) throws IOException {
        return fs.exists(dir) && fs.delete(dir, true);
    }

    public static long getDefaultBlockSize(FileSystem fs, Path path) {
        return fs.getDefaultBlockSize(path);
    }

    public static short getDefaultReplication(FileSystem fs, Path path) {
        return fs.getDefaultReplication(path);
    }

    public static int getDefaultBufferSize(FileSystem fs) {
        return fs.getConf().getInt("io.file.buffer.size", 4096);
    }

    public static FSDataOutputStream create(FileSystem fs, Path path, FsPermission perm, boolean overwrite) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Creating file={} with permission={}, overwrite={}", path, perm, overwrite);
        }
        return fs.create(path, perm, overwrite, CommonFSUtils.getDefaultBufferSize(fs), CommonFSUtils.getDefaultReplication(fs, path), CommonFSUtils.getDefaultBlockSize(fs, path), null);
    }

    public static FsPermission getFilePermissions(FileSystem fs, Configuration conf, String permssionConfKey) {
        boolean enablePermissions = conf.getBoolean("hbase.data.umask.enable", false);
        if (enablePermissions) {
            try {
                FsPermission perm = new FsPermission(FULL_RWX_PERMISSIONS);
                String mask = conf.get(permssionConfKey);
                if (mask == null) {
                    return FsPermission.getFileDefault();
                }
                FsPermission umask = new FsPermission(mask);
                return perm.applyUMask(umask);
            }
            catch (IllegalArgumentException e) {
                LOG.warn("Incorrect umask attempted to be created: " + conf.get(permssionConfKey) + ", using default file permissions.", e);
                return FsPermission.getFileDefault();
            }
        }
        return FsPermission.getFileDefault();
    }

    public static Path validateRootPath(Path root) throws IOException {
        try {
            URI rootURI = new URI(root.toString());
            String scheme = rootURI.getScheme();
            if (scheme == null) {
                throw new IOException("Root directory does not have a scheme");
            }
            return root;
        }
        catch (URISyntaxException e) {
            throw new IOException("Root directory path is not a valid URI -- check your hbase.rootdir configuration", e);
        }
    }

    public static String removeWALRootPath(Path path, Configuration conf) throws IOException {
        Path root = CommonFSUtils.getWALRootDir(conf);
        String pathStr = path.toString();
        if (!pathStr.startsWith(root.toString())) {
            return pathStr;
        }
        return pathStr.substring(root.toString().length() + 1);
    }

    public static String getPath(Path p) {
        return p.toUri().getPath();
    }

    public static Path getRootDir(Configuration c) throws IOException {
        Path p = new Path(c.get("hbase.rootdir"));
        FileSystem fs = p.getFileSystem(c);
        return p.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    public static void setRootDir(Configuration c, Path root) {
        c.set("hbase.rootdir", root.toString());
    }

    public static void setFsDefault(Configuration c, Path root) {
        c.set("fs.defaultFS", root.toString());
    }

    public static void setFsDefault(Configuration c, String uri) {
        c.set("fs.defaultFS", uri);
    }

    public static FileSystem getRootDirFileSystem(Configuration c) throws IOException {
        Path p = CommonFSUtils.getRootDir(c);
        return p.getFileSystem(c);
    }

    public static Path getWALRootDir(Configuration c) throws IOException {
        Path p = new Path(c.get(HBASE_WAL_DIR, c.get("hbase.rootdir")));
        if (!CommonFSUtils.isValidWALRootDir(p, c)) {
            return CommonFSUtils.getRootDir(c);
        }
        FileSystem fs = p.getFileSystem(c);
        return p.makeQualified(fs.getUri(), fs.getWorkingDirectory());
    }

    public static String getDirUri(Configuration c, Path p) throws IOException {
        if (p.toUri().getScheme() != null) {
            return p.toUri().toString();
        }
        return null;
    }

    public static void setWALRootDir(Configuration c, Path root) {
        c.set(HBASE_WAL_DIR, root.toString());
    }

    public static FileSystem getWALFileSystem(Configuration c) throws IOException {
        Path p = CommonFSUtils.getWALRootDir(c);
        FileSystem fs = p.getFileSystem(c);
        String enforceStreamCapability = c.get(UNSAFE_STREAM_CAPABILITY_ENFORCE);
        if (enforceStreamCapability != null) {
            fs.getConf().set(UNSAFE_STREAM_CAPABILITY_ENFORCE, enforceStreamCapability);
        }
        return fs;
    }

    private static boolean isValidWALRootDir(Path walDir, Configuration c) throws IOException {
        Path rootDir = CommonFSUtils.getRootDir(c);
        FileSystem fs = walDir.getFileSystem(c);
        Path qualifiedWalDir = walDir.makeQualified(fs.getUri(), fs.getWorkingDirectory());
        if (!qualifiedWalDir.equals((Object)rootDir) && qualifiedWalDir.toString().startsWith(rootDir.toString() + "/")) {
            throw new IllegalStateException("Illegal WAL directory specified. WAL directories are not permitted to be under root directory: rootDir=" + rootDir.toString() + ", qualifiedWALDir=" + qualifiedWalDir);
        }
        return true;
    }

    public static Path getWALRegionDir(Configuration conf, TableName tableName, String encodedRegionName) throws IOException {
        return new Path(CommonFSUtils.getWALTableDir(conf, tableName), encodedRegionName);
    }

    public static Path getWALTableDir(Configuration conf, TableName tableName) throws IOException {
        Path baseDir = new Path(CommonFSUtils.getWALRootDir(conf), "data");
        return new Path(new Path(baseDir, tableName.getNamespaceAsString()), tableName.getQualifierAsString());
    }

    @Deprecated
    public static Path getWrongWALRegionDir(Configuration conf, TableName tableName, String encodedRegionName) throws IOException {
        Path wrongTableDir = new Path(new Path(CommonFSUtils.getWALRootDir(conf), tableName.getNamespaceAsString()), tableName.getQualifierAsString());
        return new Path(wrongTableDir, encodedRegionName);
    }

    public static Path getTableDir(Path rootdir, TableName tableName) {
        return new Path(CommonFSUtils.getNamespaceDir(rootdir, tableName.getNamespaceAsString()), tableName.getQualifierAsString());
    }

    public static Path getRegionDir(Path rootdir, TableName tableName, String regionName) {
        return new Path(CommonFSUtils.getTableDir(rootdir, tableName), regionName);
    }

    public static TableName getTableName(Path tablePath) {
        return TableName.valueOf(tablePath.getParent().getName(), tablePath.getName());
    }

    public static Path getNamespaceDir(Path rootdir, String namespace) {
        return new Path(rootdir, new Path("data", new Path(namespace)));
    }

    public static void setStoragePolicy(FileSystem fs, Path path, String storagePolicy) {
        try {
            CommonFSUtils.setStoragePolicy(fs, path, storagePolicy, false);
        }
        catch (IOException e) {
            LOG.warn("We have chosen not to throw exception but some unexpectedly thrown out", e);
        }
    }

    static void setStoragePolicy(FileSystem fs, Path path, String storagePolicy, boolean throwException) throws IOException {
        block6: {
            if (storagePolicy == null) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("We were passed a null storagePolicy, exiting early.");
                }
                return;
            }
            String trimmedStoragePolicy = storagePolicy.trim();
            if (trimmedStoragePolicy.isEmpty()) {
                LOG.trace("We were passed an empty storagePolicy, exiting early.");
                return;
            }
            if ((trimmedStoragePolicy = trimmedStoragePolicy.toUpperCase(Locale.ROOT)).equals("NONE")) {
                LOG.trace("We were passed the defer-to-hdfs policy {}, exiting early.", (Object)trimmedStoragePolicy);
                return;
            }
            try {
                CommonFSUtils.invokeSetStoragePolicy(fs, path, trimmedStoragePolicy);
            }
            catch (IOException e) {
                LOG.trace("Failed to invoke set storage policy API on FS", e);
                if (!throwException) break block6;
                throw e;
            }
        }
    }

    private static void invokeSetStoragePolicy(FileSystem fs, Path path, String storagePolicy) throws IOException {
        Exception toThrow;
        block6: {
            toThrow = null;
            try {
                fs.setStoragePolicy(path, storagePolicy);
                LOG.debug("Set storagePolicy={} for path={}", (Object)storagePolicy, (Object)path);
            }
            catch (Exception e) {
                toThrow = e;
                if (!warningMap.containsKey(fs)) {
                    warningMap.put(fs, true);
                    LOG.warn("Unable to set storagePolicy=" + storagePolicy + " for path=" + path + ". DEBUG log level might have more details.", e);
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to set storagePolicy=" + storagePolicy + " for path=" + path, e);
                }
                if (!(e instanceof UnsupportedOperationException) || !LOG.isDebugEnabled()) break block6;
                LOG.debug("The underlying FileSystem implementation doesn't support setStoragePolicy. This is probably intentional on their part, since HDFS-9345 appears to be present in your version of Hadoop. For more information check the Hadoop documentation on 'ArchivalStorage', the Hadoop FileSystem specification docs from HADOOP-11981, and/or related documentation from the provider of the underlying FileSystem (its name should appear in the stacktrace that accompanies this message). Note in particular that Hadoop's local filesystem implementation doesn't support storage policies.", e);
            }
        }
        if (toThrow != null) {
            throw new IOException(toThrow);
        }
    }

    public static boolean isHDFS(Configuration conf) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)conf);
        String scheme = fs.getUri().getScheme();
        return scheme.equalsIgnoreCase("hdfs");
    }

    public static boolean isRecoveredEdits(Path path) {
        return path.toString().contains("recovered.edits");
    }

    public static FileSystem getCurrentFileSystem(Configuration conf) throws IOException {
        return CommonFSUtils.getRootDir(conf).getFileSystem(conf);
    }

    public static FileStatus[] listStatus(FileSystem fs, Path dir, PathFilter filter) throws IOException {
        FileStatus[] status;
        block3: {
            status = null;
            try {
                status = filter == null ? fs.listStatus(dir) : fs.listStatus(dir, filter);
            }
            catch (FileNotFoundException fnfe) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace("{} doesn't exist", (Object)dir);
            }
        }
        if (status == null || status.length < 1) {
            return null;
        }
        return status;
    }

    public static FileStatus[] listStatus(FileSystem fs, Path dir) throws IOException {
        return CommonFSUtils.listStatus(fs, dir, null);
    }

    public static List<LocatedFileStatus> listLocatedStatus(FileSystem fs, Path dir) throws IOException {
        ArrayList<Object> status;
        block4: {
            status = null;
            try {
                RemoteIterator locatedFileStatusRemoteIterator = fs.listFiles(dir, false);
                while (locatedFileStatusRemoteIterator.hasNext()) {
                    if (status == null) {
                        status = Lists.newArrayList();
                    }
                    status.add(locatedFileStatusRemoteIterator.next());
                }
            }
            catch (FileNotFoundException fnfe) {
                if (!LOG.isTraceEnabled()) break block4;
                LOG.trace("{} doesn't exist", (Object)dir);
            }
        }
        return status;
    }

    public static boolean delete(FileSystem fs, Path path, boolean recursive) throws IOException {
        return fs.delete(path, recursive);
    }

    public static boolean isExists(FileSystem fs, Path path) throws IOException {
        return fs.exists(path);
    }

    public static void logFileSystemState(FileSystem fs, Path root, Logger log) throws IOException {
        log.debug("File system contents for path {}", (Object)root);
        CommonFSUtils.logFSTree(log, fs, root, "|-");
    }

    private static void logFSTree(Logger log, FileSystem fs, Path root, String prefix) throws IOException {
        FileStatus[] files = CommonFSUtils.listStatus(fs, root, null);
        if (files == null) {
            return;
        }
        for (FileStatus file : files) {
            if (file.isDirectory()) {
                log.debug(prefix + file.getPath().getName() + "/");
                CommonFSUtils.logFSTree(log, fs, file.getPath(), prefix + "---");
                continue;
            }
            log.debug(prefix + file.getPath().getName());
        }
    }

    public static boolean renameAndSetModifyTime(FileSystem fs, Path src, Path dest) throws IOException {
        fs.setTimes(src, EnvironmentEdgeManager.currentTime(), -1L);
        return fs.rename(src, dest);
    }

    public static void checkShortCircuitReadBufferSize(Configuration conf) {
        int defaultSize = 131072;
        int notSet = -1;
        String dfsKey = "dfs.client.read.shortcircuit.buffer.size";
        int size = conf.getInt("dfs.client.read.shortcircuit.buffer.size", -1);
        if (size != -1) {
            return;
        }
        int hbaseSize = conf.getInt("hbase.dfs.client.read.shortcircuit.buffer.size", 131072);
        conf.setIfUnset("dfs.client.read.shortcircuit.buffer.size", Integer.toString(hbaseSize));
    }

    public static FSDataOutputStream createForWal(FileSystem fs, Path path, boolean overwrite) throws IOException {
        FSDataOutputStreamBuilder builder = fs.createFile(path).overwrite(overwrite);
        DfsBuilderUtility.replicate(builder);
        return builder.build();
    }

    public static FSDataOutputStream createForWal(FileSystem fs, Path path, boolean overwrite, int bufferSize, short replication, long blockSize, boolean isRecursive) throws IOException {
        FSDataOutputStreamBuilder builder = fs.createFile(path).overwrite(overwrite).bufferSize(bufferSize).replication(replication).blockSize(blockSize);
        if (isRecursive) {
            builder.recursive();
        }
        DfsBuilderUtility.replicate(builder);
        return builder.build();
    }

    public static class StreamLacksCapabilityException
    extends Exception {
        public StreamLacksCapabilityException(String message, Throwable cause) {
            super(message, cause);
        }

        public StreamLacksCapabilityException(String message) {
            super(message);
        }
    }

    private static final class DfsBuilderUtility {
        private static final Class<?> BUILDER;
        private static final Method REPLICATE;

        private DfsBuilderUtility() {
        }

        static void replicate(FSDataOutputStreamBuilder<?, ?> builder) {
            if (BUILDER != null && REPLICATE != null && BUILDER.isAssignableFrom(builder.getClass())) {
                try {
                    REPLICATE.invoke(builder, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOG.warn("Couldn't use reflection with builder API", e);
                }
            }
        }

        static {
            String builderName = "org.apache.hadoop.hdfs.DistributedFileSystem$HdfsDataOutputStreamBuilder";
            Class<?> builderClass = null;
            try {
                builderClass = Class.forName(builderName);
            }
            catch (ClassNotFoundException e) {
                LOG.debug("{} not available, will not set replicate when creating output stream", (Object)builderName);
            }
            Method replicateMethod = null;
            if (builderClass != null) {
                try {
                    replicateMethod = builderClass.getMethod("replicate", new Class[0]);
                    LOG.debug("Using builder API via reflection for DFS file creation.");
                }
                catch (NoSuchMethodException e) {
                    LOG.debug("Could not find replicate method on builder; will not set replicate when creating output stream", e);
                }
            }
            BUILDER = builderClass;
            REPLICATE = replicateMethod;
        }
    }
}

