/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class MoveWithoutAck
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(MoveWithoutAck.class);
    private final RegionInfo region;
    private final ServerName targetServer;
    private final List<RegionInfo> movedRegions;
    private final ServerName sourceServer;
    private final Admin admin;

    MoveWithoutAck(Admin admin, RegionInfo regionInfo, ServerName sourceServer, ServerName targetServer, List<RegionInfo> movedRegions) {
        this.admin = admin;
        this.region = regionInfo;
        this.targetServer = targetServer;
        this.movedRegions = movedRegions;
        this.sourceServer = sourceServer;
    }

    @Override
    public Boolean call() {
        try {
            LOG.info("Moving region: {} from {} to {}", this.region.getEncodedName(), this.sourceServer, this.targetServer);
            this.admin.move(this.region.getEncodedNameAsBytes(), this.targetServer);
            LOG.info("Requested move {} from {} to {}", this.region.getEncodedName(), this.sourceServer, this.targetServer);
        }
        catch (Exception e) {
            LOG.error("Error Moving Region: {}", (Object)this.region.getEncodedName(), (Object)e);
        }
        finally {
            this.movedRegions.add(this.region);
        }
        return true;
    }
}

