/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util.hbck;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.CorruptHFileException;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.mob.MobUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.FileStatusFilter;
import org.apache.hudi.org.apache.hadoop.hbase.util.HbckErrorReporter;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HFileCorruptionChecker {
    private static final Logger LOG = LoggerFactory.getLogger(HFileCorruptionChecker.class);
    final Configuration conf;
    final FileSystem fs;
    final CacheConfig cacheConf;
    final ExecutorService executor;
    final Set<Path> corrupted = new ConcurrentSkipListSet<Path>();
    final Set<Path> failures = new ConcurrentSkipListSet<Path>();
    final Set<Path> quarantined = new ConcurrentSkipListSet<Path>();
    final Set<Path> missing = new ConcurrentSkipListSet<Path>();
    final Set<Path> corruptedMobFiles = new ConcurrentSkipListSet<Path>();
    final Set<Path> failureMobFiles = new ConcurrentSkipListSet<Path>();
    final Set<Path> missedMobFiles = new ConcurrentSkipListSet<Path>();
    final Set<Path> quarantinedMobFiles = new ConcurrentSkipListSet<Path>();
    final boolean inQuarantineMode;
    final AtomicInteger hfilesChecked = new AtomicInteger();
    final AtomicInteger mobFilesChecked = new AtomicInteger();

    public HFileCorruptionChecker(Configuration conf, ExecutorService executor, boolean quarantine) throws IOException {
        this.conf = conf;
        this.fs = FileSystem.get((Configuration)conf);
        this.cacheConf = CacheConfig.DISABLED;
        this.executor = executor;
        this.inQuarantineMode = quarantine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkHFile(Path p) throws IOException {
        HFile.Reader r = null;
        try {
            r = HFile.createReader(this.fs, p, this.cacheConf, true, this.conf);
        }
        catch (CorruptHFileException che) {
            LOG.warn("Found corrupt HFile " + p, che);
            this.corrupted.add(p);
            if (this.inQuarantineMode) {
                Path dest = this.createQuarantinePath(p);
                LOG.warn("Quarantining corrupt HFile " + p + " into " + dest);
                boolean success = this.fs.mkdirs(dest.getParent());
                boolean bl = success = success ? this.fs.rename(p, dest) : false;
                if (!success) {
                    this.failures.add(p);
                } else {
                    this.quarantined.add(dest);
                }
            }
            return;
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn("HFile " + p + " was missing.  Likely removed due to compaction/split?");
            this.missing.add(p);
        }
        finally {
            this.hfilesChecked.addAndGet(1);
            if (r != null) {
                r.close(true);
            }
        }
    }

    Path createQuarantinePath(Path hFile) throws IOException {
        Path cfDir = hFile.getParent();
        Path regionDir = cfDir.getParent();
        Path tableDir = regionDir.getParent();
        Path corruptBaseDir = new Path(CommonFSUtils.getRootDir(this.conf), "corrupt");
        if (this.conf.get("hbase.hfile.quarantine.dir") != null) {
            LOG.warn("hbase.hfile.quarantine.dir is deprecated. Default to " + corruptBaseDir);
        }
        Path corruptTableDir = new Path(corruptBaseDir, tableDir.getName());
        Path corruptRegionDir = new Path(corruptTableDir, regionDir.getName());
        Path corruptFamilyDir = new Path(corruptRegionDir, cfDir.getName());
        Path corruptHfile = new Path(corruptFamilyDir, hFile.getName());
        return corruptHfile;
    }

    protected void checkColFamDir(Path cfDir) throws IOException {
        FileStatus[] statuses = null;
        try {
            statuses = this.fs.listStatus(cfDir);
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn("Colfam Directory " + cfDir + " does not exist.  Likely due to concurrent split/compaction. Skipping.");
            this.missing.add(cfDir);
            return;
        }
        List<FileStatus> hfs = FSUtils.filterFileStatuses(statuses, (FileStatusFilter)new FSUtils.HFileFilter(this.fs));
        if (hfs.isEmpty() && !this.fs.exists(cfDir)) {
            LOG.warn("Colfam Directory " + cfDir + " does not exist.  Likely due to concurrent split/compaction. Skipping.");
            this.missing.add(cfDir);
            return;
        }
        LOG.info("Checking Column Family Directory {}. Number of entries = {}", (Object)cfDir, (Object)hfs.size());
        for (FileStatus hfFs : hfs) {
            Path hf = hfFs.getPath();
            this.checkHFile(hf);
        }
    }

    protected void checkMobColFamDir(Path cfDir) throws IOException {
        FileStatus[] statuses = null;
        try {
            statuses = this.fs.listStatus(cfDir);
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn("Mob colfam Directory " + cfDir + " does not exist.  Likely the table is deleted. Skipping.");
            this.missedMobFiles.add(cfDir);
            return;
        }
        List<FileStatus> hfs = FSUtils.filterFileStatuses(statuses, (FileStatusFilter)new FSUtils.HFileFilter(this.fs));
        if (hfs.isEmpty() && !this.fs.exists(cfDir)) {
            LOG.warn("Mob colfam Directory " + cfDir + " does not exist.  Likely the table is deleted. Skipping.");
            this.missedMobFiles.add(cfDir);
            return;
        }
        LOG.info("Checking MOB Column Family Directory {}. Number of entries = {}", (Object)cfDir, (Object)hfs.size());
        for (FileStatus hfFs : hfs) {
            Path hf = hfFs.getPath();
            this.checkMobFile(hf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkMobFile(Path p) throws IOException {
        HFile.Reader r = null;
        try {
            r = HFile.createReader(this.fs, p, this.cacheConf, true, this.conf);
        }
        catch (CorruptHFileException che) {
            LOG.warn("Found corrupt mob file " + p, che);
            this.corruptedMobFiles.add(p);
            if (this.inQuarantineMode) {
                Path dest = this.createQuarantinePath(p);
                LOG.warn("Quarantining corrupt mob file " + p + " into " + dest);
                boolean success = this.fs.mkdirs(dest.getParent());
                boolean bl = success = success ? this.fs.rename(p, dest) : false;
                if (!success) {
                    this.failureMobFiles.add(p);
                } else {
                    this.quarantinedMobFiles.add(dest);
                }
            }
            return;
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn("Mob file " + p + " was missing.  Likely removed due to compaction?");
            this.missedMobFiles.add(p);
        }
        finally {
            this.mobFilesChecked.addAndGet(1);
            if (r != null) {
                r.close(true);
            }
        }
    }

    private void checkMobRegionDir(Path regionDir) throws IOException {
        if (!this.fs.exists(regionDir)) {
            return;
        }
        FileStatus[] hfs = null;
        try {
            hfs = this.fs.listStatus(regionDir, (PathFilter)new FSUtils.FamilyDirFilter(this.fs));
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn("Mob directory " + regionDir + " does not exist.  Likely the table is deleted. Skipping.");
            this.missedMobFiles.add(regionDir);
            return;
        }
        if (hfs.length == 0 && !this.fs.exists(regionDir)) {
            LOG.warn("Mob directory " + regionDir + " does not exist.  Likely the table is deleted. Skipping.");
            this.missedMobFiles.add(regionDir);
            return;
        }
        LOG.info("Checking MOB Region Directory {}. Number of entries = {}", (Object)regionDir, (Object)hfs.length);
        for (FileStatus hfFs : hfs) {
            Path hf = hfFs.getPath();
            this.checkMobColFamDir(hf);
        }
    }

    protected void checkRegionDir(Path regionDir) throws IOException {
        FileStatus[] statuses = null;
        try {
            statuses = this.fs.listStatus(regionDir);
        }
        catch (FileNotFoundException fnfe) {
            LOG.warn("Region Directory " + regionDir + " does not exist.  Likely due to concurrent split/compaction. Skipping.");
            this.missing.add(regionDir);
            return;
        }
        List<FileStatus> cfs = FSUtils.filterFileStatuses(statuses, (FileStatusFilter)new FSUtils.FamilyDirFilter(this.fs));
        if (cfs.isEmpty() && !this.fs.exists(regionDir)) {
            LOG.warn("Region Directory " + regionDir + " does not exist.  Likely due to concurrent split/compaction. Skipping.");
            this.missing.add(regionDir);
            return;
        }
        LOG.info("Checking Region Directory {}. Number of entries = {}", (Object)regionDir, (Object)cfs.size());
        for (FileStatus cfFs : cfs) {
            Path cfDir = cfFs.getPath();
            this.checkColFamDir(cfDir);
        }
    }

    void checkTableDir(Path tableDir) throws IOException {
        List rdFutures;
        List<FileStatus> rds = FSUtils.listStatusWithStatusFilter(this.fs, tableDir, new FSUtils.RegionDirFilter(this.fs));
        if (rds == null) {
            if (!this.fs.exists(tableDir)) {
                LOG.warn("Table Directory " + tableDir + " does not exist.  Likely due to concurrent delete. Skipping.");
                this.missing.add(tableDir);
            }
            return;
        }
        LOG.info("Checking Table Directory {}. Number of entries (including mob) = {}", (Object)tableDir, (Object)(rds.size() + 1));
        ArrayList<RegionDirChecker> rdcs = new ArrayList<RegionDirChecker>(rds.size() + 1);
        for (FileStatus rdFs : rds) {
            Path rdDir = rdFs.getPath();
            RegionDirChecker work = new RegionDirChecker(rdDir);
            rdcs.add(work);
        }
        rdcs.add(this.createMobRegionDirChecker(tableDir));
        try {
            rdFutures = this.executor.invokeAll(rdcs);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            LOG.warn("Region dirs checking interrupted!", ie);
            return;
        }
        for (int i = 0; i < rdFutures.size(); ++i) {
            Future f = rdFutures.get(i);
            try {
                f.get();
                continue;
            }
            catch (ExecutionException e) {
                LOG.warn("Failed to quarantine an HFile in regiondir " + ((RegionDirChecker)rdcs.get((int)i)).regionDir, e.getCause());
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                LOG.error("Unexpected exception encountered", e);
                return;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.warn("Region dirs check interrupted!", ie);
                return;
            }
        }
    }

    private MobRegionDirChecker createMobRegionDirChecker(Path tableDir) {
        TableName tableName = CommonFSUtils.getTableName(tableDir);
        Path mobDir = MobUtils.getMobRegionPath(this.conf, tableName);
        return new MobRegionDirChecker(mobDir);
    }

    public void checkTables(Collection<Path> tables) throws IOException {
        for (Path t : tables) {
            this.checkTableDir(t);
        }
    }

    public Collection<Path> getFailures() {
        return new HashSet<Path>(this.failures);
    }

    public Collection<Path> getCorrupted() {
        return new HashSet<Path>(this.corrupted);
    }

    public int getHFilesChecked() {
        return this.hfilesChecked.get();
    }

    public Collection<Path> getQuarantined() {
        return new HashSet<Path>(this.quarantined);
    }

    public Collection<Path> getMissing() {
        return new HashSet<Path>(this.missing);
    }

    public Collection<Path> getFailureMobFiles() {
        return new HashSet<Path>(this.failureMobFiles);
    }

    public Collection<Path> getCorruptedMobFiles() {
        return new HashSet<Path>(this.corruptedMobFiles);
    }

    public int getMobFilesChecked() {
        return this.mobFilesChecked.get();
    }

    public Collection<Path> getQuarantinedMobFiles() {
        return new HashSet<Path>(this.quarantinedMobFiles);
    }

    public Collection<Path> getMissedMobFiles() {
        return new HashSet<Path>(this.missedMobFiles);
    }

    public void report(HbckErrorReporter out) {
        String fixedMobState;
        out.print("Checked " + this.hfilesChecked.get() + " hfile for corruption");
        out.print("  HFiles corrupted:                  " + this.corrupted.size());
        if (this.inQuarantineMode) {
            out.print("    HFiles successfully quarantined: " + this.quarantined.size());
            for (Path sq : this.quarantined) {
                out.print("      " + sq);
            }
            out.print("    HFiles failed quarantine:        " + this.failures.size());
            for (Path fq : this.failures) {
                out.print("      " + fq);
            }
        }
        out.print("    HFiles moved while checking:     " + this.missing.size());
        for (Path mq : this.missing) {
            out.print("      " + mq);
        }
        String initialState = this.corrupted.isEmpty() ? "OK" : "CORRUPTED";
        String fixedState = this.corrupted.size() == this.quarantined.size() ? "OK" : "CORRUPTED";
        out.print("Checked " + this.mobFilesChecked.get() + " Mob files for corruption");
        out.print("  Mob files corrupted:                  " + this.corruptedMobFiles.size());
        if (this.inQuarantineMode) {
            out.print("    Mob files successfully quarantined: " + this.quarantinedMobFiles.size());
            for (Path sq : this.quarantinedMobFiles) {
                out.print("      " + sq);
            }
            out.print("    Mob files failed quarantine:        " + this.failureMobFiles.size());
            for (Path fq : this.failureMobFiles) {
                out.print("      " + fq);
            }
        }
        out.print("    Mob files moved while checking:     " + this.missedMobFiles.size());
        for (Path mq : this.missedMobFiles) {
            out.print("      " + mq);
        }
        String initialMobState = this.corruptedMobFiles.isEmpty() ? "OK" : "CORRUPTED";
        String string = fixedMobState = this.corruptedMobFiles.size() == this.quarantinedMobFiles.size() ? "OK" : "CORRUPTED";
        if (this.inQuarantineMode) {
            out.print("Summary: " + initialState + " => " + fixedState);
            out.print("Mob summary: " + initialMobState + " => " + fixedMobState);
        } else {
            out.print("Summary: " + initialState);
            out.print("Mob summary: " + initialMobState);
        }
    }

    private class MobRegionDirChecker
    extends RegionDirChecker {
        MobRegionDirChecker(Path regionDir) {
            super(regionDir);
        }

        @Override
        public Void call() throws IOException {
            HFileCorruptionChecker.this.checkMobRegionDir(this.regionDir);
            return null;
        }
    }

    private class RegionDirChecker
    implements Callable<Void> {
        final Path regionDir;

        RegionDirChecker(Path regionDir) {
            this.regionDir = regionDir;
        }

        @Override
        public Void call() throws IOException {
            HFileCorruptionChecker.this.checkRegionDir(this.regionDir);
            return null;
        }
    }
}

