/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.OrcReaderIterator;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.MetadataNotFoundException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.Reader;
import org.apache.orc.RecordReader;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;

public class OrcUtils
extends BaseFileUtils {
    @Override
    public List<HoodieKey> fetchRecordKeyPartitionPath(Configuration configuration, Path filePath) {
        ArrayList<HoodieKey> hoodieKeys = new ArrayList<HoodieKey>();
        try {
            if (!filePath.getFileSystem(configuration).exists(filePath)) {
                return new ArrayList<HoodieKey>();
            }
            Configuration conf = new Configuration(configuration);
            conf.addResource(FSUtils.getFs(filePath.toString(), conf).getConf());
            Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            Schema readSchema = HoodieAvroUtils.getRecordKeyPartitionPathSchema();
            TypeDescription orcSchema = AvroOrcUtils.createOrcSchema(readSchema);
            List fieldNames = orcSchema.getFieldNames();
            VectorizedRowBatch batch = orcSchema.createRowBatch();
            RecordReader recordReader = reader.rows(new Reader.Options(conf).schema(orcSchema));
            int keyCol = -1;
            int partitionCol = -1;
            for (int i = 0; i < fieldNames.size(); ++i) {
                if (((String)fieldNames.get(i)).equals("_hoodie_record_key")) {
                    keyCol = i;
                }
                if (!((String)fieldNames.get(i)).equals("_hoodie_partition_path")) continue;
                partitionCol = i;
            }
            if (keyCol == -1 || partitionCol == -1) {
                throw new HoodieException(String.format("Couldn't find row keys or partition path in %s.", filePath));
            }
            while (recordReader.nextBatch(batch)) {
                BytesColumnVector rowKeys = (BytesColumnVector)batch.cols[keyCol];
                BytesColumnVector partitionPaths = (BytesColumnVector)batch.cols[partitionCol];
                for (int i = 0; i < batch.size; ++i) {
                    String rowKey = rowKeys.toString(i);
                    String partitionPath = partitionPaths.toString(i);
                    hoodieKeys.add(new HoodieKey(rowKey, partitionPath));
                }
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to read from ORC file:" + filePath, e);
        }
        return hoodieKeys;
    }

    @Override
    public List<HoodieKey> fetchRecordKeyPartitionPath(Configuration configuration, Path filePath, Option<BaseKeyGenerator> keyGeneratorOpt) {
        throw new HoodieIOException("UnsupportedOperation : Disabling meta fields not yet supported for Orc");
    }

    @Override
    public List<GenericRecord> readAvroRecords(Configuration configuration, Path filePath) {
        Schema avroSchema;
        try {
            Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)configuration));
            avroSchema = AvroOrcUtils.createAvroSchema(reader.getSchema());
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read Avro records from an ORC file:" + filePath, io);
        }
        return this.readAvroRecords(configuration, filePath, avroSchema);
    }

    @Override
    public List<GenericRecord> readAvroRecords(Configuration configuration, Path filePath, Schema avroSchema) {
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        try {
            Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)configuration));
            TypeDescription orcSchema = reader.getSchema();
            RecordReader recordReader = reader.rows(new Reader.Options(configuration).schema(orcSchema));
            OrcReaderIterator iterator = new OrcReaderIterator(recordReader, avroSchema, orcSchema);
            while (iterator.hasNext()) {
                GenericRecord record = (GenericRecord)iterator.next();
                records.add(record);
            }
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to create an ORC reader for ORC file:" + filePath, io);
        }
        return records;
    }

    @Override
    public Set<String> filterRowKeys(Configuration conf, Path filePath, Set<String> filter) throws HoodieIOException {
        try {
            Reader reader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            HashSet<String> filteredRowKeys = new HashSet<String>();
            TypeDescription schema = reader.getSchema();
            List fieldNames = schema.getFieldNames();
            VectorizedRowBatch batch = schema.createRowBatch();
            RecordReader recordReader = reader.rows(new Reader.Options(conf).schema(schema));
            int colIndex = -1;
            for (int i = 0; i < fieldNames.size(); ++i) {
                if (!((String)fieldNames.get(i)).equals("_hoodie_record_key")) continue;
                colIndex = i;
                break;
            }
            if (colIndex == -1) {
                throw new HoodieException(String.format("Couldn't find row keys in %s.", filePath));
            }
            while (recordReader.nextBatch(batch)) {
                BytesColumnVector rowKeys = (BytesColumnVector)batch.cols[colIndex];
                for (int i = 0; i < batch.size; ++i) {
                    String rowKey = rowKeys.toString(i);
                    if (!filter.isEmpty() && !filter.contains(rowKey)) continue;
                    filteredRowKeys.add(rowKey);
                }
            }
            return filteredRowKeys;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read row keys for ORC file:" + filePath, io);
        }
    }

    @Override
    public Map<String, String> readFooter(Configuration conf, boolean required, Path orcFilePath, String ... footerNames) {
        try {
            Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            HashMap<String, String> footerVals = new HashMap<String, String>();
            List metadataItemList = reader.getFileTail().getFooter().getMetadataList();
            Map<String, String> metadata = metadataItemList.stream().collect(Collectors.toMap(OrcProto.UserMetadataItem::getName, metadataItem -> metadataItem.getValue().toStringUtf8()));
            for (String footerName : footerNames) {
                if (metadata.containsKey(footerName)) {
                    footerVals.put(footerName, metadata.get(footerName));
                    continue;
                }
                if (!required) continue;
                throw new MetadataNotFoundException("Could not find index in ORC footer. Looked for key " + footerName + " in " + orcFilePath);
            }
            return footerVals;
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to read footer for ORC file:" + orcFilePath, io);
        }
    }

    @Override
    public Schema readAvroSchema(Configuration conf, Path orcFilePath) {
        try {
            Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            TypeDescription orcSchema = reader.getSchema();
            return AvroOrcUtils.createAvroSchema(orcSchema);
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to get Avro schema for ORC file:" + orcFilePath, io);
        }
    }

    @Override
    public long getRowCount(Configuration conf, Path orcFilePath) {
        try {
            Reader reader = OrcFile.createReader((Path)orcFilePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)conf));
            return reader.getNumberOfRows();
        }
        catch (IOException io) {
            throw new HoodieIOException("Unable to get row count for ORC file:" + orcFilePath, io);
        }
    }
}

