/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Delete;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.Put;
import org.apache.hudi.org.apache.hadoop.hbase.client.Row;
import org.apache.hudi.org.apache.hadoop.hbase.client.WrongRowIOException;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RowMutations
implements Row {
    private final List<Mutation> mutations = new ArrayList<Mutation>();
    private byte[] row;

    public RowMutations() {
    }

    public RowMutations(byte[] row) {
        Mutation.checkRow(row);
        this.row = Bytes.copy(row);
    }

    public void add(Put p) throws IOException {
        this.internalAdd(p);
    }

    public void add(Delete d) throws IOException {
        this.internalAdd(d);
    }

    private void internalAdd(Mutation m) throws IOException {
        int res = Bytes.compareTo(this.row, m.getRow());
        if (res != 0) {
            throw new WrongRowIOException("The row in the recently added Put/Delete <" + Bytes.toStringBinary(m.getRow()) + "> doesn't match the original one <" + Bytes.toStringBinary(this.row) + ">");
        }
        this.mutations.add(m);
    }

    @Override
    public int compareTo(Row i) {
        return Bytes.compareTo(this.getRow(), i.getRow());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof RowMutations) {
            RowMutations other = (RowMutations)obj;
            return this.compareTo(other) == 0;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.row);
    }

    @Override
    public byte[] getRow() {
        return this.row;
    }

    public List<Mutation> getMutations() {
        return Collections.unmodifiableList(this.mutations);
    }
}

