/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class HFileDataBlockEncoderImpl
implements HFileDataBlockEncoder {
    private final DataBlockEncoding encoding;

    public HFileDataBlockEncoderImpl(DataBlockEncoding encoding) {
        this.encoding = encoding != null ? encoding : DataBlockEncoding.NONE;
    }

    public static HFileDataBlockEncoder createFromFileInfo(HFile.FileInfo fileInfo) throws IOException {
        DataBlockEncoding encoding = DataBlockEncoding.NONE;
        byte[] dataBlockEncodingType = fileInfo.get(DATA_BLOCK_ENCODING);
        if (dataBlockEncodingType != null) {
            String dataBlockEncodingStr = Bytes.toString(dataBlockEncodingType);
            try {
                encoding = DataBlockEncoding.valueOf(dataBlockEncodingStr);
            }
            catch (IllegalArgumentException ex) {
                throw new IOException("Invalid data block encoding type in file info: " + dataBlockEncodingStr, ex);
            }
        }
        if (encoding == DataBlockEncoding.NONE) {
            return NoOpDataBlockEncoder.INSTANCE;
        }
        return new HFileDataBlockEncoderImpl(encoding);
    }

    @Override
    public void saveMetadata(HFile.Writer writer) throws IOException {
        writer.appendFileInfo(DATA_BLOCK_ENCODING, this.encoding.getNameInBytes());
    }

    @Override
    public DataBlockEncoding getDataBlockEncoding() {
        return this.encoding;
    }

    public boolean useEncodedScanner(boolean isCompaction) {
        if (isCompaction && this.encoding == DataBlockEncoding.NONE) {
            return false;
        }
        return this.encoding != DataBlockEncoding.NONE;
    }

    @Override
    public DataBlockEncoding getEffectiveEncodingInCache(boolean isCompaction) {
        if (!this.useEncodedScanner(isCompaction)) {
            return DataBlockEncoding.NONE;
        }
        return this.encoding;
    }

    @Override
    public int encode(Cell cell, HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        return this.encoding.getEncoder().encode(cell, encodingCtx, out);
    }

    @Override
    public boolean useEncodedScanner() {
        return this.encoding != DataBlockEncoding.NONE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(encoding=" + (Object)((Object)this.encoding) + ")";
    }

    @Override
    public HFileBlockEncodingContext newDataBlockEncodingContext(byte[] dummyHeader, HFileContext fileContext) {
        DataBlockEncoder encoder = this.encoding.getEncoder();
        if (encoder != null) {
            return encoder.newDataBlockEncodingContext(this.encoding, dummyHeader, fileContext);
        }
        return new HFileBlockDefaultEncodingContext(null, dummyHeader, fileContext);
    }

    @Override
    public HFileBlockDecodingContext newDataBlockDecodingContext(HFileContext fileContext) {
        DataBlockEncoder encoder = this.encoding.getEncoder();
        if (encoder != null) {
            return encoder.newDataBlockDecodingContext(fileContext);
        }
        return new HFileBlockDefaultDecodingContext(fileContext);
    }

    @Override
    public void startBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out) throws IOException {
        if (this.encoding != null && this.encoding != DataBlockEncoding.NONE) {
            this.encoding.getEncoder().startBlockEncoding(encodingCtx, out);
        }
    }

    @Override
    public void endBlockEncoding(HFileBlockEncodingContext encodingCtx, DataOutputStream out, byte[] uncompressedBytesWithHeader, BlockType blockType) throws IOException {
        this.encoding.getEncoder().endBlockEncoding(encodingCtx, out, uncompressedBytesWithHeader);
    }
}

