/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.mapreduce;

import org.apache.hadoop.util.ProgramDriver;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.CellCounter;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.CopyTable;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.Export;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.Import;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.RowCounter;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.WALPlayer;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication;
import org.apache.hudi.org.apache.hadoop.hbase.snapshot.ExportSnapshot;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Stable
public class Driver {
    public static void main(String[] args) throws Throwable {
        ProgramDriver pgd = new ProgramDriver();
        pgd.addClass("rowcounter", RowCounter.class, "Count rows in HBase table.");
        pgd.addClass("CellCounter", CellCounter.class, "Count cells in HBase table.");
        pgd.addClass("export", Export.class, "Write table data to HDFS.");
        pgd.addClass("import", Import.class, "Import data written by Export.");
        pgd.addClass("importtsv", ImportTsv.class, "Import data in TSV format.");
        pgd.addClass("completebulkload", LoadIncrementalHFiles.class, "Complete a bulk data load.");
        pgd.addClass("copytable", CopyTable.class, "Export a table from local cluster to peer cluster.");
        pgd.addClass("verifyrep", VerifyReplication.class, "Compare the data from tables in two different clusters. WARNING: It doesn't work for incrementColumnValues'd cells since the timestamp is changed after being appended to the log.");
        pgd.addClass("WALPlayer", WALPlayer.class, "Replay WAL files.");
        pgd.addClass("exportsnapshot", ExportSnapshot.class, "Export the specific snapshot to a given FileSystem.");
        ProgramDriver.class.getMethod("driver", String[].class).invoke((Object)pgd, new Object[]{args});
    }
}

