/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hudi.com.google.common.collect.Lists;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.MultiTableSnapshotInputFormatImpl;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormatImpl;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class MultiTableSnapshotInputFormat
extends TableSnapshotInputFormat {
    private final MultiTableSnapshotInputFormatImpl delegate = new MultiTableSnapshotInputFormatImpl();

    @Override
    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        List<TableSnapshotInputFormatImpl.InputSplit> splits = this.delegate.getSplits(jobContext.getConfiguration());
        ArrayList<InputSplit> rtn = Lists.newArrayListWithCapacity(splits.size());
        for (TableSnapshotInputFormatImpl.InputSplit split : splits) {
            rtn.add(new TableSnapshotInputFormat.TableSnapshotRegionSplit(split));
        }
        return rtn;
    }

    public static void setInput(Configuration configuration, Map<String, Collection<Scan>> snapshotScans, Path tmpRestoreDir) throws IOException {
        new MultiTableSnapshotInputFormatImpl().setInput(configuration, snapshotScans, tmpRestoreDir);
    }
}

