/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hudi.org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterDDLOperationHelper;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureUtil;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.MasterProcedureProtos;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;

@InterfaceAudience.Private
public class ModifyColumnFamilyProcedure
extends StateMachineProcedure<MasterProcedureEnv, MasterProcedureProtos.ModifyColumnFamilyState>
implements TableProcedureInterface {
    private static final Log LOG = LogFactory.getLog(ModifyColumnFamilyProcedure.class);
    private final AtomicBoolean aborted = new AtomicBoolean(false);
    private TableName tableName;
    private HTableDescriptor unmodifiedHTableDescriptor;
    private HColumnDescriptor cfDescriptor;
    private UserGroupInformation user;
    private Boolean traceEnabled;

    public ModifyColumnFamilyProcedure() {
        this.unmodifiedHTableDescriptor = null;
        this.traceEnabled = null;
    }

    public ModifyColumnFamilyProcedure(MasterProcedureEnv env, TableName tableName, HColumnDescriptor cfDescriptor) throws IOException {
        this.tableName = tableName;
        this.cfDescriptor = cfDescriptor;
        this.user = env.getRequestUser().getUGI();
        this.setOwner(this.user.getShortUserName());
        this.unmodifiedHTableDescriptor = null;
        this.traceEnabled = null;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws InterruptedException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " execute state=" + state));
        }
        try {
            switch (state) {
                case MODIFY_COLUMN_FAMILY_PREPARE: {
                    this.prepareModify(env);
                    this.setNextState(MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_PRE_OPERATION);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_PRE_OPERATION: {
                    this.preModify(env, state);
                    this.setNextState(MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.updateTableDescriptor(env);
                    this.setNextState(MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_POST_OPERATION);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_POST_OPERATION: {
                    this.postModify(env, state);
                    this.setNextState(MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_REOPEN_ALL_REGIONS);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    this.reOpenAllRegionsIfTableIsOnline(env);
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Error trying to modify the column family " + this.getColumnFamilyName() + " of the table " + this.tableName + "(in state=" + state + ")"), (Throwable)e);
            this.setFailure("master-modify-columnfamily", e);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws IOException {
        if (this.isTraceEnabled().booleanValue()) {
            LOG.trace((Object)(this + " rollback state=" + state));
        }
        try {
            switch (state) {
                case MODIFY_COLUMN_FAMILY_REOPEN_ALL_REGIONS: {
                    break;
                }
                case MODIFY_COLUMN_FAMILY_POST_OPERATION: {
                    break;
                }
                case MODIFY_COLUMN_FAMILY_UPDATE_TABLE_DESCRIPTOR: {
                    this.restoreTableDescriptor(env);
                    break;
                }
                case MODIFY_COLUMN_FAMILY_PRE_OPERATION: {
                    break;
                }
                case MODIFY_COLUMN_FAMILY_PREPARE: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed rollback attempt step " + state + " for adding the column family" + this.getColumnFamilyName() + " to the table " + this.tableName), (Throwable)e);
            throw e;
        }
    }

    protected MasterProcedureProtos.ModifyColumnFamilyState getState(int stateId) {
        return MasterProcedureProtos.ModifyColumnFamilyState.valueOf(stateId);
    }

    protected int getStateId(MasterProcedureProtos.ModifyColumnFamilyState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.ModifyColumnFamilyState getInitialState() {
        return MasterProcedureProtos.ModifyColumnFamilyState.MODIFY_COLUMN_FAMILY_PREPARE;
    }

    protected void setNextState(MasterProcedureProtos.ModifyColumnFamilyState state) {
        if (this.aborted.get()) {
            this.setAbortFailure("modify-columnfamily", "abort requested");
        } else {
            super.setNextState((Object)state);
        }
    }

    public boolean abort(MasterProcedureEnv env) {
        this.aborted.set(true);
        return true;
    }

    protected boolean acquireLock(MasterProcedureEnv env) {
        if (env.waitInitialized((Procedure)this)) {
            return false;
        }
        return env.getProcedureQueue().tryAcquireTableExclusiveLock((Procedure)this, this.tableName);
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureQueue().releaseTableExclusiveLock((Procedure)this, this.tableName);
    }

    public void serializeStateData(OutputStream stream) throws IOException {
        super.serializeStateData(stream);
        MasterProcedureProtos.ModifyColumnFamilyStateData.Builder modifyCFMsg = MasterProcedureProtos.ModifyColumnFamilyStateData.newBuilder().setUserInfo(MasterProcedureUtil.toProtoUserInfo(this.user)).setTableName(ProtobufUtil.toProtoTableName(this.tableName)).setColumnfamilySchema(this.cfDescriptor.convert());
        if (this.unmodifiedHTableDescriptor != null) {
            modifyCFMsg.setUnmodifiedTableSchema(this.unmodifiedHTableDescriptor.convert());
        }
        modifyCFMsg.build().writeDelimitedTo(stream);
    }

    public void deserializeStateData(InputStream stream) throws IOException {
        super.deserializeStateData(stream);
        MasterProcedureProtos.ModifyColumnFamilyStateData modifyCFMsg = MasterProcedureProtos.ModifyColumnFamilyStateData.parseDelimitedFrom(stream);
        this.user = MasterProcedureUtil.toUserInfo(modifyCFMsg.getUserInfo());
        this.tableName = ProtobufUtil.toTableName(modifyCFMsg.getTableName());
        this.cfDescriptor = HColumnDescriptor.convert(modifyCFMsg.getColumnfamilySchema());
        if (modifyCFMsg.hasUnmodifiedTableSchema()) {
            this.unmodifiedHTableDescriptor = HTableDescriptor.convert(modifyCFMsg.getUnmodifiedTableSchema());
        }
    }

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(" (table=");
        sb.append(this.tableName);
        sb.append(", columnfamily=");
        if (this.cfDescriptor != null) {
            sb.append(this.getColumnFamilyName());
        } else {
            sb.append("Unknown");
        }
        sb.append(")");
    }

    @Override
    public TableName getTableName() {
        return this.tableName;
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.EDIT;
    }

    private void prepareModify(MasterProcedureEnv env) throws IOException {
        MasterDDLOperationHelper.checkTableModifiable(env, this.tableName);
        this.unmodifiedHTableDescriptor = env.getMasterServices().getTableDescriptors().get(this.tableName);
        if (this.unmodifiedHTableDescriptor == null) {
            throw new IOException("HTableDescriptor missing for " + this.tableName);
        }
        if (!this.unmodifiedHTableDescriptor.hasFamily(this.cfDescriptor.getName())) {
            throw new InvalidFamilyOperationException("Family '" + this.getColumnFamilyName() + "' does not exist, so it cannot be modified");
        }
    }

    private void preModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void updateTableDescriptor(MasterProcedureEnv env) throws IOException {
        LOG.info((Object)("ModifyColumnFamily. Table = " + this.tableName + " HCD = " + this.cfDescriptor.toString()));
        HTableDescriptor htd = env.getMasterServices().getTableDescriptors().get(this.tableName);
        htd.modifyFamily(this.cfDescriptor);
        env.getMasterServices().getTableDescriptors().add(htd);
    }

    private void restoreTableDescriptor(MasterProcedureEnv env) throws IOException {
        env.getMasterServices().getTableDescriptors().add(this.unmodifiedHTableDescriptor);
        this.reOpenAllRegionsIfTableIsOnline(env);
    }

    private void postModify(MasterProcedureEnv env, MasterProcedureProtos.ModifyColumnFamilyState state) throws IOException, InterruptedException {
        this.runCoprocessorAction(env, state);
    }

    private void reOpenAllRegionsIfTableIsOnline(MasterProcedureEnv env) throws IOException {
        if (!env.getMasterServices().getAssignmentManager().getTableStateManager().isTableState(this.getTableName(), ZooKeeperProtos.Table.State.ENABLED)) {
            return;
        }
        List<HRegionInfo> regionInfoList = ProcedureSyncWait.getRegionsFromMeta(env, this.getTableName());
        if (MasterDDLOperationHelper.reOpenAllRegions(env, this.getTableName(), regionInfoList)) {
            LOG.info((Object)("Completed add column family operation on table " + this.getTableName()));
        } else {
            LOG.warn((Object)("Error on reopening the regions on table " + this.getTableName()));
        }
    }

    private Boolean isTraceEnabled() {
        if (this.traceEnabled == null) {
            this.traceEnabled = LOG.isTraceEnabled();
        }
        return this.traceEnabled;
    }

    private String getColumnFamilyName() {
        return this.cfDescriptor.getNameAsString();
    }

    private void runCoprocessorAction(MasterProcedureEnv env, final MasterProcedureProtos.ModifyColumnFamilyState state) throws IOException, InterruptedException {
        final MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    switch (state) {
                        case MODIFY_COLUMN_FAMILY_PRE_OPERATION: {
                            cpHost.preModifyColumnHandler(ModifyColumnFamilyProcedure.this.tableName, ModifyColumnFamilyProcedure.this.cfDescriptor);
                            break;
                        }
                        case MODIFY_COLUMN_FAMILY_POST_OPERATION: {
                            cpHost.postModifyColumnHandler(ModifyColumnFamilyProcedure.this.tableName, ModifyColumnFamilyProcedure.this.cfDescriptor);
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException(this + " unhandled state=" + state);
                        }
                    }
                    return null;
                }
            });
        }
    }
}

