/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.client.Mutation;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.OperationQuota;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiter;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.ThrottlingException;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class DefaultOperationQuota
implements OperationQuota {
    private static final Log LOG = LogFactory.getLog(DefaultOperationQuota.class);
    private final List<QuotaLimiter> limiters;
    private long writeAvailable = 0L;
    private long readAvailable = 0L;
    private long writeConsumed = 0L;
    private long readConsumed = 0L;
    private OperationQuota.AvgOperationSize avgOpSize = new OperationQuota.AvgOperationSize();

    public DefaultOperationQuota(QuotaLimiter ... limiters) {
        this(Arrays.asList(limiters));
    }

    public DefaultOperationQuota(List<QuotaLimiter> limiters) {
        this.limiters = limiters;
    }

    @Override
    public void checkQuota(int numWrites, int numReads, int numScans) throws ThrottlingException {
        this.writeConsumed = this.estimateConsume(OperationQuota.OperationType.MUTATE, numWrites, 100L);
        this.readConsumed = this.estimateConsume(OperationQuota.OperationType.GET, numReads, 100L);
        this.readConsumed += this.estimateConsume(OperationQuota.OperationType.SCAN, numScans, 1000L);
        this.writeAvailable = Long.MAX_VALUE;
        this.readAvailable = Long.MAX_VALUE;
        for (QuotaLimiter limiter : this.limiters) {
            if (limiter.isBypass()) continue;
            limiter.checkQuota(this.writeConsumed, this.readConsumed);
            this.readAvailable = Math.min(this.readAvailable, limiter.getReadAvailable());
            this.writeAvailable = Math.min(this.writeAvailable, limiter.getWriteAvailable());
        }
        for (QuotaLimiter limiter : this.limiters) {
            limiter.grabQuota(this.writeConsumed, this.readConsumed);
        }
    }

    @Override
    public void close() {
        long getSize = this.avgOpSize.getAvgOperationSize(OperationQuota.OperationType.GET);
        long scanSize = this.avgOpSize.getAvgOperationSize(OperationQuota.OperationType.SCAN);
        long mutationSize = this.avgOpSize.getAvgOperationSize(OperationQuota.OperationType.MUTATE);
        for (QuotaLimiter limiter : this.limiters) {
            limiter.addOperationSize(OperationQuota.OperationType.GET, getSize);
            limiter.addOperationSize(OperationQuota.OperationType.SCAN, scanSize);
            limiter.addOperationSize(OperationQuota.OperationType.MUTATE, mutationSize);
        }
        long writeDiff = this.avgOpSize.getOperationSize(OperationQuota.OperationType.MUTATE) - this.writeConsumed;
        long readDiff = this.avgOpSize.getOperationSize(OperationQuota.OperationType.GET) + this.avgOpSize.getOperationSize(OperationQuota.OperationType.SCAN) - this.readConsumed;
        for (QuotaLimiter limiter : this.limiters) {
            if (writeDiff != 0L) {
                limiter.consumeWrite(writeDiff);
            }
            if (readDiff == 0L) continue;
            limiter.consumeRead(readDiff);
        }
    }

    @Override
    public long getReadAvailable() {
        return this.readAvailable;
    }

    @Override
    public long getWriteAvailable() {
        return this.writeAvailable;
    }

    @Override
    public void addGetResult(Result result) {
        this.avgOpSize.addGetResult(result);
    }

    @Override
    public void addScanResult(List<Result> results) {
        this.avgOpSize.addScanResult(results);
    }

    @Override
    public void addMutation(Mutation mutation) {
        this.avgOpSize.addMutation(mutation);
    }

    @Override
    public long getAvgOperationSize(OperationQuota.OperationType type) {
        return this.avgOpSize.getAvgOperationSize(type);
    }

    private long estimateConsume(OperationQuota.OperationType type, int numReqs, long avgSize) {
        if (numReqs > 0) {
            for (QuotaLimiter limiter : this.limiters) {
                long size = limiter.getAvgOperationSize(type);
                if (size <= 0L) continue;
                avgSize = size;
                break;
            }
            return avgSize * (long)numReqs;
        }
        return 0L;
    }
}

