/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hudi.org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hudi.org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.io.Reference;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSHDFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;

@InterfaceAudience.Private
public class HRegionFileSystem {
    private static final Log LOG = LogFactory.getLog(HRegionFileSystem.class);
    public static final String REGION_INFO_FILE = ".regioninfo";
    public static final String REGION_MERGES_DIR = ".merges";
    public static final String REGION_SPLITS_DIR = ".splits";
    private static final String REGION_TEMP_DIR = ".tmp";
    private final HRegionInfo regionInfo;
    private final HRegionInfo regionInfoForFs;
    private final Configuration conf;
    private final Path tableDir;
    private final FileSystem fs;
    private final int hdfsClientRetriesNumber;
    private final int baseSleepBeforeRetries;
    private static final int DEFAULT_HDFS_CLIENT_RETRIES_NUMBER = 10;
    private static final int DEFAULT_BASE_SLEEP_BEFORE_RETRIES = 1000;

    HRegionFileSystem(Configuration conf, FileSystem fs, Path tableDir, HRegionInfo regionInfo) {
        this.fs = fs;
        this.conf = conf;
        this.tableDir = tableDir;
        this.regionInfo = regionInfo;
        this.regionInfoForFs = ServerRegionReplicaUtil.getRegionInfoForFs(regionInfo);
        this.hdfsClientRetriesNumber = conf.getInt("hdfs.client.retries.number", 10);
        this.baseSleepBeforeRetries = conf.getInt("hdfs.client.sleep.before.retries", 1000);
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public HRegionInfo getRegionInfoForFS() {
        return this.regionInfoForFs;
    }

    public Path getTableDir() {
        return this.tableDir;
    }

    public Path getRegionDir() {
        return new Path(this.tableDir, this.regionInfoForFs.getEncodedName());
    }

    Path getTempDir() {
        return new Path(this.getRegionDir(), REGION_TEMP_DIR);
    }

    void cleanupTempDir() throws IOException {
        this.deleteDir(this.getTempDir());
    }

    public Path getStoreDir(String familyName) {
        return new Path(this.getRegionDir(), familyName);
    }

    Path createStoreDir(String familyName) throws IOException {
        Path storeDir = this.getStoreDir(familyName);
        if (!this.fs.exists(storeDir) && !this.createDir(storeDir)) {
            throw new IOException("Failed creating " + storeDir);
        }
        return storeDir;
    }

    public Collection<StoreFileInfo> getStoreFiles(byte[] familyName) throws IOException {
        return this.getStoreFiles(Bytes.toString(familyName));
    }

    public Collection<StoreFileInfo> getStoreFiles(String familyName) throws IOException {
        return this.getStoreFiles(familyName, true);
    }

    public Collection<StoreFileInfo> getStoreFiles(String familyName, boolean validate) throws IOException {
        Path familyDir = this.getStoreDir(familyName);
        FileStatus[] files = FSUtils.listStatus(this.fs, familyDir);
        if (files == null) {
            LOG.debug((Object)("No StoreFiles for: " + familyDir));
            return null;
        }
        ArrayList<StoreFileInfo> storeFiles = new ArrayList<StoreFileInfo>(files.length);
        for (FileStatus status : files) {
            if (validate && !StoreFileInfo.isValid(status)) {
                LOG.warn((Object)("Invalid StoreFile: " + status.getPath()));
                continue;
            }
            StoreFileInfo info = ServerRegionReplicaUtil.getStoreFileInfo(this.conf, this.fs, this.regionInfo, this.regionInfoForFs, familyName, status.getPath());
            storeFiles.add(info);
        }
        return storeFiles;
    }

    Path getStoreFilePath(String familyName, String fileName) {
        Path familyDir = this.getStoreDir(familyName);
        return new Path(familyDir, fileName).makeQualified(this.fs);
    }

    StoreFileInfo getStoreFileInfo(String familyName, String fileName) throws IOException {
        Path familyDir = this.getStoreDir(familyName);
        return ServerRegionReplicaUtil.getStoreFileInfo(this.conf, this.fs, this.regionInfo, this.regionInfoForFs, familyName, new Path(familyDir, fileName));
    }

    public boolean hasReferences(String familyName) throws IOException {
        FileStatus[] files = FSUtils.listStatus(this.fs, this.getStoreDir(familyName), new FSUtils.ReferenceFileFilter(this.fs));
        return files != null && files.length > 0;
    }

    public boolean hasReferences(HTableDescriptor htd) throws IOException {
        for (HColumnDescriptor family : htd.getFamilies()) {
            if (!this.hasReferences(family.getNameAsString())) continue;
            return true;
        }
        return false;
    }

    public Collection<String> getFamilies() throws IOException {
        FileStatus[] fds = FSUtils.listStatus(this.fs, this.getRegionDir(), new FSUtils.FamilyDirFilter(this.fs));
        if (fds == null) {
            return null;
        }
        ArrayList<String> families = new ArrayList<String>(fds.length);
        for (FileStatus status : fds) {
            families.add(status.getPath().getName());
        }
        return families;
    }

    public void deleteFamily(String familyName) throws IOException {
        HFileArchiver.archiveFamily(this.fs, this.conf, this.regionInfoForFs, this.tableDir, Bytes.toBytes(familyName));
        Path familyDir = this.getStoreDir(familyName);
        if (this.fs.exists(familyDir) && !this.deleteDir(familyDir)) {
            throw new IOException("Could not delete family " + familyName + " from FileSystem for region " + this.regionInfoForFs.getRegionNameAsString() + "(" + this.regionInfoForFs.getEncodedName() + ")");
        }
    }

    private static String generateUniqueName(String suffix) {
        String name = UUID.randomUUID().toString().replaceAll("-", "");
        if (suffix != null) {
            name = name + suffix;
        }
        return name;
    }

    public Path createTempName() {
        return this.createTempName(null);
    }

    public Path createTempName(String suffix) {
        return new Path(this.getTempDir(), HRegionFileSystem.generateUniqueName(suffix));
    }

    public Path commitStoreFile(String familyName, Path buildPath) throws IOException {
        return this.commitStoreFile(familyName, buildPath, -1L, false);
    }

    private Path commitStoreFile(String familyName, Path buildPath, long seqNum, boolean generateNewName) throws IOException {
        Path storeDir = this.getStoreDir(familyName);
        if (!this.fs.exists(storeDir) && !this.createDir(storeDir)) {
            throw new IOException("Failed creating " + storeDir);
        }
        String name = buildPath.getName();
        if (generateNewName) {
            name = HRegionFileSystem.generateUniqueName(seqNum < 0L ? null : "_SeqId_" + seqNum + "_");
        }
        Path dstPath = new Path(storeDir, name);
        if (!this.fs.exists(buildPath)) {
            throw new FileNotFoundException(buildPath.toString());
        }
        LOG.debug((Object)("Committing store file " + buildPath + " as " + dstPath));
        if (!this.rename(buildPath, dstPath)) {
            throw new IOException("Failed rename of " + buildPath + " to " + dstPath);
        }
        return dstPath;
    }

    void commitStoreFiles(Map<byte[], List<StoreFile>> storeFiles) throws IOException {
        for (Map.Entry<byte[], List<StoreFile>> es : storeFiles.entrySet()) {
            String familyName = Bytes.toString(es.getKey());
            for (StoreFile sf : es.getValue()) {
                this.commitStoreFile(familyName, sf.getPath());
            }
        }
    }

    public void removeStoreFile(String familyName, Path filePath) throws IOException {
        HFileArchiver.archiveStoreFile(this.conf, this.fs, this.regionInfoForFs, this.tableDir, Bytes.toBytes(familyName), filePath);
    }

    public void removeStoreFiles(String familyName, Collection<StoreFile> storeFiles) throws IOException {
        HFileArchiver.archiveStoreFiles(this.conf, this.fs, this.regionInfoForFs, this.tableDir, Bytes.toBytes(familyName), storeFiles);
    }

    Path bulkLoadStoreFile(String familyName, Path srcPath, long seqNum) throws IOException {
        FileSystem desFs;
        FileSystem srcFs = srcPath.getFileSystem(this.conf);
        FileSystem fileSystem = desFs = this.fs instanceof HFileSystem ? ((HFileSystem)this.fs).getBackingFs() : this.fs;
        if (!FSHDFSUtils.isSameHdfs(this.conf, srcFs, desFs)) {
            LOG.info((Object)("Bulk-load file " + srcPath + " is on different filesystem than " + "the destination store. Copying file over to destination filesystem."));
            Path tmpPath = this.createTempName();
            FileUtil.copy((FileSystem)srcFs, (Path)srcPath, (FileSystem)this.fs, (Path)tmpPath, (boolean)false, (Configuration)this.conf);
            LOG.info((Object)("Copied " + srcPath + " to temporary path on destination filesystem: " + tmpPath));
            srcPath = tmpPath;
        }
        return this.commitStoreFile(familyName, srcPath, seqNum, true);
    }

    Path getSplitsDir() {
        return new Path(this.getRegionDir(), REGION_SPLITS_DIR);
    }

    Path getSplitsDir(HRegionInfo hri) {
        return new Path(this.getSplitsDir(), hri.getEncodedName());
    }

    void cleanupSplitsDir() throws IOException {
        this.deleteDir(this.getSplitsDir());
    }

    void cleanupAnySplitDetritus() throws IOException {
        Path splitdir = this.getSplitsDir();
        if (!this.fs.exists(splitdir)) {
            return;
        }
        FileStatus[] daughters = FSUtils.listStatus(this.fs, splitdir, new FSUtils.DirFilter(this.fs));
        if (daughters != null) {
            for (FileStatus daughter : daughters) {
                Path daughterDir = new Path(this.getTableDir(), daughter.getPath().getName());
                if (!this.fs.exists(daughterDir) || this.deleteDir(daughterDir)) continue;
                throw new IOException("Failed delete of " + daughterDir);
            }
        }
        this.cleanupSplitsDir();
        LOG.info((Object)("Cleaned up old failed split transaction detritus: " + splitdir));
    }

    void cleanupDaughterRegion(HRegionInfo regionInfo) throws IOException {
        Path regionDir = new Path(this.tableDir, regionInfo.getEncodedName());
        if (this.fs.exists(regionDir) && !this.deleteDir(regionDir)) {
            throw new IOException("Failed delete of " + regionDir);
        }
    }

    Path commitDaughterRegion(HRegionInfo regionInfo) throws IOException {
        Path regionDir = new Path(this.tableDir, regionInfo.getEncodedName());
        Path daughterTmpDir = this.getSplitsDir(regionInfo);
        if (this.fs.exists(daughterTmpDir)) {
            Path regionInfoFile = new Path(daughterTmpDir, REGION_INFO_FILE);
            byte[] regionInfoContent = HRegionFileSystem.getRegionInfoFileContent(regionInfo);
            HRegionFileSystem.writeRegionInfoFileContent(this.conf, this.fs, regionInfoFile, regionInfoContent);
            if (!this.rename(daughterTmpDir, regionDir)) {
                throw new IOException("Unable to rename " + daughterTmpDir + " to " + regionDir);
            }
        }
        return regionDir;
    }

    void createSplitsDir() throws IOException {
        Path splitdir = this.getSplitsDir();
        if (this.fs.exists(splitdir)) {
            LOG.info((Object)("The " + splitdir + " directory exists.  Hence deleting it to recreate it"));
            if (!this.deleteDir(splitdir)) {
                throw new IOException("Failed deletion of " + splitdir + " before creating them again.");
            }
        }
        if (!this.createDir(splitdir)) {
            throw new IOException("Failed create of " + splitdir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    Path splitStoreFile(HRegionInfo hri, String familyName, StoreFile f, byte[] splitRow, boolean top, RegionSplitPolicy splitPolicy) throws IOException {
        block9: {
            block7: {
                block8: {
                    block6: {
                        block5: {
                            if (splitPolicy != null && splitPolicy.skipStoreFileRangeCheck(familyName)) break block9;
                            try {
                                if (!top) ** GOTO lbl22
                                splitKey = KeyValueUtil.createFirstOnRow(splitRow);
                                lastKey = f.getLastKey();
                                if (lastKey != null) break block5;
                                var9_9 = null;
                                f.closeReader(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                            }
                            catch (Throwable var10_14) {
                                f.closeReader(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                                throw var10_14;
                            }
                            return var9_9;
                        }
                        if (f.getComparator().compareFlatKey(splitKey.getBuffer(), splitKey.getKeyOffset(), splitKey.getKeyLength(), lastKey, 0, lastKey.length) <= 0) break block6;
                        var9_10 = null;
                        f.closeReader(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                        return var9_10;
                    }
                    break block7;
lbl22:
                    // 1 sources

                    splitKey = KeyValueUtil.createLastOnRow(splitRow);
                    firstKey = f.getFirstKey();
                    if (firstKey != null) break block8;
                    var9_11 = null;
                    f.closeReader(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                    return var9_11;
                }
                if (f.getComparator().compareFlatKey(splitKey.getBuffer(), splitKey.getKeyOffset(), splitKey.getKeyLength(), firstKey, 0, firstKey.length) >= 0) break block7;
                var9_12 = null;
                f.closeReader(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
                return var9_12;
            }
            f.closeReader(f.getCacheConf() != null ? f.getCacheConf().shouldEvictOnClose() : true);
        }
        splitDir = new Path(this.getSplitsDir(hri), familyName);
        r = top != false ? Reference.createTopReference(splitRow) : Reference.createBottomReference(splitRow);
        parentRegionName = this.regionInfoForFs.getEncodedName();
        p = new Path(splitDir, f.getPath().getName() + "." + parentRegionName);
        return r.write(this.fs, p);
    }

    Path getMergesDir() {
        return new Path(this.getRegionDir(), REGION_MERGES_DIR);
    }

    Path getMergesDir(HRegionInfo hri) {
        return new Path(this.getMergesDir(), hri.getEncodedName());
    }

    void cleanupMergesDir() throws IOException {
        this.deleteDir(this.getMergesDir());
    }

    void cleanupMergedRegion(HRegionInfo mergedRegion) throws IOException {
        Path regionDir = new Path(this.tableDir, mergedRegion.getEncodedName());
        if (this.fs.exists(regionDir) && !this.fs.delete(regionDir, true)) {
            throw new IOException("Failed delete of " + regionDir);
        }
    }

    void createMergesDir() throws IOException {
        Path mergesdir = this.getMergesDir();
        if (this.fs.exists(mergesdir)) {
            LOG.info((Object)("The " + mergesdir + " directory exists.  Hence deleting it to recreate it"));
            if (!this.fs.delete(mergesdir, true)) {
                throw new IOException("Failed deletion of " + mergesdir + " before creating them again.");
            }
        }
        if (!this.fs.mkdirs(mergesdir)) {
            throw new IOException("Failed create of " + mergesdir);
        }
    }

    Path mergeStoreFile(HRegionInfo mergedRegion, String familyName, StoreFile f, Path mergedDir) throws IOException {
        Path referenceDir = new Path(new Path(mergedDir, mergedRegion.getEncodedName()), familyName);
        Reference r = Reference.createTopReference(this.regionInfoForFs.getStartKey());
        String mergingRegionName = this.regionInfoForFs.getEncodedName();
        Path p = new Path(referenceDir, f.getPath().getName() + "." + mergingRegionName);
        return r.write(this.fs, p);
    }

    void commitMergedRegion(HRegionInfo mergedRegionInfo) throws IOException {
        Path regionDir = new Path(this.tableDir, mergedRegionInfo.getEncodedName());
        Path mergedRegionTmpDir = this.getMergesDir(mergedRegionInfo);
        if (mergedRegionTmpDir != null && this.fs.exists(mergedRegionTmpDir) && !this.fs.rename(mergedRegionTmpDir, regionDir)) {
            throw new IOException("Unable to rename " + mergedRegionTmpDir + " to " + regionDir);
        }
    }

    void logFileSystemState(Log LOG) throws IOException {
        FSUtils.logFileSystemState(this.fs, this.getRegionDir(), LOG);
    }

    private static byte[] getRegionInfoFileContent(HRegionInfo hri) throws IOException {
        return hri.toDelimitedByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRegionInfo loadRegionInfoFileContent(FileSystem fs, Path regionDir) throws IOException {
        try (FSDataInputStream in = fs.open(new Path(regionDir, REGION_INFO_FILE));){
            HRegionInfo hRegionInfo = HRegionInfo.parseFrom((DataInputStream)in);
            return hRegionInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRegionInfoFileContent(Configuration conf, FileSystem fs, Path regionInfoFile, byte[] content) throws IOException {
        FsPermission perms = FSUtils.getFilePermissions(fs, conf, "hbase.data.umask");
        try (FSDataOutputStream out = FSUtils.create(conf, fs, regionInfoFile, perms, null);){
            out.write(content);
        }
    }

    void checkRegionInfoOnFilesystem() throws IOException {
        byte[] content = HRegionFileSystem.getRegionInfoFileContent(this.regionInfoForFs);
        try {
            Path regionInfoFile = new Path(this.getRegionDir(), REGION_INFO_FILE);
            FileStatus status = this.fs.getFileStatus(regionInfoFile);
            if (status != null && status.getLen() == (long)content.length) {
                return;
            }
            LOG.info((Object)("Rewriting .regioninfo file at: " + regionInfoFile));
            if (!this.fs.delete(regionInfoFile, false)) {
                throw new IOException("Unable to remove existing " + regionInfoFile);
            }
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)(".regioninfo file not found for region: " + this.regionInfoForFs.getEncodedName() + " on table " + this.regionInfo.getTable()));
        }
        this.writeRegionInfoOnFilesystem(content, true);
    }

    private void writeRegionInfoOnFilesystem(boolean useTempDir) throws IOException {
        byte[] content = HRegionFileSystem.getRegionInfoFileContent(this.regionInfoForFs);
        this.writeRegionInfoOnFilesystem(content, useTempDir);
    }

    private void writeRegionInfoOnFilesystem(byte[] regionInfoContent, boolean useTempDir) throws IOException {
        Path regionInfoFile = new Path(this.getRegionDir(), REGION_INFO_FILE);
        if (useTempDir) {
            Path tmpPath = new Path(this.getTempDir(), REGION_INFO_FILE);
            if (FSUtils.isExists(this.fs, tmpPath)) {
                FSUtils.delete(this.fs, tmpPath, true);
            }
            HRegionFileSystem.writeRegionInfoFileContent(this.conf, this.fs, tmpPath, regionInfoContent);
            if (this.fs.exists(tmpPath) && !this.rename(tmpPath, regionInfoFile)) {
                throw new IOException("Unable to rename " + tmpPath + " to " + regionInfoFile);
            }
        } else {
            HRegionFileSystem.writeRegionInfoFileContent(this.conf, this.fs, regionInfoFile, regionInfoContent);
        }
    }

    public static HRegionFileSystem createRegionOnFileSystem(Configuration conf, FileSystem fs, Path tableDir, HRegionInfo regionInfo) throws IOException {
        HRegionFileSystem regionFs = new HRegionFileSystem(conf, fs, tableDir, regionInfo);
        Path regionDir = regionFs.getRegionDir();
        if (fs.exists(regionDir)) {
            LOG.warn((Object)("Trying to create a region that already exists on disk: " + regionDir));
            throw new IOException("The specified region already exists on disk: " + regionDir);
        }
        if (!HRegionFileSystem.createDirOnFileSystem(fs, conf, regionDir)) {
            LOG.warn((Object)("Unable to create the region directory: " + regionDir));
            throw new IOException("Unable to create region directory: " + regionDir);
        }
        regionFs.writeRegionInfoOnFilesystem(false);
        return regionFs;
    }

    public static HRegionFileSystem openRegionFromFileSystem(Configuration conf, FileSystem fs, Path tableDir, HRegionInfo regionInfo, boolean readOnly) throws IOException {
        HRegionFileSystem regionFs = new HRegionFileSystem(conf, fs, tableDir, regionInfo);
        Path regionDir = regionFs.getRegionDir();
        if (!fs.exists(regionDir)) {
            LOG.warn((Object)("Trying to open a region that do not exists on disk: " + regionDir));
            throw new IOException("The specified region do not exists on disk: " + regionDir);
        }
        if (!readOnly) {
            regionFs.cleanupTempDir();
            regionFs.cleanupSplitsDir();
            regionFs.cleanupMergesDir();
            regionFs.checkRegionInfoOnFilesystem();
        }
        return regionFs;
    }

    public static void deleteRegionFromFileSystem(Configuration conf, FileSystem fs, Path tableDir, HRegionInfo regionInfo) throws IOException {
        HRegionFileSystem regionFs = new HRegionFileSystem(conf, fs, tableDir, regionInfo);
        Path regionDir = regionFs.getRegionDir();
        if (!fs.exists(regionDir)) {
            LOG.warn((Object)("Trying to delete a region that do not exists on disk: " + regionDir));
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETING region " + regionDir));
        }
        Path rootDir = FSUtils.getRootDir(conf);
        HFileArchiver.archiveRegion(fs, rootDir, tableDir, regionDir);
        if (!fs.delete(regionDir, true)) {
            LOG.warn((Object)("Failed delete of " + regionDir));
        }
    }

    boolean createDir(Path dir) throws IOException {
        int i = 0;
        IOException lastIOE = null;
        while (true) {
            try {
                return this.fs.mkdirs(dir);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (this.fs.exists(dir)) {
                    return true;
                }
                try {
                    this.sleepBeforeRetry("Create Directory", i + 1);
                    continue;
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                if (++i <= this.hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in createDir", lastIOE);
            }
            break;
        }
    }

    boolean rename(Path srcpath, Path dstPath) throws IOException {
        IOException lastIOE = null;
        int i = 0;
        while (true) {
            try {
                return this.fs.rename(srcpath, dstPath);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (!this.fs.exists(srcpath) && this.fs.exists(dstPath)) {
                    return true;
                }
                try {
                    this.sleepBeforeRetry("Rename Directory", i + 1);
                    continue;
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                if (++i <= this.hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in rename", lastIOE);
            }
            break;
        }
    }

    boolean deleteDir(Path dir) throws IOException {
        IOException lastIOE = null;
        int i = 0;
        while (true) {
            try {
                return this.fs.delete(dir, true);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (!this.fs.exists(dir)) {
                    return true;
                }
                try {
                    this.sleepBeforeRetry("Delete Directory", i + 1);
                    continue;
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                if (++i <= this.hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in DeleteDir", lastIOE);
            }
            break;
        }
    }

    private void sleepBeforeRetry(String msg, int sleepMultiplier) throws InterruptedException {
        HRegionFileSystem.sleepBeforeRetry(msg, sleepMultiplier, this.baseSleepBeforeRetries, this.hdfsClientRetriesNumber);
    }

    private static boolean createDirOnFileSystem(FileSystem fs, Configuration conf, Path dir) throws IOException {
        int i = 0;
        IOException lastIOE = null;
        int hdfsClientRetriesNumber = conf.getInt("hdfs.client.retries.number", 10);
        int baseSleepBeforeRetries = conf.getInt("hdfs.client.sleep.before.retries", 1000);
        while (true) {
            try {
                return fs.mkdirs(dir);
            }
            catch (IOException ioe) {
                lastIOE = ioe;
                if (fs.exists(dir)) {
                    return true;
                }
                try {
                    HRegionFileSystem.sleepBeforeRetry("Create Directory", i + 1, baseSleepBeforeRetries, hdfsClientRetriesNumber);
                    continue;
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                if (++i <= hdfsClientRetriesNumber) continue;
                throw new IOException("Exception in createDir", lastIOE);
            }
            break;
        }
    }

    private static void sleepBeforeRetry(String msg, int sleepMultiplier, int baseSleepBeforeRetries, int hdfsClientRetriesNumber) throws InterruptedException {
        if (sleepMultiplier > hdfsClientRetriesNumber) {
            LOG.debug((Object)(msg + ", retries exhausted"));
            return;
        }
        LOG.debug((Object)(msg + ", sleeping " + baseSleepBeforeRetries + " times " + sleepMultiplier));
        Thread.sleep((long)baseSleepBeforeRetries * (long)sleepMultiplier);
    }
}

