/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.types.DataType;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class RawShort
implements DataType<Short> {
    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Override
    public Order getOrder() {
        return null;
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public boolean isSkippable() {
        return true;
    }

    @Override
    public int encodedLength(Short val) {
        return 2;
    }

    @Override
    public Class<Short> encodedClass() {
        return Short.class;
    }

    @Override
    public int skip(PositionedByteRange src) {
        src.setPosition(src.getPosition() + 2);
        return 2;
    }

    @Override
    public Short decode(PositionedByteRange src) {
        short val = Bytes.toShort(src.getBytes(), src.getOffset() + src.getPosition());
        this.skip(src);
        return val;
    }

    @Override
    public int encode(PositionedByteRange dst, Short val) {
        Bytes.putShort(dst.getBytes(), dst.getOffset() + dst.getPosition(), val);
        return this.skip(dst);
    }

    public short decodeShort(byte[] buff, int offset) {
        return Bytes.toShort(buff, offset);
    }

    public int encodeShort(byte[] buff, int offset, short val) {
        return Bytes.putShort(buff, offset, val);
    }
}

