/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class Strings {
    public static final String DEFAULT_SEPARATOR = "=";
    public static final String DEFAULT_KEYVALUE_SEPARATOR = ", ";

    public static StringBuilder appendKeyValue(StringBuilder sb, String key, Object value) {
        return Strings.appendKeyValue(sb, key, value, DEFAULT_SEPARATOR, DEFAULT_KEYVALUE_SEPARATOR);
    }

    public static StringBuilder appendKeyValue(StringBuilder sb, String key, Object value, String separator, String keyValueSeparator) {
        if (sb.length() > 0) {
            sb.append(keyValueSeparator);
        }
        return sb.append(key).append(separator).append(value);
    }

    public static String domainNamePointerToHostName(String dnPtr) {
        if (dnPtr == null) {
            return null;
        }
        return dnPtr.endsWith(".") ? dnPtr.substring(0, dnPtr.length() - 1) : dnPtr;
    }

    public static boolean isEmpty(String input) {
        return input == null || input.length() == 0;
    }

    public static String padFront(String input, char padding, int length) {
        if (input.length() > length) {
            throw new IllegalArgumentException("input \"" + input + "\" longer than maxLength=" + length);
        }
        int numPaddingCharacters = length - input.length();
        return Strings.repeat(padding, numPaddingCharacters) + input;
    }

    public static String repeat(char c, int reapeatFor) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < reapeatFor; ++i) {
            sb.append(c);
        }
        return sb.toString();
    }
}

