/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseCommonTestingUtility;
import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassLoaderTestHelper;
import org.apache.hudi.org.apache.hadoop.hbase.util.CoprocessorClassLoader;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCoprocessorClassLoader {
    private static final HBaseCommonTestingUtility TEST_UTIL = new HBaseCommonTestingUtility();
    private static final Configuration conf = TEST_UTIL.getConfiguration();

    @Test
    public void testCleanupOldJars() throws Exception {
        String className = "TestCleanupOldJars";
        String folder = TEST_UTIL.getDataTestDir().toString();
        File jarFile = ClassLoaderTestHelper.buildJar(folder, className, null, ClassLoaderTestHelper.localDirPath(conf));
        File tmpJarFile = new File(jarFile.getParent(), "/tmp/" + className + ".test.jar");
        if (tmpJarFile.exists()) {
            tmpJarFile.delete();
        }
        Assert.assertFalse((String)"tmp jar file should not exist", (boolean)tmpJarFile.exists());
        IOUtils.copyBytes((InputStream)new FileInputStream(jarFile), (OutputStream)new FileOutputStream(tmpJarFile), (Configuration)conf, (boolean)true);
        Assert.assertTrue((String)"tmp jar file should be created", (boolean)tmpJarFile.exists());
        Path path = new Path(jarFile.getAbsolutePath());
        ClassLoader parent = TestCoprocessorClassLoader.class.getClassLoader();
        CoprocessorClassLoader.parentDirLockSet.clear();
        CoprocessorClassLoader classLoader = CoprocessorClassLoader.getClassLoader(path, parent, "111", conf);
        Assert.assertNotNull((String)"Classloader should be created", (Object)classLoader);
        Assert.assertFalse((String)"tmp jar file should be removed", (boolean)tmpJarFile.exists());
    }

    @Test
    public void testLibJarName() throws Exception {
        this.checkingLibJarName("TestLibJarName.jar", "/lib/");
    }

    @Test
    public void testRelativeLibJarName() throws Exception {
        this.checkingLibJarName("TestRelativeLibJarName.jar", "lib/");
    }

    private void checkingLibJarName(String jarName, String libPrefix) throws Exception {
        File tmpFolder = new File(ClassLoaderTestHelper.localDirPath(conf), "tmp");
        if (tmpFolder.exists()) {
            for (File f : tmpFolder.listFiles()) {
                f.delete();
            }
        }
        String className = "CheckingLibJarName";
        String folder = TEST_UTIL.getDataTestDir().toString();
        File innerJarFile = ClassLoaderTestHelper.buildJar(folder, className, null, ClassLoaderTestHelper.localDirPath(conf));
        File targetJarFile = new File(innerJarFile.getParent(), jarName);
        ClassLoaderTestHelper.addJarFilesToJar(targetJarFile, libPrefix, innerJarFile);
        Path path = new Path(targetJarFile.getAbsolutePath());
        ClassLoader parent = TestCoprocessorClassLoader.class.getClassLoader();
        CoprocessorClassLoader classLoader = CoprocessorClassLoader.getClassLoader(path, parent, "112", conf);
        Assert.assertNotNull((String)"Classloader should be created", (Object)classLoader);
        String fileToLookFor = "." + className + ".jar";
        for (String f : tmpFolder.list()) {
            if (!f.endsWith(fileToLookFor) || !f.contains(jarName)) continue;
            return;
        }
        Assert.fail((String)"Could not find the expected lib jar file");
    }

    static {
        TEST_UTIL.getDataTestDir();
    }
}

