/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.SimpleByteRange;
import org.apache.hudi.org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestSimpleMutableByteRange {
    @Test
    public void testEmpty() {
        Assert.assertTrue((boolean)SimpleMutableByteRange.isEmpty(null));
        SimpleMutableByteRange r = new SimpleMutableByteRange();
        Assert.assertTrue((boolean)SimpleMutableByteRange.isEmpty(r));
        Assert.assertTrue((boolean)r.isEmpty());
        r.set(new byte[0]);
        Assert.assertEquals((long)0L, (long)r.getBytes().length);
        Assert.assertEquals((long)0L, (long)r.getOffset());
        Assert.assertEquals((long)0L, (long)r.getLength());
        Assert.assertTrue((boolean)Bytes.equals(new byte[0], r.deepCopyToNewArray()));
        Assert.assertEquals((long)0L, (long)r.compareTo(new SimpleMutableByteRange(new byte[0], 0, 0)));
        Assert.assertEquals((long)0L, (long)((Object)r).hashCode());
    }

    @Test
    public void testBasics() {
        SimpleMutableByteRange r = new SimpleMutableByteRange(new byte[]{1, 3, 2});
        Assert.assertFalse((boolean)SimpleMutableByteRange.isEmpty(r));
        Assert.assertNotNull((Object)r.getBytes());
        Assert.assertEquals((long)3L, (long)r.getBytes().length);
        Assert.assertEquals((long)0L, (long)r.getOffset());
        Assert.assertEquals((long)3L, (long)r.getLength());
        Assert.assertTrue((boolean)Bytes.equals(new byte[]{1, 3, 2}, r.deepCopyToNewArray()));
        Assert.assertNotSame((Object)r.getBytes(), (Object)r.deepCopyToNewArray());
        Assert.assertTrue((((Object)r).hashCode() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)((Object)r).hashCode(), (long)r.deepCopy().hashCode());
        byte[] destination = new byte[]{-59};
        r.deepCopySubRangeTo(2, 1, destination, 0);
        Assert.assertTrue((boolean)Bytes.equals(new byte[]{2}, destination));
        r.setLength(1);
        Assert.assertTrue((boolean)Bytes.equals(new byte[]{1}, r.deepCopyToNewArray()));
        r.setLength(2);
        Assert.assertTrue((boolean)Bytes.equals(new byte[]{1, 3}, r.deepCopyToNewArray()));
    }

    @Test
    public void testPutandGetPrimitiveTypes() throws Exception {
        SimpleMutableByteRange r = new SimpleMutableByteRange(100);
        int offset = 0;
        int i1 = 18;
        int i2 = 2;
        short s1 = 0;
        long l1 = 1234L;
        long l2 = 0L;
        r.putInt(offset, i1);
        r.putInt(offset += 4, i2);
        r.putShort(offset += 4, s1);
        r.putLong(offset += 2, l1);
        int len = r.putVLong(offset += 8, l1);
        offset += len;
        len = r.putVLong(offset, l2);
        offset += len;
        len = r.putVLong(offset, Long.MAX_VALUE);
        offset += len;
        len = r.putVLong(offset, Long.MIN_VALUE);
        offset = 0;
        Assert.assertEquals((long)i1, (long)r.getInt(offset));
        Assert.assertEquals((long)i2, (long)r.getInt(offset += 4));
        Assert.assertEquals((long)s1, (long)r.getShort(offset += 4));
        Assert.assertEquals((long)l1, (long)r.getLong(offset += 2));
        Assert.assertEquals((long)l1, (long)r.getVLong(offset += 8));
        Assert.assertEquals((long)l2, (long)r.getVLong(offset += SimpleByteRange.getVLongSize(l1)));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)r.getVLong(offset += SimpleByteRange.getVLongSize(l2)));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getVLong(offset += SimpleByteRange.getVLongSize(Long.MAX_VALUE)));
    }
}

