/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.heartbeat;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieHeartbeatUtils {
    private static final Logger LOG = LogManager.getLogger(HoodieHeartbeatUtils.class);

    public static Long getLastHeartbeatTime(FileSystem fs, String basePath, String instantTime) throws IOException {
        Path heartbeatFilePath = new Path(HoodieTableMetaClient.getHeartbeatFolderPath(basePath) + "/" + instantTime);
        if (fs.exists(heartbeatFilePath)) {
            return fs.getFileStatus(heartbeatFilePath).getModificationTime();
        }
        return 0L;
    }

    public static boolean isHeartbeatExpired(String instantTime, long maxAllowableHeartbeatIntervalInMs, FileSystem fs, String basePath) throws IOException {
        Long currentTime = System.currentTimeMillis();
        Long lastHeartbeatTime = HoodieHeartbeatUtils.getLastHeartbeatTime(fs, basePath, instantTime);
        if (currentTime - lastHeartbeatTime > maxAllowableHeartbeatIntervalInMs) {
            LOG.warn((Object)("Heartbeat expired, for instant: " + instantTime));
            return true;
        }
        return false;
    }
}

