/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.heartbeat.HoodieHeartbeatUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class MarkerUtils {
    public static final String MARKERS_FILENAME_PREFIX = "MARKERS";
    public static final String MARKER_TYPE_FILENAME = "MARKERS.type";
    private static final Logger LOG = LogManager.getLogger(MarkerUtils.class);

    public static String stripMarkerFolderPrefix(String fullMarkerPath, String basePath, String instantTime) {
        ValidationUtils.checkArgument(fullMarkerPath.contains(".marker"), String.format("Using DIRECT markers but marker path does not contain extension: %s", ".marker"));
        String markerRootPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(String.format("%s/%s/%s", basePath, ".hoodie/.temp", instantTime))).toString();
        return MarkerUtils.stripMarkerFolderPrefix(fullMarkerPath, markerRootPath);
    }

    public static String stripMarkerFolderPrefix(String fullMarkerPath, String markerDir) {
        int begin = fullMarkerPath.indexOf(markerDir);
        ValidationUtils.checkArgument(begin >= 0, "Not in marker dir. Marker Path=" + fullMarkerPath + ", Expected Marker Root=" + markerDir);
        return fullMarkerPath.substring(begin + markerDir.length() + 1);
    }

    public static boolean doesMarkerTypeFileExist(FileSystem fileSystem, String markerDir) throws IOException {
        return fileSystem.exists(new Path(markerDir, MARKER_TYPE_FILENAME));
    }

    public static Option<MarkerType> readMarkerType(FileSystem fileSystem, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        FSDataInputStream fsDataInputStream = null;
        Option<MarkerType> content = Option.empty();
        try {
            if (!MarkerUtils.doesMarkerTypeFileExist(fileSystem, markerDir)) {
                Option<MarkerType> option = Option.empty();
                return option;
            }
            fsDataInputStream = fileSystem.open(markerTypeFilePath);
            content = Option.of(MarkerType.valueOf(FileIOUtils.readAsUTFString((InputStream)fsDataInputStream)));
            FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot read marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
        }
        finally {
            FileIOUtils.closeQuietly(fsDataInputStream);
        }
        return content;
    }

    public static void writeMarkerTypeToFile(MarkerType markerType, FileSystem fileSystem, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        FSDataOutputStream fsDataOutputStream = null;
        BufferedWriter bufferedWriter = null;
        try {
            fsDataOutputStream = fileSystem.create(markerTypeFilePath, false);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fsDataOutputStream, StandardCharsets.UTF_8));
            bufferedWriter.write(markerType.toString());
        }
        catch (IOException e) {
            try {
                throw new HoodieException("Failed to create marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly(bufferedWriter);
                FileIOUtils.closeQuietly((Closeable)fsDataOutputStream);
                throw throwable;
            }
        }
        FileIOUtils.closeQuietly(bufferedWriter);
        FileIOUtils.closeQuietly((Closeable)fsDataOutputStream);
    }

    public static void deleteMarkerTypeFile(FileSystem fileSystem, String markerDir) {
        Path markerTypeFilePath = new Path(markerDir, MARKER_TYPE_FILENAME);
        try {
            fileSystem.delete(markerTypeFilePath, false);
        }
        catch (IOException e) {
            throw new HoodieIOException("Cannot delete marker type file " + markerTypeFilePath.toString() + "; " + e.getMessage(), e);
        }
    }

    public static Map<String, Set<String>> readTimelineServerBasedMarkersFromFileSystem(String markerDir, FileSystem fileSystem, HoodieEngineContext context, int parallelism) {
        Path dirPath = new Path(markerDir);
        try {
            if (fileSystem.exists(dirPath)) {
                Predicate<FileStatus> prefixFilter = fileStatus -> fileStatus.getPath().getName().startsWith(MARKERS_FILENAME_PREFIX);
                Predicate<FileStatus> markerTypeFilter = fileStatus -> !fileStatus.getPath().getName().equals(MARKER_TYPE_FILENAME);
                return FSUtils.parallelizeSubPathProcess(context, fileSystem, dirPath, parallelism, prefixFilter.and(markerTypeFilter), pairOfSubPathAndConf -> {
                    String markersFilePathStr = (String)pairOfSubPathAndConf.getKey();
                    SerializableConfiguration conf = (SerializableConfiguration)pairOfSubPathAndConf.getValue();
                    return MarkerUtils.readMarkersFromFile(new Path(markersFilePathStr), conf);
                });
            }
            return new HashMap<String, Set<String>>();
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
    }

    public static Set<String> readMarkersFromFile(Path markersFilePath, SerializableConfiguration conf) {
        return MarkerUtils.readMarkersFromFile(markersFilePath, conf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> readMarkersFromFile(Path markersFilePath, SerializableConfiguration conf, boolean ignoreException) {
        FSDataInputStream fsDataInputStream = null;
        HashSet<String> markers = new HashSet();
        try {
            LOG.debug((Object)("Read marker file: " + markersFilePath));
            FileSystem fs = markersFilePath.getFileSystem(conf.get());
            fsDataInputStream = fs.open(markersFilePath);
            markers = new HashSet<String>(FileIOUtils.readAsUTFStringLines((InputStream)fsDataInputStream));
        }
        catch (IOException e) {
            try {
                String errorMessage = "Failed to read MARKERS file " + markersFilePath;
                if (!ignoreException) {
                    throw new HoodieIOException(errorMessage, e);
                }
                LOG.warn((Object)(errorMessage + ". Ignoring the exception and continue."), (Throwable)e);
            }
            catch (Throwable throwable) {
                FileIOUtils.closeQuietly(fsDataInputStream);
                throw throwable;
            }
            FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
        }
        FileIOUtils.closeQuietly((Closeable)fsDataInputStream);
        return markers;
    }

    public static List<Path> getAllMarkerDir(Path tempPath, FileSystem fs) throws IOException {
        return Arrays.stream(fs.listStatus(tempPath)).map(FileStatus::getPath).collect(Collectors.toList());
    }

    public static boolean hasCommitConflict(HoodieActiveTimeline activeTimeline, Set<String> currentFileIDs, Set<HoodieInstant> completedCommitInstants) {
        HashSet<HoodieInstant> currentInstants = new HashSet<HoodieInstant>(activeTimeline.reload().getCommitsTimeline().filterCompletedInstants().getInstants());
        currentInstants.removeAll(completedCommitInstants);
        Set missingFileIDs = currentInstants.stream().flatMap(instant -> {
            try {
                return HoodieCommitMetadata.fromBytes(activeTimeline.getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class).getFileIdAndRelativePaths().keySet().stream();
            }
            catch (Exception e) {
                return Stream.empty();
            }
        }).collect(Collectors.toSet());
        currentFileIDs.retainAll(missingFileIDs);
        return !currentFileIDs.isEmpty();
    }

    public static List<String> getCandidateInstants(HoodieActiveTimeline activeTimeline, List<Path> instants, String currentInstantTime, long maxAllowableHeartbeatIntervalInMs, FileSystem fs, String basePath) {
        return instants.stream().map(Path::toString).filter(instantPath -> {
            String instantTime = MarkerUtils.markerDirToInstantTime(instantPath);
            return instantTime.compareToIgnoreCase(currentInstantTime) < 0 && !activeTimeline.filterPendingCompactionTimeline().containsInstant(instantTime) && !activeTimeline.filterPendingReplaceTimeline().containsInstant(instantTime);
        }).filter(instantPath -> {
            try {
                return !HoodieHeartbeatUtils.isHeartbeatExpired(MarkerUtils.markerDirToInstantTime(instantPath), maxAllowableHeartbeatIntervalInMs, fs, basePath);
            }
            catch (IOException e) {
                return false;
            }
        }).collect(Collectors.toList());
    }

    public static String makerToPartitionAndFileID(String marker) {
        String[] ele = marker.split("_");
        return ele[0];
    }

    public static String markerDirToInstantTime(String marker) {
        String[] ele = marker.split("/");
        return ele[ele.length - 1];
    }
}

