/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.security;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hudi.org.apache.hadoop.hbase.security.AbstractHBaseSaslRpcClient;
import org.apache.hudi.org.apache.hadoop.hbase.security.SaslUnwrapHandler;
import org.apache.hudi.org.apache.hadoop.hbase.security.SaslWrapHandler;
import org.apache.hudi.org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hudi.org.apache.hadoop.hbase.security.provider.SaslClientAuthenticationProvider;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.channel.ChannelPipeline;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class NettyHBaseSaslRpcClient
extends AbstractHBaseSaslRpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(NettyHBaseSaslRpcClient.class);

    public NettyHBaseSaslRpcClient(Configuration conf, SaslClientAuthenticationProvider provider, Token<? extends TokenIdentifier> token, InetAddress serverAddr, SecurityInfo securityInfo, boolean fallbackAllowed, String rpcProtection) throws IOException {
        super(conf, provider, token, serverAddr, securityInfo, fallbackAllowed, rpcProtection);
    }

    public void setupSaslHandler(ChannelPipeline p) {
        String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
        LOG.trace("SASL client context established. Negotiated QoP {}", (Object)qop);
        if (qop == null || "auth".equalsIgnoreCase(qop)) {
            return;
        }
        p.addFirst(new SaslWrapHandler(this.saslClient), new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 0, 4, 0, 4), new SaslUnwrapHandler(this.saslClient));
    }

    public String getSaslQOP() {
        return (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
    }
}

