/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.avro.AvroRuntimeException;
import org.apache.hudi.org.apache.avro.Conversion;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.data.RecordBuilder;
import org.apache.hudi.org.apache.avro.data.TimeConversions;
import org.apache.hudi.org.apache.avro.io.DatumReader;
import org.apache.hudi.org.apache.avro.io.DatumWriter;
import org.apache.hudi.org.apache.avro.specific.AvroGenerated;
import org.apache.hudi.org.apache.avro.specific.SpecificData;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumReader;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hudi.org.apache.avro.specific.SpecificRecord;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class DecimalWrapper
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -562900601579885202L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"DecimalWrapper\",\"namespace\":\"org.apache.hudi.avro.model\",\"doc\":\"A record wrapping Decimal logical type to be able to be used it w/in Avro's Union\",\"fields\":[{\"name\":\"value\",\"type\":{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":30,\"scale\":15}}]}");
    @Deprecated
    public ByteBuffer value;
    protected static final TimeConversions.DateConversion DATE_CONVERSION = new TimeConversions.DateConversion();
    protected static final TimeConversions.TimeConversion TIME_CONVERSION = new TimeConversions.TimeConversion();
    protected static final TimeConversions.TimestampConversion TIMESTAMP_CONVERSION = new TimeConversions.TimestampConversion();
    private final Conversion<?>[] conversions = new Conversion[]{null, null};
    private static final DatumWriter WRITER$ = new SpecificDatumWriter(SCHEMA$);
    private static final DatumReader READER$ = new SpecificDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public DecimalWrapper() {
    }

    public DecimalWrapper(ByteBuffer value) {
        this.value = value;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.value;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    @Override
    public Conversion<?> getConversion(int field) {
        return this.conversions[field];
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.value = (ByteBuffer)value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public ByteBuffer getValue() {
        return this.value;
    }

    public void setValue(ByteBuffer value) {
        this.value = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(DecimalWrapper other) {
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<DecimalWrapper>
    implements RecordBuilder<DecimalWrapper> {
        private ByteBuffer value;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.value)) {
                this.value = this.data().deepCopy(this.fields()[0].schema(), other.value);
                this.fieldSetFlags()[0] = true;
            }
        }

        private Builder(DecimalWrapper other) {
            super(SCHEMA$);
            if (Builder.isValidValue(this.fields()[0], other.value)) {
                this.value = this.data().deepCopy(this.fields()[0].schema(), other.value);
                this.fieldSetFlags()[0] = true;
            }
        }

        public ByteBuffer getValue() {
            return this.value;
        }

        public Builder setValue(ByteBuffer value) {
            this.validate(this.fields()[0], value);
            this.value = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasValue() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearValue() {
            this.value = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        @Override
        public DecimalWrapper build() {
            try {
                DecimalWrapper record = new DecimalWrapper();
                record.value = this.fieldSetFlags()[0] ? this.value : (ByteBuffer)this.defaultValue(this.fields()[0]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

