/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.util.Arrays;

public enum StorageSchemes {
    FILE("file", false, false, true),
    HDFS("hdfs", true, false, true),
    AFS("afs", true, null, null),
    MAPRFS("maprfs", true, null, null),
    IGNITE("igfs", true, null, null),
    S3A("s3a", false, true, null),
    S3("s3", false, true, null),
    GCS("gs", false, true, null),
    WASB("wasb", false, null, null),
    WASBS("wasbs", false, null, null),
    ADL("adl", false, null, null),
    ABFS("abfs", false, null, null),
    ABFSS("abfss", false, null, null),
    OSS("oss", false, null, null),
    VIEWFS("viewfs", true, null, true),
    ALLUXIO("alluxio", false, null, null),
    COSN("cosn", false, null, null),
    CHDFS("ofs", true, null, null),
    GOOSEFS("gfs", false, null, null),
    DBFS("dbfs", false, null, null),
    COS("cos", false, null, null),
    OBS("obs", false, null, null),
    KS3("ks3", false, null, null),
    JFS("jfs", true, null, null),
    BOS("bos", false, null, null),
    OCI("oci", false, null, null),
    TOS("tos", false, null, null),
    CFS("cfs", true, null, null);

    private String scheme;
    private boolean supportsAppend;
    private Boolean isWriteTransactional;
    private Boolean supportAtomicCreation;

    private StorageSchemes(String scheme, boolean supportsAppend, Boolean isWriteTransactional, Boolean supportAtomicCreation) {
        this.scheme = scheme;
        this.supportsAppend = supportsAppend;
        this.isWriteTransactional = isWriteTransactional;
        this.supportAtomicCreation = supportAtomicCreation;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean supportsAppend() {
        return this.supportsAppend;
    }

    public boolean isWriteTransactional() {
        return this.isWriteTransactional != null && this.isWriteTransactional != false;
    }

    public boolean isAtomicCreationSupported() {
        return this.supportAtomicCreation != null && this.supportAtomicCreation != false;
    }

    public static boolean isSchemeSupported(String scheme) {
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.getScheme().equals(scheme));
    }

    public static boolean isAppendSupported(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.supportsAppend() && s.scheme.equals(scheme));
    }

    public static boolean isWriteTransactional(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isWriteTransactional() && s.scheme.equals(scheme));
    }

    public static boolean isAtomicCreationSupported(String scheme) {
        if (!StorageSchemes.isSchemeSupported(scheme)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.isAtomicCreationSupported() && s.scheme.equals(scheme));
    }
}

