/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.BaseFileUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.orc.OrcFile;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodiePartitionMetadata {
    public static final String HOODIE_PARTITION_METAFILE_PREFIX = ".hoodie_partition_metadata";
    public static final String COMMIT_TIME_KEY = "commitTime";
    private static final String PARTITION_DEPTH_KEY = "partitionDepth";
    private static final Logger LOG = LoggerFactory.getLogger(HoodiePartitionMetadata.class);
    private final Properties props;
    private final Path partitionPath;
    private final FileSystem fs;
    private Option<HoodieFileFormat> format;

    public HoodiePartitionMetadata(FileSystem fs, Path partitionPath) {
        this.fs = fs;
        this.props = new Properties();
        this.partitionPath = partitionPath;
        this.format = Option.empty();
    }

    public HoodiePartitionMetadata(FileSystem fs, String instantTime, Path basePath, Path partitionPath, Option<HoodieFileFormat> format) {
        this(fs, partitionPath);
        this.format = format;
        this.props.setProperty(COMMIT_TIME_KEY, instantTime);
        this.props.setProperty(PARTITION_DEPTH_KEY, String.valueOf(partitionPath.depth() - basePath.depth()));
    }

    public int getPartitionDepth() {
        if (!this.props.containsKey(PARTITION_DEPTH_KEY)) {
            throw new HoodieException("Could not find partitionDepth in partition metafile");
        }
        return Integer.parseInt(this.props.getProperty(PARTITION_DEPTH_KEY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trySave(int taskPartitionId) {
        String extension = this.getMetafileExtension();
        Path tmpMetaPath = new Path(this.partitionPath, ".hoodie_partition_metadata_" + taskPartitionId + extension);
        Path metaPath = new Path(this.partitionPath, HOODIE_PARTITION_METAFILE_PREFIX + extension);
        boolean metafileExists = false;
        try {
            metafileExists = this.fs.exists(metaPath);
            if (!metafileExists) {
                this.writeMetafile(tmpMetaPath);
                this.fs.rename(tmpMetaPath, metaPath);
            }
        }
        catch (IOException ioe) {
            LOG.warn("Error trying to save partition metadata (this is okay, as long as at least 1 of these succeeded), " + this.partitionPath, (Throwable)ioe);
        }
        finally {
            if (!metafileExists) {
                try {
                    if (this.fs.exists(tmpMetaPath)) {
                        this.fs.delete(tmpMetaPath, false);
                    }
                }
                catch (IOException ioe) {
                    LOG.warn("Error trying to clean up temporary files for " + this.partitionPath, (Throwable)ioe);
                }
            }
        }
    }

    private String getMetafileExtension() {
        return this.format.isPresent() ? this.format.get().getFileExtension() : "";
    }

    /*
     * Unable to fully structure code
     */
    private void writeMetafile(Path filePath) throws IOException {
        block28: {
            block29: {
                if (!this.format.isPresent()) break block29;
                schema = HoodieAvroUtils.getRecordKeySchema();
                switch (1.$SwitchMap$org$apache$hudi$common$model$HoodieFileFormat[this.format.get().ordinal()]) {
                    case 1: {
                        type = (MessageType)((Types.GroupBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.INT64).named("dummyint")).named("dummy");
                        writeSupport = new HoodieAvroWriteSupport<T>(type, schema, Option.empty(), new Properties());
                        writer = new ParquetWriter(filePath, writeSupport, CompressionCodecName.UNCOMPRESSED, 1024, 1024);
                        var6_8 = null;
                        for (String key : this.props.stringPropertyNames()) {
                            writeSupport.addFooterMetadata(key, this.props.getProperty(key));
                        }
                        if (writer == null) break block28;
                        if (var6_8 == null) ** GOTO lbl21
                        try {
                            writer.close();
                        }
                        catch (Throwable var7_11) {
                            var6_8.addSuppressed(var7_11);
                        }
                        break;
lbl21:
                        // 1 sources

                        writer.close();
                        break;
                        catch (Throwable var7_12) {
                            try {
                                var6_8 = var7_12;
                                throw var7_12;
                            }
                            catch (Throwable var9_18) {
                                if (writer != null) {
                                    if (var6_8 != null) {
                                        try {
                                            writer.close();
                                        }
                                        catch (Throwable var10_20) {
                                            var6_8.addSuppressed(var10_20);
                                        }
                                    } else {
                                        writer.close();
                                    }
                                }
                                throw var9_18;
                            }
                        }
                    }
                    case 2: {
                        writerOptions = OrcFile.writerOptions((Configuration)this.fs.getConf()).fileSystem(this.fs).setSchema(AvroOrcUtils.createOrcSchema(schema));
                        writer = OrcFile.createWriter((Path)filePath, (OrcFile.WriterOptions)writerOptions);
                        var7_13 = null;
                        for (String key : this.props.stringPropertyNames()) {
                            writer.addUserMetadata(key, ByteBuffer.wrap(this.props.getProperty(key).getBytes()));
                        }
                        if (writer == null) break block28;
                        if (var7_13 == null) ** GOTO lbl54
                        try {
                            writer.close();
                        }
                        catch (Throwable var8_16) {
                            var7_13.addSuppressed(var8_16);
                        }
                        break;
lbl54:
                        // 1 sources

                        writer.close();
                        break;
                        catch (Throwable var8_17) {
                            try {
                                var7_13 = var8_17;
                                throw var8_17;
                            }
                            catch (Throwable var11_21) {
                                if (writer != null) {
                                    if (var7_13 != null) {
                                        try {
                                            writer.close();
                                        }
                                        catch (Throwable var12_22) {
                                            var7_13.addSuppressed(var12_22);
                                        }
                                    } else {
                                        writer.close();
                                    }
                                }
                                throw var11_21;
                            }
                        }
                    }
                    default: {
                        throw new HoodieException("Unsupported format for partition metafiles: " + (Object)this.format.get());
                    }
                }
                break block28;
            }
            os = this.fs.create(filePath, true);
            this.props.store((OutputStream)os, "partition metadata");
            os.hsync();
            os.hflush();
            os.close();
        }
    }

    public void readFromFS() throws IOException {
        boolean readFile = this.readTextFormatMetaFile();
        if (!readFile) {
            readFile = this.readBaseFormatMetaFile();
        }
        if (!readFile) {
            throw new HoodieException("Unable to read any partition meta file to locate the table timeline.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readTextFormatMetaFile() {
        Path metafilePath = HoodiePartitionMetadata.textFormatMetaFilePath(this.partitionPath);
        try (FSDataInputStream is = this.fs.open(metafilePath);){
            this.props.load((InputStream)is);
            this.format = Option.empty();
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            LOG.debug("Unable to read partition meta properties file for partition " + this.partitionPath);
            return false;
        }
    }

    private boolean readBaseFormatMetaFile() {
        for (Path metafilePath : HoodiePartitionMetadata.baseFormatMetaFilePaths(this.partitionPath)) {
            try {
                BaseFileUtils reader = BaseFileUtils.getInstance(metafilePath.toString());
                Map<String, String> metadata = reader.readFooter(this.fs.getConf(), true, metafilePath, PARTITION_DEPTH_KEY, COMMIT_TIME_KEY);
                this.props.clear();
                this.props.putAll(metadata);
                this.format = Option.of(reader.getFormat());
                return true;
            }
            catch (Throwable t) {
                LOG.debug("Unable to read partition metadata " + metafilePath.getName() + " for partition " + this.partitionPath);
            }
        }
        return false;
    }

    public Option<String> readPartitionCreatedCommitTime() {
        try {
            if (!this.props.containsKey(COMMIT_TIME_KEY)) {
                this.readFromFS();
            }
            return Option.of(this.props.getProperty(COMMIT_TIME_KEY));
        }
        catch (IOException ioe) {
            LOG.warn("Error fetch Hoodie partition metadata for " + this.partitionPath, (Throwable)ioe);
            return Option.empty();
        }
    }

    public static boolean hasPartitionMetadata(FileSystem fs, Path partitionPath) {
        try {
            return HoodiePartitionMetadata.textFormatMetaPathIfExists(fs, partitionPath).isPresent() || HoodiePartitionMetadata.baseFormatMetaPathIfExists(fs, partitionPath).isPresent();
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Error checking presence of partition meta file for " + partitionPath, ioe);
        }
    }

    public static Option<Path> getPartitionMetafilePath(FileSystem fs, Path partitionPath) {
        try {
            Option<Path> textFormatPath = HoodiePartitionMetadata.textFormatMetaPathIfExists(fs, partitionPath);
            if (textFormatPath.isPresent()) {
                return textFormatPath;
            }
            return HoodiePartitionMetadata.baseFormatMetaPathIfExists(fs, partitionPath);
        }
        catch (IOException ioe) {
            throw new HoodieException("Error checking Hoodie partition metadata for " + partitionPath, ioe);
        }
    }

    public static Option<Path> baseFormatMetaPathIfExists(FileSystem fs, Path partitionPath) throws IOException {
        for (Path metafilePath : HoodiePartitionMetadata.baseFormatMetaFilePaths(partitionPath)) {
            if (!fs.exists(metafilePath)) continue;
            return Option.of(metafilePath);
        }
        return Option.empty();
    }

    public static Option<Path> textFormatMetaPathIfExists(FileSystem fs, Path partitionPath) throws IOException {
        Path path = HoodiePartitionMetadata.textFormatMetaFilePath(partitionPath);
        return Option.ofNullable(fs.exists(path) ? path : null);
    }

    static Path textFormatMetaFilePath(Path partitionPath) {
        return new Path(partitionPath, HOODIE_PARTITION_METAFILE_PREFIX);
    }

    static List<Path> baseFormatMetaFilePaths(Path partitionPath) {
        return Stream.of(HoodieFileFormat.PARQUET.getFileExtension(), HoodieFileFormat.ORC.getFileExtension()).map(ext -> new Path(partitionPath, HOODIE_PARTITION_METAFILE_PREFIX + ext)).collect(Collectors.toList());
    }
}

