/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.metrics2.lib;

import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableMetric;
import org.apache.hudi.org.apache.commons.lang3.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.Snapshot;
import org.apache.hudi.org.apache.hadoop.hbase.metrics.impl.HistogramImpl;
import org.apache.hudi.org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MutableHistogram
extends MutableMetric
implements MetricHistogram {
    protected HistogramImpl histogram;
    protected final String name;
    protected final String desc;

    public MutableHistogram(MetricsInfo info) {
        this(info.name(), info.description());
    }

    public MutableHistogram(String name, String description) {
        this.name = StringUtils.capitalize(name);
        this.desc = StringUtils.uncapitalize(description);
        this.histogram = new HistogramImpl();
    }

    @Override
    public void add(long val) {
        this.histogram.update(val);
    }

    @Override
    public long getCount() {
        return this.histogram.getCount();
    }

    public long getMax() {
        return this.histogram.getMax();
    }

    public synchronized void snapshot(MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        MutableHistogram.snapshot(this.name, this.desc, this.histogram, metricsRecordBuilder, all);
    }

    public static void snapshot(String name, String desc, Histogram histogram, MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        Snapshot snapshot = histogram.snapshot();
        if (snapshot != null) {
            MutableHistogram.updateSnapshotMetrics(name, desc, histogram, snapshot, metricsRecordBuilder);
        }
    }

    protected static void updateSnapshotMetrics(String name, String desc, Histogram histogram, Snapshot snapshot, MetricsRecordBuilder metricsRecordBuilder) {
        metricsRecordBuilder.addCounter(Interns.info(name + "_num_ops", desc), histogram.getCount());
        metricsRecordBuilder.addGauge(Interns.info(name + "_min", desc), snapshot.getMin());
        metricsRecordBuilder.addGauge(Interns.info(name + "_max", desc), snapshot.getMax());
        metricsRecordBuilder.addGauge(Interns.info(name + "_mean", desc), snapshot.getMean());
        metricsRecordBuilder.addGauge(Interns.info(name + "_25th_percentile", desc), snapshot.get25thPercentile());
        metricsRecordBuilder.addGauge(Interns.info(name + "_median", desc), snapshot.getMedian());
        metricsRecordBuilder.addGauge(Interns.info(name + "_75th_percentile", desc), snapshot.get75thPercentile());
        metricsRecordBuilder.addGauge(Interns.info(name + "_90th_percentile", desc), snapshot.get90thPercentile());
        metricsRecordBuilder.addGauge(Interns.info(name + "_95th_percentile", desc), snapshot.get95thPercentile());
        metricsRecordBuilder.addGauge(Interns.info(name + "_98th_percentile", desc), snapshot.get98thPercentile());
        metricsRecordBuilder.addGauge(Interns.info(name + "_99th_percentile", desc), snapshot.get99thPercentile());
        metricsRecordBuilder.addGauge(Interns.info(name + "_99.9th_percentile", desc), snapshot.get999thPercentile());
    }
}

