/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.avro.AvroMissingFieldException;
import org.apache.hudi.org.apache.avro.AvroRuntimeException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.data.RecordBuilder;
import org.apache.hudi.org.apache.avro.io.DatumReader;
import org.apache.hudi.org.apache.avro.io.DatumWriter;
import org.apache.hudi.org.apache.avro.io.Encoder;
import org.apache.hudi.org.apache.avro.io.ResolvingDecoder;
import org.apache.hudi.org.apache.avro.message.BinaryMessageDecoder;
import org.apache.hudi.org.apache.avro.message.BinaryMessageEncoder;
import org.apache.hudi.org.apache.avro.message.SchemaStore;
import org.apache.hudi.org.apache.avro.specific.AvroGenerated;
import org.apache.hudi.org.apache.avro.specific.SpecificData;
import org.apache.hudi.org.apache.avro.specific.SpecificRecord;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieRecordIndexInfo
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 5382693852346382355L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieRecordIndexInfo\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"partitionName\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Refers to the partition name the record belongs to\",\"default\":null},{\"name\":\"fileIdHighBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to high 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIdLowBits\",\"type\":[\"null\",\"long\"],\"doc\":\"Refers to low 64 bits if the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileIndex\",\"type\":[\"null\",\"int\"],\"doc\":\"Index representing file index which is used to re-construct UUID based fileID. Applicable when the fileId is based on UUID format. \\nA UUID based fileId is stored as 3 pieces in RLI (fileIdHighBits, fileIdLowBits and fileIndex). \\nFileID format is {UUID}-{fileIndex}.\",\"default\":null},{\"name\":\"fileId\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"Represents fileId of the location where record belongs to. When the encoding is 1, fileID is stored in raw string format.\",\"default\":null},{\"name\":\"instantTime\",\"type\":[\"null\",\"long\"],\"doc\":\"Epoch time in millisecond representing the commit time at which record was added\",\"default\":null},{\"name\":\"fileIdEncoding\",\"type\":\"int\",\"doc\":\"Represents fileId encoding. Possible values are 0 and 1. O represents UUID based fileID, and 1 represents raw string format of the fileId. \\nWhen the encoding is 0, reader can deduce fileID from fileIdLowBits, fileIdHighBits and fileIndex.\",\"default\":0},{\"name\":\"position\",\"type\":[\"null\",\"long\"],\"doc\":\"Represents position of record within a file group for easier access. It will be used for index lookup.\",\"default\":null}]}");
    private static final SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieRecordIndexInfo> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieRecordIndexInfo> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private String partitionName;
    private Long fileIdHighBits;
    private Long fileIdLowBits;
    private Integer fileIndex;
    private String fileId;
    private Long instantTime;
    private int fileIdEncoding;
    private Long position;
    private static final DatumWriter<HoodieRecordIndexInfo> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieRecordIndexInfo> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieRecordIndexInfo> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieRecordIndexInfo> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieRecordIndexInfo> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder<HoodieRecordIndexInfo>(MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieRecordIndexInfo fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieRecordIndexInfo)DECODER.decode(b);
    }

    public HoodieRecordIndexInfo() {
    }

    public HoodieRecordIndexInfo(String partitionName, Long fileIdHighBits, Long fileIdLowBits, Integer fileIndex, String fileId, Long instantTime, Integer fileIdEncoding, Long position) {
        this.partitionName = partitionName;
        this.fileIdHighBits = fileIdHighBits;
        this.fileIdLowBits = fileIdLowBits;
        this.fileIndex = fileIndex;
        this.fileId = fileId;
        this.instantTime = instantTime;
        this.fileIdEncoding = fileIdEncoding;
        this.position = position;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.partitionName;
            }
            case 1: {
                return this.fileIdHighBits;
            }
            case 2: {
                return this.fileIdLowBits;
            }
            case 3: {
                return this.fileIndex;
            }
            case 4: {
                return this.fileId;
            }
            case 5: {
                return this.instantTime;
            }
            case 6: {
                return this.fileIdEncoding;
            }
            case 7: {
                return this.position;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.partitionName = value$ != null ? value$.toString() : null;
                break;
            }
            case 1: {
                this.fileIdHighBits = (Long)value$;
                break;
            }
            case 2: {
                this.fileIdLowBits = (Long)value$;
                break;
            }
            case 3: {
                this.fileIndex = (Integer)value$;
                break;
            }
            case 4: {
                this.fileId = value$ != null ? value$.toString() : null;
                break;
            }
            case 5: {
                this.instantTime = (Long)value$;
                break;
            }
            case 6: {
                this.fileIdEncoding = (Integer)value$;
                break;
            }
            case 7: {
                this.position = (Long)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public void setPartitionName(String value) {
        this.partitionName = value;
    }

    public Long getFileIdHighBits() {
        return this.fileIdHighBits;
    }

    public void setFileIdHighBits(Long value) {
        this.fileIdHighBits = value;
    }

    public Long getFileIdLowBits() {
        return this.fileIdLowBits;
    }

    public void setFileIdLowBits(Long value) {
        this.fileIdLowBits = value;
    }

    public Integer getFileIndex() {
        return this.fileIndex;
    }

    public void setFileIndex(Integer value) {
        this.fileIndex = value;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String value) {
        this.fileId = value;
    }

    public Long getInstantTime() {
        return this.instantTime;
    }

    public void setInstantTime(Long value) {
        this.instantTime = value;
    }

    public int getFileIdEncoding() {
        return this.fileIdEncoding;
    }

    public void setFileIdEncoding(int value) {
        this.fileIdEncoding = value;
    }

    public Long getPosition() {
        return this.position;
    }

    public void setPosition(Long value) {
        this.position = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieRecordIndexInfo other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        if (this.partitionName == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.partitionName);
        }
        if (this.fileIdHighBits == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.fileIdHighBits);
        }
        if (this.fileIdLowBits == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.fileIdLowBits);
        }
        if (this.fileIndex == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeInt(this.fileIndex);
        }
        if (this.fileId == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.fileId);
        }
        if (this.instantTime == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.instantTime);
        }
        out.writeInt(this.fileIdEncoding);
        if (this.position == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeLong(this.position);
        }
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 1) {
                in.readNull();
                this.partitionName = null;
            } else {
                this.partitionName = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fileIdHighBits = null;
            } else {
                this.fileIdHighBits = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fileIdLowBits = null;
            } else {
                this.fileIdLowBits = in.readLong();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fileIndex = null;
            } else {
                this.fileIndex = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.fileId = null;
            } else {
                this.fileId = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.instantTime = null;
            } else {
                this.instantTime = in.readLong();
            }
            this.fileIdEncoding = in.readInt();
            if (in.readIndex() != 1) {
                in.readNull();
                this.position = null;
            } else {
                this.position = in.readLong();
            }
        } else {
            block10: for (int i = 0; i < 8; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.partitionName = null;
                            continue block10;
                        }
                        this.partitionName = in.readString();
                        continue block10;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fileIdHighBits = null;
                            continue block10;
                        }
                        this.fileIdHighBits = in.readLong();
                        continue block10;
                    }
                    case 2: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fileIdLowBits = null;
                            continue block10;
                        }
                        this.fileIdLowBits = in.readLong();
                        continue block10;
                    }
                    case 3: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fileIndex = null;
                            continue block10;
                        }
                        this.fileIndex = in.readInt();
                        continue block10;
                    }
                    case 4: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.fileId = null;
                            continue block10;
                        }
                        this.fileId = in.readString();
                        continue block10;
                    }
                    case 5: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.instantTime = null;
                            continue block10;
                        }
                        this.instantTime = in.readLong();
                        continue block10;
                    }
                    case 6: {
                        this.fileIdEncoding = in.readInt();
                        continue block10;
                    }
                    case 7: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.position = null;
                            continue block10;
                        }
                        this.position = in.readLong();
                        continue block10;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieRecordIndexInfo>
    implements RecordBuilder<HoodieRecordIndexInfo> {
        private String partitionName;
        private Long fileIdHighBits;
        private Long fileIdLowBits;
        private Integer fileIndex;
        private String fileId;
        private Long instantTime;
        private int fileIdEncoding;
        private Long position;

        private Builder() {
            super(SCHEMA$, MODEL$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.partitionName)) {
                this.partitionName = this.data().deepCopy(this.fields()[0].schema(), other.partitionName);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.fileIdHighBits)) {
                this.fileIdHighBits = this.data().deepCopy(this.fields()[1].schema(), other.fileIdHighBits);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.fileIdLowBits)) {
                this.fileIdLowBits = this.data().deepCopy(this.fields()[2].schema(), other.fileIdLowBits);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
            if (Builder.isValidValue(this.fields()[3], other.fileIndex)) {
                this.fileIndex = this.data().deepCopy(this.fields()[3].schema(), other.fileIndex);
                this.fieldSetFlags()[3] = other.fieldSetFlags()[3];
            }
            if (Builder.isValidValue(this.fields()[4], other.fileId)) {
                this.fileId = this.data().deepCopy(this.fields()[4].schema(), other.fileId);
                this.fieldSetFlags()[4] = other.fieldSetFlags()[4];
            }
            if (Builder.isValidValue(this.fields()[5], other.instantTime)) {
                this.instantTime = this.data().deepCopy(this.fields()[5].schema(), other.instantTime);
                this.fieldSetFlags()[5] = other.fieldSetFlags()[5];
            }
            if (Builder.isValidValue(this.fields()[6], other.fileIdEncoding)) {
                this.fileIdEncoding = this.data().deepCopy(this.fields()[6].schema(), other.fileIdEncoding);
                this.fieldSetFlags()[6] = other.fieldSetFlags()[6];
            }
            if (Builder.isValidValue(this.fields()[7], other.position)) {
                this.position = this.data().deepCopy(this.fields()[7].schema(), other.position);
                this.fieldSetFlags()[7] = other.fieldSetFlags()[7];
            }
        }

        private Builder(HoodieRecordIndexInfo other) {
            super(SCHEMA$, MODEL$);
            if (Builder.isValidValue(this.fields()[0], other.partitionName)) {
                this.partitionName = this.data().deepCopy(this.fields()[0].schema(), other.partitionName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.fileIdHighBits)) {
                this.fileIdHighBits = this.data().deepCopy(this.fields()[1].schema(), other.fileIdHighBits);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.fileIdLowBits)) {
                this.fileIdLowBits = this.data().deepCopy(this.fields()[2].schema(), other.fileIdLowBits);
                this.fieldSetFlags()[2] = true;
            }
            if (Builder.isValidValue(this.fields()[3], other.fileIndex)) {
                this.fileIndex = this.data().deepCopy(this.fields()[3].schema(), other.fileIndex);
                this.fieldSetFlags()[3] = true;
            }
            if (Builder.isValidValue(this.fields()[4], other.fileId)) {
                this.fileId = this.data().deepCopy(this.fields()[4].schema(), other.fileId);
                this.fieldSetFlags()[4] = true;
            }
            if (Builder.isValidValue(this.fields()[5], other.instantTime)) {
                this.instantTime = this.data().deepCopy(this.fields()[5].schema(), other.instantTime);
                this.fieldSetFlags()[5] = true;
            }
            if (Builder.isValidValue(this.fields()[6], other.fileIdEncoding)) {
                this.fileIdEncoding = this.data().deepCopy(this.fields()[6].schema(), other.fileIdEncoding);
                this.fieldSetFlags()[6] = true;
            }
            if (Builder.isValidValue(this.fields()[7], other.position)) {
                this.position = this.data().deepCopy(this.fields()[7].schema(), other.position);
                this.fieldSetFlags()[7] = true;
            }
        }

        public String getPartitionName() {
            return this.partitionName;
        }

        public Builder setPartitionName(String value) {
            this.validate(this.fields()[0], value);
            this.partitionName = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasPartitionName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearPartitionName() {
            this.partitionName = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Long getFileIdHighBits() {
            return this.fileIdHighBits;
        }

        public Builder setFileIdHighBits(Long value) {
            this.validate(this.fields()[1], value);
            this.fileIdHighBits = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasFileIdHighBits() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearFileIdHighBits() {
            this.fileIdHighBits = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public Long getFileIdLowBits() {
            return this.fileIdLowBits;
        }

        public Builder setFileIdLowBits(Long value) {
            this.validate(this.fields()[2], value);
            this.fileIdLowBits = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasFileIdLowBits() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearFileIdLowBits() {
            this.fileIdLowBits = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        public Integer getFileIndex() {
            return this.fileIndex;
        }

        public Builder setFileIndex(Integer value) {
            this.validate(this.fields()[3], value);
            this.fileIndex = value;
            this.fieldSetFlags()[3] = true;
            return this;
        }

        public boolean hasFileIndex() {
            return this.fieldSetFlags()[3];
        }

        public Builder clearFileIndex() {
            this.fileIndex = null;
            this.fieldSetFlags()[3] = false;
            return this;
        }

        public String getFileId() {
            return this.fileId;
        }

        public Builder setFileId(String value) {
            this.validate(this.fields()[4], value);
            this.fileId = value;
            this.fieldSetFlags()[4] = true;
            return this;
        }

        public boolean hasFileId() {
            return this.fieldSetFlags()[4];
        }

        public Builder clearFileId() {
            this.fileId = null;
            this.fieldSetFlags()[4] = false;
            return this;
        }

        public Long getInstantTime() {
            return this.instantTime;
        }

        public Builder setInstantTime(Long value) {
            this.validate(this.fields()[5], value);
            this.instantTime = value;
            this.fieldSetFlags()[5] = true;
            return this;
        }

        public boolean hasInstantTime() {
            return this.fieldSetFlags()[5];
        }

        public Builder clearInstantTime() {
            this.instantTime = null;
            this.fieldSetFlags()[5] = false;
            return this;
        }

        public int getFileIdEncoding() {
            return this.fileIdEncoding;
        }

        public Builder setFileIdEncoding(int value) {
            this.validate(this.fields()[6], value);
            this.fileIdEncoding = value;
            this.fieldSetFlags()[6] = true;
            return this;
        }

        public boolean hasFileIdEncoding() {
            return this.fieldSetFlags()[6];
        }

        public Builder clearFileIdEncoding() {
            this.fieldSetFlags()[6] = false;
            return this;
        }

        public Long getPosition() {
            return this.position;
        }

        public Builder setPosition(Long value) {
            this.validate(this.fields()[7], value);
            this.position = value;
            this.fieldSetFlags()[7] = true;
            return this;
        }

        public boolean hasPosition() {
            return this.fieldSetFlags()[7];
        }

        public Builder clearPosition() {
            this.position = null;
            this.fieldSetFlags()[7] = false;
            return this;
        }

        @Override
        public HoodieRecordIndexInfo build() {
            try {
                HoodieRecordIndexInfo record = new HoodieRecordIndexInfo();
                record.partitionName = this.fieldSetFlags()[0] ? this.partitionName : (String)this.defaultValue(this.fields()[0]);
                record.fileIdHighBits = this.fieldSetFlags()[1] ? this.fileIdHighBits : (Long)this.defaultValue(this.fields()[1]);
                record.fileIdLowBits = this.fieldSetFlags()[2] ? this.fileIdLowBits : (Long)this.defaultValue(this.fields()[2]);
                record.fileIndex = this.fieldSetFlags()[3] ? this.fileIndex : (Integer)this.defaultValue(this.fields()[3]);
                record.fileId = this.fieldSetFlags()[4] ? this.fileId : (String)this.defaultValue(this.fields()[4]);
                record.instantTime = this.fieldSetFlags()[5] ? this.instantTime : (Long)this.defaultValue(this.fields()[5]);
                record.fileIdEncoding = this.fieldSetFlags()[6] ? this.fileIdEncoding : (Integer)this.defaultValue(this.fields()[6]);
                record.position = this.fieldSetFlags()[7] ? this.position : (Long)this.defaultValue(this.fields()[7]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

