/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hudi.avro.JsonEncoder;
import org.apache.hudi.avro.model.HoodieArchivedMetaEntry;
import org.apache.hudi.avro.model.HoodieCommitMetadata;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieLSMTimelineInstant;
import org.apache.hudi.avro.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.model.ActionType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.ActiveAction;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.CleanerUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericDatumWriter;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hudi.org.apache.avro.specific.SpecificRecord;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;

public class MetadataConversionUtils {
    public static HoodieArchivedMetaEntry createMetaWrapper(HoodieInstant hoodieInstant, HoodieTableMetaClient metaClient) throws IOException {
        Option<byte[]> instantDetails = metaClient.getActiveTimeline().getInstantDetails(hoodieInstant);
        if (hoodieInstant.isCompleted() && instantDetails.get().length == 0) {
            return MetadataConversionUtils.createMetaWrapperForEmptyInstant(hoodieInstant);
        }
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.requestedTime());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        archivedMetaWrapper.setStateTransitionTime(hoodieInstant.getCompletionTime());
        switch (hoodieInstant.getAction()) {
            case "clean": {
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieCleanMetadata(CleanerUtils.getCleanerMetadata(metaClient, instantDetails.get()));
                } else {
                    archivedMetaWrapper.setHoodieCleanerPlan(CleanerUtils.getCleanerPlan(metaClient, instantDetails.get()));
                }
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": {
                org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = metaClient.getCommitMetadataSerDe().deserialize(hoodieInstant, instantDetails.get(), org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata((HoodieCommitMetadata)MetadataConversionUtils.convertCommitMetadata(commitMetadata));
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                break;
            }
            case "deltacommit": {
                org.apache.hudi.common.model.HoodieCommitMetadata deltaCommitMetadata = metaClient.getCommitMetadataSerDe().deserialize(hoodieInstant, instantDetails.get(), org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata((HoodieCommitMetadata)MetadataConversionUtils.convertCommitMetadata(deltaCommitMetadata));
                archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                break;
            }
            case "replacecommit": 
            case "clustering": {
                if (hoodieInstant.isCompleted()) {
                    org.apache.hudi.common.model.HoodieReplaceCommitMetadata replaceCommitMetadata = org.apache.hudi.common.model.HoodieReplaceCommitMetadata.fromBytes(instantDetails.get(), org.apache.hudi.common.model.HoodieReplaceCommitMetadata.class);
                    archivedMetaWrapper.setHoodieReplaceCommitMetadata(MetadataConversionUtils.convertReplaceCommitMetadata(replaceCommitMetadata));
                } else if (hoodieInstant.isInflight()) {
                    Option<org.apache.hudi.common.model.HoodieCommitMetadata> inflightCommitMetadata = MetadataConversionUtils.getInflightCommitMetadata(metaClient, hoodieInstant, instantDetails);
                    if (inflightCommitMetadata.isPresent()) {
                        archivedMetaWrapper.setHoodieInflightReplaceMetadata((HoodieCommitMetadata)MetadataConversionUtils.convertCommitMetadata(inflightCommitMetadata.get()));
                    }
                } else {
                    Option<HoodieRequestedReplaceMetadata> requestedReplaceMetadata = MetadataConversionUtils.getRequestedReplaceMetadata(instantDetails);
                    if (requestedReplaceMetadata.isPresent()) {
                        archivedMetaWrapper.setHoodieRequestedReplaceMetadata(requestedReplaceMetadata.get());
                    }
                }
                archivedMetaWrapper.setActionType(hoodieInstant.getAction().equals("replacecommit") ? ActionType.replacecommit.name() : ActionType.clustering.name());
                break;
            }
            case "rollback": {
                if (hoodieInstant.isCompleted()) {
                    archivedMetaWrapper.setHoodieRollbackMetadata(TimelineMetadataUtils.deserializeAvroMetadata(instantDetails.get(), HoodieRollbackMetadata.class));
                }
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setHoodieSavePointMetadata(TimelineMetadataUtils.deserializeAvroMetadata(instantDetails.get(), HoodieSavepointMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                if (hoodieInstant.isRequested()) {
                    HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, instantDetails);
                    archivedMetaWrapper.setHoodieCompactionPlan(plan);
                }
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            case "logcompaction": {
                if (hoodieInstant.isRequested()) {
                    HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, instantDetails);
                    archivedMetaWrapper.setHoodieCompactionPlan(plan);
                }
                archivedMetaWrapper.setActionType(ActionType.logcompaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    public static HoodieArchivedMetaEntry createMetaWrapper(HoodieTableMetaClient metaClient, GenericRecord lsmTimelineRecord) throws IOException {
        ValidationUtils.checkState(metaClient.getTableConfig().getTableVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT), "The meta client should be created from table version >= 8");
        ByteBuffer metadataBuffer = (ByteBuffer)lsmTimelineRecord.get("metadata");
        Option<byte[]> instantDetails = metadataBuffer != null ? Option.of(metadataBuffer.array()) : Option.empty();
        ByteBuffer planBuffer = (ByteBuffer)lsmTimelineRecord.get("plan");
        Option<byte[]> planBytes = planBuffer != null ? Option.of(planBuffer.array()) : Option.empty();
        String instantTime = lsmTimelineRecord.get("instantTime").toString();
        String completionTime = lsmTimelineRecord.get("completionTime").toString();
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(instantTime);
        archivedMetaWrapper.setActionState(HoodieInstant.State.COMPLETED.name());
        archivedMetaWrapper.setStateTransitionTime(completionTime);
        String actionType = lsmTimelineRecord.get("action").toString();
        HoodieInstant instant = metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, actionType, instantTime, completionTime);
        switch (actionType) {
            case "clean": {
                archivedMetaWrapper.setHoodieCleanMetadata(CleanerUtils.getCleanerMetadata(metaClient, (byte[])instantDetails.get()));
                archivedMetaWrapper.setHoodieCleanerPlan(CleanerUtils.getCleanerPlan(metaClient, planBytes.get()));
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": {
                org.apache.hudi.common.model.HoodieCommitMetadata commitMetadata = metaClient.getCommitMetadataSerDe().deserialize(instant, (byte[])instantDetails.get(), org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata((HoodieCommitMetadata)MetadataConversionUtils.convertCommitMetadata(commitMetadata));
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                if (!planBytes.isPresent()) break;
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, planBytes);
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                break;
            }
            case "deltacommit": {
                org.apache.hudi.common.model.HoodieCommitMetadata deltaCommitMetadata = metaClient.getCommitMetadataSerDe().deserialize(instant, (byte[])instantDetails.get(), org.apache.hudi.common.model.HoodieCommitMetadata.class);
                archivedMetaWrapper.setHoodieCommitMetadata((HoodieCommitMetadata)MetadataConversionUtils.convertCommitMetadata(deltaCommitMetadata));
                archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                if (!planBytes.isPresent()) break;
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, planBytes);
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                break;
            }
            case "replacecommit": 
            case "clustering": {
                org.apache.hudi.common.model.HoodieReplaceCommitMetadata replaceCommitMetadata = org.apache.hudi.common.model.HoodieReplaceCommitMetadata.fromBytes((byte[])instantDetails.get(), org.apache.hudi.common.model.HoodieReplaceCommitMetadata.class);
                archivedMetaWrapper.setHoodieReplaceCommitMetadata(MetadataConversionUtils.convertReplaceCommitMetadata(replaceCommitMetadata));
                Option<org.apache.hudi.common.model.HoodieCommitMetadata> inflightCommitMetadata = MetadataConversionUtils.getInflightCommitMetadata(metaClient, instant, instantDetails);
                if (inflightCommitMetadata.isPresent()) {
                    archivedMetaWrapper.setHoodieInflightReplaceMetadata((HoodieCommitMetadata)MetadataConversionUtils.convertCommitMetadata(inflightCommitMetadata.get()));
                }
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                break;
            }
            case "rollback": {
                archivedMetaWrapper.setHoodieRollbackMetadata(TimelineMetadataUtils.deserializeAvroMetadata((byte[])instantDetails.get(), HoodieRollbackMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setHoodieSavePointMetadata(TimelineMetadataUtils.deserializeAvroMetadata((byte[])instantDetails.get(), HoodieSavepointMetadata.class));
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, planBytes);
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            case "logcompaction": {
                HoodieCompactionPlan plan = CompactionUtils.getCompactionPlan(metaClient, planBytes);
                archivedMetaWrapper.setHoodieCompactionPlan(plan);
                archivedMetaWrapper.setActionType(ActionType.logcompaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    public static HoodieLSMTimelineInstant createLSMTimelineInstant(ActiveAction activeAction, HoodieTableMetaClient metaClient) {
        HoodieLSMTimelineInstant lsmTimelineInstant = new HoodieLSMTimelineInstant();
        lsmTimelineInstant.setInstantTime(activeAction.getInstantTime());
        lsmTimelineInstant.setCompletionTime(activeAction.getCompletionTime());
        lsmTimelineInstant.setAction(activeAction.getAction());
        activeAction.getCommitMetadata(metaClient).ifPresent(commitMetadata -> lsmTimelineInstant.setMetadata(ByteBuffer.wrap(commitMetadata)));
        lsmTimelineInstant.setVersion(1);
        switch (activeAction.getPendingAction()) {
            case "clean": {
                activeAction.getCleanPlan(metaClient).ifPresent(plan -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(plan)));
                break;
            }
            case "replacecommit": 
            case "clustering": {
                activeAction.getRequestedCommitMetadata(metaClient).ifPresent(metadata -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(metadata)));
                activeAction.getInflightCommitMetadata(metaClient).ifPresent(metadata -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(metadata)));
                break;
            }
            case "compaction": {
                activeAction.getCompactionPlan(metaClient).ifPresent(plan -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(plan)));
                break;
            }
            case "logcompaction": {
                activeAction.getLogCompactionPlan(metaClient).ifPresent(plan -> lsmTimelineInstant.setPlan(ByteBuffer.wrap(plan)));
                break;
            }
        }
        return lsmTimelineInstant;
    }

    public static HoodieArchivedMetaEntry createMetaWrapperForEmptyInstant(HoodieInstant hoodieInstant) {
        HoodieArchivedMetaEntry archivedMetaWrapper = new HoodieArchivedMetaEntry();
        archivedMetaWrapper.setCommitTime(hoodieInstant.requestedTime());
        archivedMetaWrapper.setActionState(hoodieInstant.getState().name());
        archivedMetaWrapper.setStateTransitionTime(hoodieInstant.getCompletionTime());
        switch (hoodieInstant.getAction()) {
            case "clean": {
                archivedMetaWrapper.setActionType(ActionType.clean.name());
                break;
            }
            case "commit": {
                archivedMetaWrapper.setActionType(ActionType.commit.name());
                break;
            }
            case "deltacommit": {
                archivedMetaWrapper.setActionType(ActionType.deltacommit.name());
                break;
            }
            case "replacecommit": {
                archivedMetaWrapper.setActionType(ActionType.replacecommit.name());
                break;
            }
            case "clustering": {
                archivedMetaWrapper.setActionType(ActionType.clustering.name());
                break;
            }
            case "rollback": {
                archivedMetaWrapper.setActionType(ActionType.rollback.name());
                break;
            }
            case "savepoint": {
                archivedMetaWrapper.setActionType(ActionType.savepoint.name());
                break;
            }
            case "compaction": {
                archivedMetaWrapper.setActionType(ActionType.compaction.name());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Action not fully supported yet");
            }
        }
        return archivedMetaWrapper;
    }

    private static Option<org.apache.hudi.common.model.HoodieCommitMetadata> getInflightCommitMetadata(HoodieTableMetaClient metaClient, HoodieInstant instant, Option<byte[]> inflightContent) throws IOException {
        if (!inflightContent.isPresent() || inflightContent.get().length == 0) {
            return Option.empty();
        }
        return Option.of(metaClient.getCommitMetadataSerDe().deserialize(instant, inflightContent.get(), org.apache.hudi.common.model.HoodieCommitMetadata.class));
    }

    private static Option<HoodieRequestedReplaceMetadata> getRequestedReplaceMetadata(Option<byte[]> requestedContent) throws IOException {
        if (!requestedContent.isPresent() || requestedContent.get().length == 0) {
            return Option.empty();
        }
        return Option.of(TimelineMetadataUtils.deserializeRequestedReplaceMetadata(requestedContent.get()));
    }

    public static Option<org.apache.hudi.common.model.HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTableMetaClient metaClient, HoodieInstant hoodieInstant) throws IOException {
        HoodieTimeline timeline = metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
        return Option.of(TimelineUtils.getCommitMetadata(hoodieInstant, timeline));
    }

    public static <T extends SpecificRecordBase> T convertCommitMetadata(org.apache.hudi.common.model.HoodieCommitMetadata hoodieCommitMetadata) {
        if (hoodieCommitMetadata instanceof org.apache.hudi.common.model.HoodieReplaceCommitMetadata) {
            return (T)MetadataConversionUtils.convertReplaceCommitMetadata((org.apache.hudi.common.model.HoodieReplaceCommitMetadata)hoodieCommitMetadata);
        }
        hoodieCommitMetadata.getPartitionToWriteStats().remove(null);
        HoodieCommitMetadata avroMetaData = (HoodieCommitMetadata)JsonUtils.getObjectMapper().convertValue((Object)hoodieCommitMetadata, HoodieCommitMetadata.class);
        return (T)avroMetaData;
    }

    private static HoodieReplaceCommitMetadata convertReplaceCommitMetadata(org.apache.hudi.common.model.HoodieReplaceCommitMetadata replaceCommitMetadata) {
        replaceCommitMetadata.getPartitionToWriteStats().remove(null);
        replaceCommitMetadata.getPartitionToReplaceFileIds().remove(null);
        return (HoodieReplaceCommitMetadata)JsonUtils.getObjectMapper().convertValue((Object)replaceCommitMetadata, HoodieReplaceCommitMetadata.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends SpecificRecordBase> byte[] convertCommitMetadataToJsonBytes(T avroMetaData, Class<T> clazz) {
        Schema avroSchema = clazz == HoodieReplaceCommitMetadata.class ? HoodieReplaceCommitMetadata.getClassSchema() : HoodieCommitMetadata.getClassSchema();
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            JsonEncoder jsonEncoder = new JsonEncoder(avroSchema, outputStream);
            GenericDatumWriter writer = avroMetaData instanceof SpecificRecord ? new SpecificDatumWriter(avroSchema) : new GenericDatumWriter(avroSchema);
            writer.write(avroMetaData, jsonEncoder);
            jsonEncoder.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to convert to JSON.", e);
        }
    }
}

