/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.collection;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.collection.KeyFilteringIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiskMap<T extends Serializable, R extends Serializable>
implements Map<T, R>,
KeyFilteringIterable<T, R> {
    private static final Logger LOG = LoggerFactory.getLogger(DiskMap.class);
    private static final String SUBFOLDER_PREFIX = "hudi";
    private final File diskMapPathFile;
    private transient Thread shutdownThread = null;
    protected final String diskMapPath;

    public DiskMap(String basePath, String prefix) throws IOException {
        this.diskMapPath = String.format("%s/%s-%s-%s", basePath, SUBFOLDER_PREFIX, prefix, UUID.randomUUID().toString());
        this.diskMapPathFile = new File(this.diskMapPath);
        FileIOUtils.deleteDirectory(this.diskMapPathFile);
        FileIOUtils.mkdir(this.diskMapPathFile);
        this.diskMapPathFile.deleteOnExit();
        this.addShutDownHook();
    }

    private void addShutDownHook() {
        this.shutdownThread = new Thread(() -> {
            LOG.warn("Failed to properly close DiskMap in application");
            this.cleanup();
        });
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
    }

    abstract Stream<R> valueStream();

    abstract long sizeOfFileOnDiskInBytes();

    public void close() {
        this.cleanup(false);
    }

    private void cleanup() {
        this.cleanup(true);
    }

    private void cleanup(boolean isTriggeredFromShutdownHook) {
        try {
            FileIOUtils.deleteDirectory(this.diskMapPathFile);
        }
        catch (IOException exception) {
            LOG.warn("Error while deleting the disk map directory=" + this.diskMapPath, (Throwable)exception);
        }
        if (!isTriggeredFromShutdownHook && this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        }
    }
}

