/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieEmptyRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.hadoop.DefaultHiveRecordMerger;
import org.apache.hudi.hadoop.HoodieFileGroupReaderBasedRecordReader;
import org.apache.hudi.hadoop.HoodieHiveRecord;
import org.apache.hudi.hadoop.OverwriteWithLatestHiveRecordMerger;
import org.apache.hudi.hadoop.RecordReaderValueIterator;
import org.apache.hudi.hadoop.utils.HoodieArrayWritableAvroUtils;
import org.apache.hudi.hadoop.utils.HoodieRealtimeRecordReaderUtils;
import org.apache.hudi.hadoop.utils.ObjectInspectorCache;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class HiveHoodieReaderContext
extends HoodieReaderContext<ArrayWritable> {
    protected final HoodieFileGroupReaderBasedRecordReader.HiveReaderCreator readerCreator;
    protected final Map<String, TypeInfo> columnTypeMap;
    private final ObjectInspectorCache objectInspectorCache;
    private RecordReader<NullWritable, ArrayWritable> firstRecordReader = null;
    private final List<String> partitionCols;
    private final Set<String> partitionColSet;
    private final String recordKeyField;

    protected HiveHoodieReaderContext(HoodieFileGroupReaderBasedRecordReader.HiveReaderCreator readerCreator, String recordKeyField, List<String> partitionCols, ObjectInspectorCache objectInspectorCache) {
        this.readerCreator = readerCreator;
        this.partitionCols = partitionCols;
        this.partitionColSet = new HashSet<String>(this.partitionCols);
        this.recordKeyField = recordKeyField;
        this.objectInspectorCache = objectInspectorCache;
        this.columnTypeMap = objectInspectorCache.getColumnTypeMap();
    }

    private void setSchemas(JobConf jobConf, Schema dataSchema, Schema requiredSchema) {
        List dataColumnNameList = dataSchema.getFields().stream().map(f -> f.name().toLowerCase(Locale.ROOT)).collect(Collectors.toList());
        List dataColumnTypeList = dataColumnNameList.stream().map(fieldName -> {
            TypeInfo type = this.columnTypeMap.get(fieldName);
            if (type == null) {
                throw new IllegalArgumentException("Field: " + fieldName + ", does not have a defined type");
            }
            return type;
        }).collect(Collectors.toList());
        jobConf.set("columns", String.join((CharSequence)",", dataColumnNameList));
        jobConf.set("columns.types", dataColumnTypeList.stream().map(TypeInfo::getQualifiedName).collect(Collectors.joining(",")));
        String readColNames = requiredSchema.getFields().stream().map(f -> f.name()).collect(Collectors.joining(","));
        jobConf.set("hive.io.file.readcolumn.names", readColNames);
        jobConf.set("hive.io.file.readcolumn.ids", requiredSchema.getFields().stream().map(f -> String.valueOf(dataSchema.getField(f.name()).pos())).collect(Collectors.joining(",")));
    }

    @Override
    public ClosableIterator<ArrayWritable> getFileRecordIterator(StoragePath filePath, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        return this.getFileRecordIterator(filePath, null, start, length, dataSchema, requiredSchema, storage);
    }

    @Override
    public ClosableIterator<ArrayWritable> getFileRecordIterator(StoragePathInfo storagePathInfo, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        return this.getFileRecordIterator(storagePathInfo.getPath(), storagePathInfo.getLocations(), start, length, dataSchema, requiredSchema, storage);
    }

    private ClosableIterator<ArrayWritable> getFileRecordIterator(StoragePath filePath, String[] hosts, long start, long length, Schema dataSchema, Schema requiredSchema, HoodieStorage storage) throws IOException {
        JobConf jobConfCopy = new JobConf(storage.getConf().unwrapAs(Configuration.class));
        if (this.getNeedsBootstrapMerge()) {
            jobConfCopy.unset("hive.io.filter.expr.serialized");
            jobConfCopy.unset("sarg.pushdown");
        }
        Schema modifiedDataSchema = HoodieAvroUtils.generateProjectionSchema(dataSchema, Stream.concat(dataSchema.getFields().stream().map(f -> f.name().toLowerCase(Locale.ROOT)).filter(n -> !this.partitionColSet.contains(n)), this.partitionCols.stream().filter(c -> dataSchema.getField((String)c) != null)).collect(Collectors.toList()));
        this.setSchemas(jobConfCopy, modifiedDataSchema, requiredSchema);
        FileSplit inputSplit = new FileSplit(new Path(filePath.toString()), start, length, hosts);
        RecordReader<NullWritable, ArrayWritable> recordReader = this.readerCreator.getRecordReader((InputSplit)inputSplit, jobConfCopy);
        if (this.firstRecordReader == null) {
            this.firstRecordReader = recordReader;
        }
        RecordReaderValueIterator<NullWritable, ArrayWritable> recordIterator = new RecordReaderValueIterator<NullWritable, ArrayWritable>(recordReader);
        if (modifiedDataSchema.equals(requiredSchema)) {
            return recordIterator;
        }
        return new CloseableMappingIterator(recordIterator, this.projectRecord(modifiedDataSchema, requiredSchema));
    }

    @Override
    public ArrayWritable convertAvroRecord(IndexedRecord avroRecord) {
        return (ArrayWritable)HoodieRealtimeRecordReaderUtils.avroToArrayWritable(avroRecord, avroRecord.getSchema(), true);
    }

    @Override
    public GenericRecord convertToAvroRecord(ArrayWritable record, Schema schema) {
        return this.objectInspectorCache.serialize(record, schema);
    }

    @Override
    public Option<HoodieRecordMerger> getRecordMerger(RecordMergeMode mergeMode, String mergeStrategyId, String mergeImplClasses) {
        switch (mergeMode) {
            case EVENT_TIME_ORDERING: {
                return Option.of(new DefaultHiveRecordMerger());
            }
            case COMMIT_TIME_ORDERING: {
                return Option.of(new OverwriteWithLatestHiveRecordMerger());
            }
        }
        if (mergeStrategyId.equals("00000000-0000-0000-0000-000000000000")) {
            return Option.of(HoodieAvroRecordMerger.INSTANCE);
        }
        Option<HoodieRecordMerger> mergerClass = HoodieRecordUtils.createValidRecordMerger(EngineType.JAVA, mergeImplClasses, mergeStrategyId);
        if (mergerClass.isEmpty()) {
            throw new IllegalArgumentException("No valid hive merger implementation set for `hoodie.write.record.merge.custom.implementation.classes`");
        }
        return mergerClass;
    }

    @Override
    public String getRecordKey(ArrayWritable record, Schema schema) {
        return this.getValue(record, schema, this.recordKeyField).toString();
    }

    @Override
    public Object getValue(ArrayWritable record, Schema schema, String fieldName) {
        return StringUtils.isNullOrEmpty(fieldName) ? null : this.objectInspectorCache.getValue(record, schema, fieldName);
    }

    @Override
    public HoodieRecord<ArrayWritable> constructHoodieRecord(Option<ArrayWritable> recordOption, Map<String, Object> metadataMap) {
        if (!recordOption.isPresent()) {
            return new HoodieEmptyRecord<ArrayWritable>(new HoodieKey((String)metadataMap.get("_0"), (String)metadataMap.get("_1")), HoodieRecord.HoodieRecordType.HIVE);
        }
        Schema schema = this.getSchemaFromMetadata(metadataMap);
        ArrayWritable writable = recordOption.get();
        return new HoodieHiveRecord(new HoodieKey((String)metadataMap.get("_0"), (String)metadataMap.get("_1")), writable, schema, this.objectInspectorCache);
    }

    @Override
    public ArrayWritable seal(ArrayWritable record) {
        return new ArrayWritable(Writable.class, Arrays.copyOf(record.get(), record.get().length));
    }

    @Override
    public ClosableIterator<ArrayWritable> mergeBootstrapReaders(final ClosableIterator<ArrayWritable> skeletonFileIterator, Schema skeletonRequiredSchema, final ClosableIterator<ArrayWritable> dataFileIterator, Schema dataRequiredSchema) {
        final int skeletonLen = skeletonRequiredSchema.getFields().size();
        final int dataLen = dataRequiredSchema.getFields().size();
        return new ClosableIterator<ArrayWritable>(){
            private final ArrayWritable returnWritable = new ArrayWritable(Writable.class);

            @Override
            public boolean hasNext() {
                if (dataFileIterator.hasNext() != skeletonFileIterator.hasNext()) {
                    throw new IllegalStateException("bootstrap data file iterator and skeleton file iterator are out of sync");
                }
                return dataFileIterator.hasNext();
            }

            @Override
            public ArrayWritable next() {
                Writable[] skeletonWritable = ((ArrayWritable)skeletonFileIterator.next()).get();
                Writable[] dataWritable = ((ArrayWritable)dataFileIterator.next()).get();
                Writable[] mergedWritable = new Writable[skeletonLen + dataLen];
                System.arraycopy(skeletonWritable, 0, mergedWritable, 0, skeletonLen);
                System.arraycopy(dataWritable, 0, mergedWritable, skeletonLen, dataLen);
                this.returnWritable.set(mergedWritable);
                return this.returnWritable;
            }

            @Override
            public void close() {
                skeletonFileIterator.close();
                dataFileIterator.close();
            }
        };
    }

    @Override
    public UnaryOperator<ArrayWritable> projectRecord(Schema from, Schema to, Map<String, String> renamedColumns) {
        if (!renamedColumns.isEmpty()) {
            throw new IllegalStateException("Schema evolution is not supported in the filegroup reader for Hive currently");
        }
        return HoodieArrayWritableAvroUtils.projectRecord(from, to);
    }

    @Override
    public Comparable convertValueToEngineType(Comparable value) {
        if (value instanceof WritableComparable) {
            return value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return new Text((String)((Object)value));
        }
        if (value instanceof Integer) {
            return new IntWritable(((Integer)value).intValue());
        }
        if (value instanceof Long) {
            return new LongWritable(((Long)value).longValue());
        }
        if (value instanceof Float) {
            return new FloatWritable(((Float)value).floatValue());
        }
        if (value instanceof Double) {
            return new DoubleWritable(((Double)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return new BooleanWritable(((Boolean)value).booleanValue());
        }
        return value;
    }

    public UnaryOperator<ArrayWritable> reverseProjectRecord(Schema from, Schema to) {
        return HoodieArrayWritableAvroUtils.reverseProject(from, to);
    }

    public long getPos() throws IOException {
        if (this.firstRecordReader != null) {
            return this.firstRecordReader.getPos();
        }
        throw new IllegalStateException("getPos() should not be called before a record reader has been initialized");
    }

    public float getProgress() throws IOException {
        if (this.firstRecordReader != null) {
            return this.firstRecordReader.getProgress();
        }
        throw new IllegalStateException("getProgress() should not be called before a record reader has been initialized");
    }
}

