/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.CellComparator;
import org.apache.hudi.org.apache.hadoop.hbase.KeepDeletedCells;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class ScanInfo {
    private byte[] family;
    private int minVersions;
    private int maxVersions;
    private long ttl;
    private KeepDeletedCells keepDeletedCells;
    private long timeToPurgeDeletes;
    private CellComparator comparator;
    private long tableMaxRowSize;
    private boolean usePread;
    private long cellsPerTimeoutCheck;
    private boolean parallelSeekEnabled;
    private final long preadMaxBytes;
    private final boolean newVersionBehavior;
    public static final long FIXED_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 2 * ClassSize.REFERENCE + 8 + 32 + 4);

    public ScanInfo(Configuration conf, ColumnFamilyDescriptor family, long ttl, long timeToPurgeDeletes, CellComparator comparator) {
        this(conf, family.getName(), family.getMinVersions(), family.getMaxVersions(), ttl, family.getKeepDeletedCells(), family.getBlocksize(), timeToPurgeDeletes, comparator, family.isNewVersionBehavior());
    }

    private static long getCellsPerTimeoutCheck(Configuration conf) {
        long perHeartbeat = conf.getLong("hbase.cells.scanned.per.heartbeat.check", 10000L);
        return perHeartbeat > 0L ? perHeartbeat : 10000L;
    }

    public ScanInfo(Configuration conf, byte[] family, int minVersions, int maxVersions, long ttl, KeepDeletedCells keepDeletedCells, long blockSize, long timeToPurgeDeletes, CellComparator comparator, boolean newVersionBehavior) {
        this(family, minVersions, maxVersions, ttl, keepDeletedCells, timeToPurgeDeletes, comparator, conf.getLong("hbase.table.max.rowsize", 0x40000000L), conf.getBoolean("hbase.storescanner.use.pread", false), ScanInfo.getCellsPerTimeoutCheck(conf), conf.getBoolean("hbase.storescanner.parallel.seek.enable", false), conf.getLong("hbase.storescanner.pread.max.bytes", 4L * blockSize), newVersionBehavior);
    }

    private ScanInfo(byte[] family, int minVersions, int maxVersions, long ttl, KeepDeletedCells keepDeletedCells, long timeToPurgeDeletes, CellComparator comparator, long tableMaxRowSize, boolean usePread, long cellsPerTimeoutCheck, boolean parallelSeekEnabled, long preadMaxBytes, boolean newVersionBehavior) {
        this.family = family;
        this.minVersions = minVersions;
        this.maxVersions = maxVersions;
        this.ttl = ttl;
        this.keepDeletedCells = keepDeletedCells;
        this.timeToPurgeDeletes = timeToPurgeDeletes;
        this.comparator = comparator;
        this.tableMaxRowSize = tableMaxRowSize;
        this.usePread = usePread;
        this.cellsPerTimeoutCheck = cellsPerTimeoutCheck;
        this.parallelSeekEnabled = parallelSeekEnabled;
        this.preadMaxBytes = preadMaxBytes;
        this.newVersionBehavior = newVersionBehavior;
    }

    long getTableMaxRowSize() {
        return this.tableMaxRowSize;
    }

    boolean isUsePread() {
        return this.usePread;
    }

    long getCellsPerTimeoutCheck() {
        return this.cellsPerTimeoutCheck;
    }

    boolean isParallelSeekEnabled() {
        return this.parallelSeekEnabled;
    }

    public byte[] getFamily() {
        return this.family;
    }

    public int getMinVersions() {
        return this.minVersions;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public long getTtl() {
        return this.ttl;
    }

    public KeepDeletedCells getKeepDeletedCells() {
        return this.keepDeletedCells;
    }

    public long getTimeToPurgeDeletes() {
        return this.timeToPurgeDeletes;
    }

    public CellComparator getComparator() {
        return this.comparator;
    }

    long getPreadMaxBytes() {
        return this.preadMaxBytes;
    }

    public boolean isNewVersionBehavior() {
        return this.newVersionBehavior;
    }

    ScanInfo customize(int maxVersions, long ttl, KeepDeletedCells keepDeletedCells) {
        return this.customize(maxVersions, ttl, keepDeletedCells, this.minVersions, this.timeToPurgeDeletes);
    }

    ScanInfo customize(int maxVersions, long ttl, KeepDeletedCells keepDeletedCells, int minVersions, long timeToPurgeDeletes) {
        return new ScanInfo(this.family, minVersions, maxVersions, ttl, keepDeletedCells, timeToPurgeDeletes, this.comparator, this.tableMaxRowSize, this.usePread, this.cellsPerTimeoutCheck, this.parallelSeekEnabled, this.preadMaxBytes, this.newVersionBehavior);
    }

    public String toString() {
        return new ToStringBuilder(this).append("family", Bytes.toStringBinary(this.family)).append("minVersions", this.minVersions).append("maxVersions", this.maxVersions).append("ttl", this.ttl).append("keepDeletedCells", (Object)this.keepDeletedCells).append("timeToPurgeDeletes", this.timeToPurgeDeletes).append("tableMaxRowSize", this.tableMaxRowSize).append("usePread", this.usePread).append("cellsPerTimeoutCheck", this.cellsPerTimeoutCheck).append("parallelSeekEnabled", this.parallelSeekEnabled).append("preadMaxBytes", this.preadMaxBytes).append("newVersionBehavior", this.newVersionBehavior).toString();
    }
}

