/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.coordination;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.coordination.CloseRegionCoordination;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.zookeeper.ZKAssign;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZkCloseRegionCoordination
implements CloseRegionCoordination {
    private static final Log LOG = LogFactory.getLog(ZkCloseRegionCoordination.class);
    private static final int FAILED_VERSION = -1;
    private CoordinatedStateManager csm;
    private final ZooKeeperWatcher watcher;

    public ZkCloseRegionCoordination(CoordinatedStateManager csm, ZooKeeperWatcher watcher) {
        this.csm = csm;
        this.watcher = watcher;
    }

    @Override
    public boolean checkClosingState(HRegionInfo regionInfo, CloseRegionCoordination.CloseRegionDetails crd) {
        ZkCloseRegionDetails zkCrd = (ZkCloseRegionDetails)crd;
        try {
            return zkCrd.isPublishStatusInZk() && !ZKAssign.checkClosingState(this.watcher, regionInfo, ((ZkCloseRegionDetails)crd).getExpectedVersion());
        }
        catch (KeeperException ke) {
            this.csm.getServer().abort("Unrecoverable exception while checking state with zk " + regionInfo.getRegionNameAsString() + ", still finishing close", ke);
            throw new RuntimeException(ke);
        }
    }

    @Override
    public void setClosedState(HRegion region, ServerName sn, CloseRegionCoordination.CloseRegionDetails crd) {
        ZkCloseRegionDetails zkCrd = (ZkCloseRegionDetails)crd;
        String name = region.getRegionInfo().getRegionNameAsString();
        if (zkCrd.isPublishStatusInZk()) {
            if (this.setClosedState(region, sn, zkCrd)) {
                LOG.debug((Object)("Set closed state in zk for " + name + " on " + sn));
            } else {
                LOG.debug((Object)("Set closed state in zk UNSUCCESSFUL for " + name + " on " + sn));
            }
        }
    }

    @Override
    public CloseRegionCoordination.CloseRegionDetails parseFromProtoRequest(AdminProtos.CloseRegionRequest request) {
        ZkCloseRegionDetails zkCrd = new ZkCloseRegionDetails();
        zkCrd.setPublishStatusInZk(request.getTransitionInZK());
        int versionOfClosingNode = -1;
        if (request.hasVersionOfClosingNode()) {
            versionOfClosingNode = request.getVersionOfClosingNode();
        }
        zkCrd.setExpectedVersion(versionOfClosingNode);
        return zkCrd;
    }

    @Override
    public CloseRegionCoordination.CloseRegionDetails getDetaultDetails() {
        ZkCloseRegionDetails zkCrd = new ZkCloseRegionDetails();
        zkCrd.setPublishStatusInZk(false);
        zkCrd.setExpectedVersion(-1);
        return zkCrd;
    }

    private boolean setClosedState(HRegion region, ServerName sn, ZkCloseRegionDetails zkCrd) {
        int expectedVersion = zkCrd.getExpectedVersion();
        try {
            if (ZKAssign.transitionNodeClosed(this.watcher, region.getRegionInfo(), sn, expectedVersion) == -1) {
                LOG.warn((Object)"Completed the CLOSE of a region but when transitioning from  CLOSING to CLOSED got a version mismatch, someone else clashed so now unassigning");
                region.close();
                return false;
            }
        }
        catch (NullPointerException e) {
            LOG.warn((Object)"NPE during close -- catching and continuing...", (Throwable)e);
            return false;
        }
        catch (KeeperException e) {
            LOG.error((Object)"Failed transitioning node from CLOSING to CLOSED", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOG.error((Object)"Failed to close region after failing to transition", (Throwable)e);
            return false;
        }
        return true;
    }

    public static class ZkCloseRegionDetails
    implements CloseRegionCoordination.CloseRegionDetails {
        private boolean publishStatusInZk;
        private int expectedVersion = -1;

        public ZkCloseRegionDetails() {
        }

        public ZkCloseRegionDetails(boolean publishStatusInZk, int expectedVersion) {
            this.publishStatusInZk = publishStatusInZk;
            this.expectedVersion = expectedVersion;
        }

        public boolean isPublishStatusInZk() {
            return this.publishStatusInZk;
        }

        public void setPublishStatusInZk(boolean publishStatusInZk) {
            this.publishStatusInZk = publishStatusInZk;
        }

        public int getExpectedVersion() {
            return this.expectedVersion;
        }

        public void setExpectedVersion(int expectedVersion) {
            this.expectedVersion = expectedVersion;
        }
    }
}

