/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.security;

import javax.servlet.ServletContext;
import org.apache.hudi.org.apache.jetty.security.Authenticator;
import org.apache.hudi.org.apache.jetty.security.IdentityService;
import org.apache.hudi.org.apache.jetty.security.LoginService;
import org.apache.hudi.org.apache.jetty.security.authentication.BasicAuthenticator;
import org.apache.hudi.org.apache.jetty.security.authentication.ClientCertAuthenticator;
import org.apache.hudi.org.apache.jetty.security.authentication.DigestAuthenticator;
import org.apache.hudi.org.apache.jetty.security.authentication.FormAuthenticator;
import org.apache.hudi.org.apache.jetty.security.authentication.LoginAuthenticator;
import org.apache.hudi.org.apache.jetty.security.authentication.SpnegoAuthenticator;
import org.apache.hudi.org.apache.jetty.server.Server;

public class DefaultAuthenticatorFactory
implements Authenticator.Factory {
    LoginService _loginService;

    @Override
    public Authenticator getAuthenticator(Server server, ServletContext context, Authenticator.AuthConfiguration configuration, IdentityService identityService, LoginService loginService) {
        String auth = configuration.getAuthMethod();
        LoginAuthenticator authenticator = null;
        if (auth == null || "BASIC".equalsIgnoreCase(auth)) {
            authenticator = new BasicAuthenticator();
        } else if ("DIGEST".equalsIgnoreCase(auth)) {
            authenticator = new DigestAuthenticator();
        } else if ("FORM".equalsIgnoreCase(auth)) {
            authenticator = new FormAuthenticator();
        } else if ("SPNEGO".equalsIgnoreCase(auth)) {
            authenticator = new SpnegoAuthenticator();
        } else if ("NEGOTIATE".equalsIgnoreCase(auth)) {
            authenticator = new SpnegoAuthenticator("NEGOTIATE");
        }
        if ("CLIENT_CERT".equalsIgnoreCase(auth) || "CLIENT-CERT".equalsIgnoreCase(auth)) {
            authenticator = new ClientCertAuthenticator();
        }
        return authenticator;
    }

    public LoginService getLoginService() {
        return this._loginService;
    }

    public void setLoginService(LoginService loginService) {
        this._loginService = loginService;
    }
}

