/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.avro;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import org.apache.avro.Conversion;
import org.apache.avro.LogicalType;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.IndexedRecord;

abstract class ParentValueContainer {
    ParentValueContainer() {
    }

    public void add(Object value) {
        throw new RuntimeException("[BUG] ParentValueContainer#add was not overridden");
    }

    public void addBoolean(boolean value) {
        this.add(value);
    }

    public void addByte(byte value) {
        this.add(value);
    }

    public void addChar(char value) {
        this.add(Character.valueOf(value));
    }

    public void addShort(short value) {
        this.add(value);
    }

    public void addInt(int value) {
        this.add(value);
    }

    public void addLong(long value) {
        this.add(value);
    }

    public void addFloat(float value) {
        this.add(Float.valueOf(value));
    }

    public void addDouble(double value) {
        this.add(value);
    }

    static ParentValueContainer getConversionContainer(final ParentValueContainer parent, final Conversion<?> conversion, final Schema schema2) {
        if (conversion == null) {
            return parent;
        }
        final LogicalType logicalType = schema2.getLogicalType();
        switch (schema2.getType()) {
            case STRING: {
                return new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromCharSequence((CharSequence)value, schema2, logicalType));
                    }
                };
            }
            case BOOLEAN: {
                return new LogicalTypePrimitiveContainer(parent, schema2, conversion){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromBoolean((Boolean)value, schema2, logicalType));
                    }
                };
            }
            case INT: {
                return new LogicalTypePrimitiveContainer(parent, schema2, conversion){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromInt((Integer)value, schema2, logicalType));
                    }
                };
            }
            case LONG: {
                return new LogicalTypePrimitiveContainer(parent, schema2, conversion){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromLong((Long)value, schema2, logicalType));
                    }
                };
            }
            case FLOAT: {
                return new LogicalTypePrimitiveContainer(parent, schema2, conversion){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromFloat((Float)value, schema2, logicalType));
                    }
                };
            }
            case DOUBLE: {
                return new LogicalTypePrimitiveContainer(parent, schema2, conversion){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromDouble((Double)value, schema2, logicalType));
                    }
                };
            }
            case BYTES: {
                return new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromBytes((ByteBuffer)value, schema2, logicalType));
                    }
                };
            }
            case FIXED: {
                return new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromFixed((GenericFixed)((GenericData.Fixed)value), schema2, logicalType));
                    }
                };
            }
            case RECORD: {
                return new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromRecord((IndexedRecord)value, schema2, logicalType));
                    }
                };
            }
            case ARRAY: {
                return new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromArray((Collection)value, schema2, logicalType));
                    }
                };
            }
            case MAP: {
                return new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromMap((Map)value, schema2, logicalType));
                    }
                };
            }
            case ENUM: {
                return new ParentValueContainer(){

                    @Override
                    public void add(Object value) {
                        parent.add(conversion.fromEnumSymbol((GenericEnumSymbol)value, schema2, logicalType));
                    }
                };
            }
        }
        return new LogicalTypePrimitiveContainer(parent, schema2, conversion);
    }

    static class LogicalTypePrimitiveContainer
    extends ParentValueContainer {
        private final ParentValueContainer wrapped;
        private final Schema schema;
        private final LogicalType logicalType;
        private final Conversion conversion;

        public LogicalTypePrimitiveContainer(ParentValueContainer wrapped, Schema schema2, Conversion conversion) {
            this.wrapped = wrapped;
            this.schema = schema2;
            this.logicalType = schema2.getLogicalType();
            this.conversion = conversion;
        }

        @Override
        public void addDouble(double value) {
            this.wrapped.add(this.conversion.fromDouble(Double.valueOf(value), this.schema, this.logicalType));
        }

        @Override
        public void addFloat(float value) {
            this.wrapped.add(this.conversion.fromFloat(Float.valueOf(value), this.schema, this.logicalType));
        }

        @Override
        public void addLong(long value) {
            this.wrapped.add(this.conversion.fromLong(Long.valueOf(value), this.schema, this.logicalType));
        }

        @Override
        public void addInt(int value) {
            this.wrapped.add(this.conversion.fromInt(Integer.valueOf(value), this.schema, this.logicalType));
        }

        @Override
        public void addShort(short value) {
            this.wrapped.add(this.conversion.fromInt(Integer.valueOf(value), this.schema, this.logicalType));
        }

        @Override
        public void addChar(char value) {
            this.wrapped.add(this.conversion.fromInt(Integer.valueOf(value), this.schema, this.logicalType));
        }

        @Override
        public void addByte(byte value) {
            this.wrapped.add(this.conversion.fromInt(Integer.valueOf(value), this.schema, this.logicalType));
        }

        @Override
        public void addBoolean(boolean value) {
            this.wrapped.add(this.conversion.fromBoolean(Boolean.valueOf(value), this.schema, this.logicalType));
        }
    }
}

