/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SchemaUtils$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001>\u0011\u0011%\u00117uKJDun\u001c3jKR\u000b'\r\\3BI\u0012\u001cu\u000e\\;n]N\u001cu.\\7b]\u0012T!a\u0001\u0003\u0002\u000f\r|W.\\1oI*\u0011QAB\u0001\u0005QV$\u0017N\u0003\u0002\b\u0011\u0005\u00191/\u001d7\u000b\u0005%Q\u0011!B:qCJ\\'BA\u0006\r\u0003\u0019\t\u0007/Y2iK*\tQ\"A\u0002pe\u001e\u001c\u0001aE\u0003\u0001!i\ts\u0005\u0005\u0002\u001215\t!C\u0003\u0002\u0014)\u00059An\\4jG\u0006d'BA\u000b\u0017\u0003\u0015\u0001H.\u00198t\u0015\t9b!\u0001\u0005dCR\fG._:u\u0013\tI\"CA\u0006M_\u001eL7-\u00197QY\u0006t\u0007CA\u000e \u001b\u0005a\"BA\u0002\u001e\u0015\tqb!A\u0005fq\u0016\u001cW\u000f^5p]&\u0011\u0001\u0005\b\u0002\u0010%Vtg.\u00192mK\u000e{W.\\1oIB\u0011!%J\u0007\u0002G)\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\t9\u0001K]8ek\u000e$\bC\u0001\u0012)\u0013\tI3E\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005,\u0001\tU\r\u0011\"\u0001-\u0003\u001d!\u0018M\u00197f\u0013\u0012,\u0012!\f\t\u0003]=j\u0011AF\u0005\u0003aY\u0011q\u0002V1cY\u0016LE-\u001a8uS\u001aLWM\u001d\u0005\te\u0001\u0011\t\u0012)A\u0005[\u0005AA/\u00192mK&#\u0007\u0005\u0003\u00055\u0001\tU\r\u0011\"\u00016\u0003%\u0019w\u000e\\:U_\u0006#G-F\u00017!\r9tH\u0011\b\u0003qur!!\u000f\u001f\u000e\u0003iR!a\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0013B\u0001 $\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Q!\u0003\u0007M+\u0017O\u0003\u0002?GA\u00111IR\u0007\u0002\t*\u0011QIB\u0001\u0006if\u0004Xm]\u0005\u0003\u000f\u0012\u00131b\u0015;sk\u000e$h)[3mI\"A\u0011\n\u0001B\tB\u0003%a'\u0001\u0006d_2\u001cHk\\!eI\u0002BQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtDcA'P!B\u0011a\nA\u0007\u0002\u0005!)1F\u0013a\u0001[!)AG\u0013a\u0001m!)!\u000b\u0001C!'\u0006\u0019!/\u001e8\u0015\u0005QK\u0006cA\u001c@+B\u0011akV\u0007\u0002\r%\u0011\u0001L\u0002\u0002\u0004%><\b\"\u0002.R\u0001\u0004Y\u0016\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001,]\u0013\tifA\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003`\u0001\u0011%\u0001-A\nsK\u001a\u0014Xm\u001d5TG\",W.Y%o\u001b\u0016$\u0018\r\u0006\u0003bI\u0016l\u0007C\u0001\u0012c\u0013\t\u00197E\u0001\u0003V]&$\b\"\u0002._\u0001\u0004Y\u0006\"\u00024_\u0001\u00049\u0017!\u0002;bE2,\u0007C\u00015l\u001b\u0005I'B\u00016\u0017\u0003\u001d\u0019\u0017\r^1m_\u001eL!\u0001\\5\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\t\u000b9t\u0006\u0019A8\u0002\u00199,woU9m'\u000eDW-\\1\u0011\u0005\r\u0003\u0018BA9E\u0005)\u0019FO];diRK\b/\u001a\u0005\bg\u0002\t\t\u0011\"\u0001u\u0003\u0011\u0019w\u000e]=\u0015\u00075+h\u000fC\u0004,eB\u0005\t\u0019A\u0017\t\u000fQ\u0012\b\u0013!a\u0001m!9\u0001\u0010AI\u0001\n\u0003I\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0002u*\u0012Qf_\u0016\u0002yB\u0019Q0!\u0002\u000e\u0003yT1a`A\u0001\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004\r\n!\"\u00198o_R\fG/[8o\u0013\r\t9A \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u0006\u0001E\u0005I\u0011AA\u0007\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a\u0004+\u0005YZ\b\"CA\n\u0001\u0005\u0005I\u0011IA\u000b\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011q\u0003\t\u0005\u00033\t\u0019#\u0004\u0002\u0002\u001c)!\u0011QDA\u0010\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u0005\u0012\u0001\u00026bm\u0006LA!!\n\u0002\u001c\t11\u000b\u001e:j]\u001eD\u0011\"!\u000b\u0001\u0003\u0003%\t!a\u000b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0002c\u0001\u0012\u00020%\u0019\u0011\u0011G\u0012\u0003\u0007%sG\u000fC\u0005\u00026\u0001\t\t\u0011\"\u0001\u00028\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u001d\u0003\u007f\u00012AIA\u001e\u0013\r\tid\t\u0002\u0004\u0003:L\bBCA!\u0003g\t\t\u00111\u0001\u0002.\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005\u0015\u0003!!A\u0005B\u0005\u001d\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005%\u0003CBA&\u0003#\nI$\u0004\u0002\u0002N)\u0019\u0011qJ\u0012\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002T\u00055#\u0001C%uKJ\fGo\u001c:\t\u0013\u0005]\u0003!!A\u0005\u0002\u0005e\u0013\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005m\u0013\u0011\r\t\u0004E\u0005u\u0013bAA0G\t9!i\\8mK\u0006t\u0007BCA!\u0003+\n\t\u00111\u0001\u0002:!I\u0011Q\r\u0001\u0002\u0002\u0013\u0005\u0013qM\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005m\u0013\u0011\u000e\u0005\u000b\u0003\u0003\n\u0019'!AA\u0002\u0005eraBA7\u0005!\u0005\u0011qN\u0001\"\u00032$XM\u001d%p_\u0012LW\rV1cY\u0016\fE\rZ\"pYVlgn]\"p[6\fg\u000e\u001a\t\u0004\u001d\u0006EdAB\u0001\u0003\u0011\u0003\t\u0019hE\u0003\u0002r\u0005Ut\u0005E\u0002#\u0003oJ1!!\u001f$\u0005\u0019\te.\u001f*fM\"91*!\u001d\u0005\u0002\u0005uDCAA8\u0011!\t\t)!\u001d\u0005\u0002\u0005\r\u0015\u0001E2p[6LGoV5uQN\u001b\u0007.Z7b)\u001d\t\u0017QQAK\u0003?C\u0001\"a\"\u0002\u0000\u0001\u0007\u0011\u0011R\u0001\u0007g\u000eDW-\\1\u0011\t\u0005-\u0015\u0011S\u0007\u0003\u0003\u001bS1!a$\u000b\u0003\u0011\tgO]8\n\t\u0005M\u0015Q\u0012\u0002\u0007'\u000eDW-\\1\t\u0011\u0005]\u0015q\u0010a\u0001\u00033\u000b!\u0003[8pI&,7)\u0019;bY><G+\u00192mKB\u0019\u0001.a'\n\u0007\u0005u\u0015N\u0001\nI_>$\u0017.Z\"bi\u0006dwn\u001a+bE2,\u0007B\u0002.\u0002\u0000\u0001\u00071\f\u0003\u0006\u0002$\u0006E\u0014\u0011!CA\u0003K\u000bQ!\u00199qYf$R!TAT\u0003SCaaKAQ\u0001\u0004i\u0003B\u0002\u001b\u0002\"\u0002\u0007a\u0007\u0003\u0006\u0002.\u0006E\u0014\u0011!CA\u0003_\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u00022\u0006u\u0006#\u0002\u0012\u00024\u0006]\u0016bAA[G\t1q\n\u001d;j_:\u0004RAIA][YJ1!a/$\u0005\u0019!V\u000f\u001d7fe!I\u0011qXAV\u0003\u0003\u0005\r!T\u0001\u0004q\u0012\u0002\u0004BCAb\u0003c\n\t\u0011\"\u0003\u0002F\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t9\r\u0005\u0003\u0002\u001a\u0005%\u0017\u0002BAf\u00037\u0011aa\u00142kK\u000e$\b")
public class AlterHoodieTableAddColumnsCommand
extends LogicalPlan
implements RunnableCommand,
Serializable {
    private final TableIdentifier tableId;
    private final Seq<StructField> colsToAdd;
    private final Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand) {
        return AlterHoodieTableAddColumnsCommand$.MODULE$.unapply(alterHoodieTableAddColumnsCommand);
    }

    public static void commitWithSchema(Schema schema2, HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(schema2, hoodieCatalogTable, sparkSession);
    }

    private Map metrics$lzycompute() {
        AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand = this;
        synchronized (alterHoodieTableAddColumnsCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.class.metrics((RunnableCommand)this);
                this.bitmap$0 = true;
            }
            return this.metrics;
        }
    }

    public Map<String, SQLMetric> metrics() {
        return this.bitmap$0 ? this.metrics : this.metrics$lzycompute();
    }

    public Seq<Attribute> output() {
        return Command.class.output((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.class.children((Command)this);
    }

    public TableIdentifier tableId() {
        return this.tableId;
    }

    public Seq<StructField> colsToAdd() {
        return this.colsToAdd;
    }

    public Seq<Row> run(SparkSession sparkSession) {
        if (this.colsToAdd().nonEmpty()) {
            Function2 resolver = sparkSession.sessionState().conf().resolver();
            HoodieCatalogTable hoodieCatalogTable = HoodieCatalogTable$.MODULE$.apply(sparkSession, this.tableId());
            StructType tableSchema2 = hoodieCatalogTable.tableSchema();
            Seq existsColumns = (Seq)((TraversableLike)this.colsToAdd().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(StructField x$1) {
                    return x$1.name();
                }
            }, Seq$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this, resolver, tableSchema2){
                public static final long serialVersionUID = 0L;
                public final Function2 resolver$1;
                private final StructType tableSchema$1;

                public final boolean apply(String col) {
                    return Predef$.MODULE$.refArrayOps((Object[])this.tableSchema$1.fieldNames()).exists((Function1)new Serializable(this, col){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$2 $outer;
                        private final String col$1;

                        public final boolean apply(String f) {
                            return BoxesRunTime.unboxToBoolean((Object)this.$outer.resolver$1.apply((Object)f, (Object)this.col$1));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.col$1 = col$1;
                        }
                    });
                }
                {
                    this.resolver$1 = resolver$1;
                    this.tableSchema$1 = tableSchema$1;
                }
            });
            if (existsColumns.nonEmpty()) {
                throw new AnalysisException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Columns: [", "] already exists in the table,"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{existsColumns.mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" table columns is: [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.tableSchemaWithoutMetaFields().fieldNames()).mkString(",")}))).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            StructType newSqlSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])tableSchema2.fields()).$plus$plus(this.colsToAdd(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
            Tuple2<String, String> tuple2 = AvroConversionUtils$.MODULE$.getAvroRecordNameAndNamespace(this.tableId().table());
            if (tuple2 != null) {
                Tuple2 tuple22;
                String structName = (String)tuple2._1();
                String nameSpace = (String)tuple2._2();
                Tuple2 tuple23 = tuple22 = new Tuple2((Object)structName, (Object)nameSpace);
                String structName2 = (String)tuple23._1();
                String nameSpace2 = (String)tuple23._2();
                Schema newSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema(newSqlSchema, structName2, nameSpace2);
                AlterHoodieTableAddColumnsCommand$.MODULE$.commitWithSchema(newSchema, hoodieCatalogTable, sparkSession);
                StructType newDataSchema = new StructType((StructField[])Predef$.MODULE$.refArrayOps((Object[])hoodieCatalogTable.dataSchema().fields()).$plus$plus(this.colsToAdd(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
                this.refreshSchemaInMeta(sparkSession, hoodieCatalogTable.table(), newDataSchema);
            } else {
                throw new MatchError(tuple2);
            }
        }
        return (Seq)Seq$.MODULE$.empty();
    }

    private void refreshSchemaInMeta(SparkSession sparkSession, CatalogTable table, StructType newSqlSchema) {
        try {
            sparkSession.catalog().uncacheTable(this.tableId().quotedString());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log().warn(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exception when attempting to uncache table ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.tableId().quotedString()})), e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        sparkSession.catalog().refreshTable(table.identifier().unquotedString());
        SchemaUtils$.MODULE$.checkColumnNameDuplication((Seq)newSqlSchema.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$3) {
                return x$3.name();
            }
        }, Seq$.MODULE$.canBuildFrom()), new StringBuilder().append((Object)"in the table definition of ").append((Object)table.identifier()).toString(), this.conf().caseSensitiveAnalysis());
        DDLUtils$.MODULE$.checkDataColNames(table, (Seq)this.colsToAdd().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(StructField x$4) {
                return x$4.name();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        sparkSession.sessionState().catalog().alterTableDataSchema(this.tableId(), newSqlSchema);
    }

    public AlterHoodieTableAddColumnsCommand copy(TableIdentifier tableId, Seq<StructField> colsToAdd) {
        return new AlterHoodieTableAddColumnsCommand(tableId, colsToAdd);
    }

    public TableIdentifier copy$default$1() {
        return this.tableId();
    }

    public Seq<StructField> copy$default$2() {
        return this.colsToAdd();
    }

    public String productPrefix() {
        return "AlterHoodieTableAddColumnsCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        TableIdentifier tableIdentifier;
        int n = x$1;
        switch (n) {
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
            case 1: {
                tableIdentifier = this.colsToAdd();
                break;
            }
            case 0: {
                tableIdentifier = this.tableId();
            }
        }
        return tableIdentifier;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AlterHoodieTableAddColumnsCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AlterHoodieTableAddColumnsCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AlterHoodieTableAddColumnsCommand alterHoodieTableAddColumnsCommand = (AlterHoodieTableAddColumnsCommand)((Object)x$1);
        TableIdentifier tableIdentifier = this.tableId();
        TableIdentifier tableIdentifier2 = alterHoodieTableAddColumnsCommand.tableId();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<StructField> seq = this.colsToAdd();
        Seq<StructField> seq2 = alterHoodieTableAddColumnsCommand.colsToAdd();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!alterHoodieTableAddColumnsCommand.canEqual((Object)this)) return false;
        return true;
    }

    public AlterHoodieTableAddColumnsCommand(TableIdentifier tableId, Seq<StructField> colsToAdd) {
        this.tableId = tableId;
        this.colsToAdd = colsToAdd;
        Command.class.$init$((Command)this);
        RunnableCommand.class.$init$((RunnableCommand)this);
    }
}

