/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a8\u0006\t"}, d2={"Lio/javalin/core/util/FileUtil;", "", "()V", "streamToFile", "", "inputStream", "Ljava/io/InputStream;", "path", "", "javalin"})
public final class FileUtil {
    public static final FileUtil INSTANCE;

    @JvmStatic
    public static final void streamToFile(@NotNull InputStream inputStream, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull(inputStream, "inputStream");
        Intrinsics.checkParameterIsNotNull(path, "path");
        File newFile = new File(path);
        newFile.getParentFile().mkdirs();
        newFile.createNewFile();
        Files.copy(inputStream, newFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    private FileUtil() {
    }

    static {
        FileUtil fileUtil;
        INSTANCE = fileUtil = new FileUtil();
    }
}

