/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.ColumnStatsIndexSupport;
import org.apache.hudi.ColumnStatsIndexSupport$;
import org.apache.hudi.ColumnStatsIndexSupport$$anonfun$15$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.hash.ColumnIndexID;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.spark.api.java.JavaRDD$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieUnsafeRDDUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.TreeSet;
import scala.collection.immutable.TreeSet$;
import scala.collection.mutable.WrappedArray;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class ColumnStatsIndexSupport$class {
    public static Dataset readColumnStatsIndex(ColumnStatsIndexSupport $this, SparkSession spark, String tableBasePath, HoodieMetadataConfig metadataConfig, Seq targetColumns) {
        Seq targetColStatsIndexColumns = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"fileName", "minValue", "maxValue", "nullCount", "valueCount"}));
        Seq requiredMetadataIndexColumns = (Seq)((TraversableLike)targetColStatsIndexColumns.$colon$plus((Object)"columnName", Seq$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String colName) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ColumnStatsMetadata", colName}));
            }
        }, Seq$.MODULE$.canBuildFrom());
        Dataset metadataTableDF = targetColumns.nonEmpty() ? ColumnStatsIndexSupport$class.readColumnStatsIndexForColumnsInternal($this, spark, targetColumns, metadataConfig, tableBasePath) : ColumnStatsIndexSupport$class.readFullColumnStatsIndexInternal($this, spark, metadataConfig, tableBasePath);
        Dataset colStatsDF = metadataTableDF.where(functions$.MODULE$.col("ColumnStatsMetadata").isNotNull()).select((Seq)requiredMetadataIndexColumns.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Column apply(String colName) {
                return functions$.MODULE$.col(colName);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        return colStatsDF;
    }

    public static Seq readColumnStatsIndex$default$4(ColumnStatsIndexSupport $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static Dataset transposeColumnStatsIndex(ColumnStatsIndexSupport $this, SparkSession spark, Dataset colStatsDF, Seq queryColumns, StructType tableSchema) {
        StructType colStatsSchema = colStatsDF.schema();
        scala.collection.immutable.Map colStatsSchemaOrdinalsMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])colStatsSchema.fields()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<StructField, Object> x0$1) {
                Tuple2<StructField, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int ordinal = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)field.name(), (Object)BoxesRunTime.boxToInteger((int)ordinal));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Map tableSchemaFieldMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])tableSchema.fields()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, StructField> apply(StructField f) {
                return new Tuple2((Object)f.name(), (Object)f);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        int colNameOrdinal = BoxesRunTime.unboxToInt((Object)colStatsSchemaOrdinalsMap.apply((Object)"columnName"));
        int minValueOrdinal = BoxesRunTime.unboxToInt((Object)colStatsSchemaOrdinalsMap.apply((Object)"minValue"));
        int maxValueOrdinal = BoxesRunTime.unboxToInt((Object)colStatsSchemaOrdinalsMap.apply((Object)"maxValue"));
        int fileNameOrdinal = BoxesRunTime.unboxToInt((Object)colStatsSchemaOrdinalsMap.apply((Object)"fileName"));
        int nullCountOrdinal = BoxesRunTime.unboxToInt((Object)colStatsSchemaOrdinalsMap.apply((Object)"nullCount"));
        int valueCountOrdinal = BoxesRunTime.unboxToInt((Object)colStatsSchemaOrdinalsMap.apply((Object)"valueCount"));
        WrappedArray indexedColumns = Predef$.MODULE$.wrapRefArray((Object[])colStatsDF.rdd().map((Function1)new Serializable($this, colNameOrdinal){
            public static final long serialVersionUID = 0L;
            private final int colNameOrdinal$1;

            public final String apply(Row row) {
                return row.getString(this.colNameOrdinal$1);
            }
            {
                this.colNameOrdinal$1 = colNameOrdinal$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)).distinct().collect());
        TreeSet sortedTargetColumns = (TreeSet)TreeSet$.MODULE$.apply((Seq)queryColumns.intersect((GenSeq)indexedColumns), (Ordering)Ordering.String$.MODULE$);
        RDD transposedRDD = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(colStatsDF.rdd().filter((Function1)new Serializable($this, colNameOrdinal, sortedTargetColumns){
            public static final long serialVersionUID = 0L;
            private final int colNameOrdinal$1;
            private final TreeSet sortedTargetColumns$1;

            public final boolean apply(Row row) {
                return this.sortedTargetColumns$1.contains((Object)row.getString(this.colNameOrdinal$1));
            }
            {
                this.colNameOrdinal$1 = colNameOrdinal$1;
                this.sortedTargetColumns$1 = sortedTargetColumns$1;
            }
        }).map((Function1)new Serializable($this, tableSchemaFieldMap, colNameOrdinal, minValueOrdinal, maxValueOrdinal){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Map tableSchemaFieldMap$1;
            private final int colNameOrdinal$1;
            private final int minValueOrdinal$1;
            private final int maxValueOrdinal$1;

            public final Row apply(Row row) {
                Tuple2<Object, Object> tuple2;
                block4: {
                    Tuple2<Object, Object> tuple22;
                    block5: {
                        Row row2;
                        block3: {
                            Object maxValue;
                            Object object;
                            Object minValue;
                            Object object2;
                            block2: {
                                if (!row.isNullAt(this.minValueOrdinal$1) || !row.isNullAt(this.maxValueOrdinal$1)) break block2;
                                row2 = row;
                                break block3;
                            }
                            Row minValueStruct = (Row)row.getAs(this.minValueOrdinal$1);
                            Row maxValueStruct = (Row)row.getAs(this.maxValueOrdinal$1);
                            ValidationUtils.checkState(minValueStruct != null && maxValueStruct != null, "Invalid Column Stats record: either both min/max have to be null, or both have to be non-null");
                            String colName = row.getString(this.colNameOrdinal$1);
                            DataType colType = ((StructField)this.tableSchemaFieldMap$1.apply((Object)colName)).dataType();
                            tuple2 = ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$tryUnpackNonNullVal(minValueStruct);
                            if (tuple2 == null) break block4;
                            Object minValue2 = object2 = (minValue = tuple2._1());
                            tuple22 = ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$tryUnpackNonNullVal(maxValueStruct);
                            if (tuple22 == null) break block5;
                            Object maxValue2 = object = (maxValue = tuple22._1());
                            Object[] rowValsSeq = (Object[])row.toSeq().toArray(ClassTag$.MODULE$.Any());
                            rowValsSeq[this.minValueOrdinal$1] = ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$deserialize(minValue2, colType);
                            rowValsSeq[this.maxValueOrdinal$1] = ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$deserialize(maxValue2, colType);
                            row2 = Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)rowValsSeq));
                        }
                        return row2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                this.tableSchemaFieldMap$1 = tableSchemaFieldMap$1;
                this.colNameOrdinal$1 = colNameOrdinal$1;
                this.minValueOrdinal$1 = minValueOrdinal$1;
                this.maxValueOrdinal$1 = maxValueOrdinal$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class)).groupBy((Function1)new Serializable($this, fileNameOrdinal){
            public static final long serialVersionUID = 0L;
            private final int fileNameOrdinal$1;

            public final String apply(Row r) {
                return r.getString(this.fileNameOrdinal$1);
            }
            {
                this.fileNameOrdinal$1 = fileNameOrdinal$1;
            }
        }, ClassTag$.MODULE$.apply(String.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).foldByKey((Object)Seq$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2)new Serializable($this, colNameOrdinal, minValueOrdinal, maxValueOrdinal, fileNameOrdinal, nullCountOrdinal, valueCountOrdinal, sortedTargetColumns){
            public static final long serialVersionUID = 0L;
            public final int colNameOrdinal$1;
            public final int minValueOrdinal$1;
            public final int maxValueOrdinal$1;
            private final int fileNameOrdinal$1;
            public final int nullCountOrdinal$1;
            private final int valueCountOrdinal$1;
            private final TreeSet sortedTargetColumns$1;

            public final Iterable<Row> apply(Iterable<Row> x0$2, Iterable<Row> x1$1) {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 != null) {
                    Iterable columnRowsSeq = (Iterable)tuple2._2();
                    Object fileName = ((Row)columnRowsSeq.head()).get(this.fileNameOrdinal$1);
                    Object valueCount = ((Row)columnRowsSeq.head()).get(this.valueCountOrdinal$1);
                    scala.collection.immutable.Map columnRowsMap = ((TraversableOnce)columnRowsSeq.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ColumnStatsIndexSupport$.anonfun.9 $outer;

                        public final Tuple2<String, Row> apply(Row row) {
                            return new Tuple2((Object)row.getString(this.$outer.colNameOrdinal$1), (Object)row);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Seq alignedColumnRowsSeq = (Seq)this.sortedTargetColumns$1.toSeq().map((Function1)new Serializable(this, columnRowsMap){
                        public static final long serialVersionUID = 0L;
                        private final scala.collection.immutable.Map columnRowsMap$1;

                        public final Option<Row> apply(String key) {
                            return this.columnRowsMap$1.get((Object)key);
                        }
                        {
                            this.columnRowsMap$1 = columnRowsMap$1;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq coalescedRowValuesSeq = (Seq)alignedColumnRowsSeq.foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fileName, valueCount})), (Function2)new Serializable(this, valueCount){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ ColumnStatsIndexSupport$.anonfun.9 $outer;
                        private final Object valueCount$1;

                        public final Seq<Object> apply(Seq<Object> x0$3, Option<Row> x1$2) {
                            Tuple2 tuple2;
                            block2: {
                                Option option;
                                block5: {
                                    Seq seq;
                                    block4: {
                                        Seq acc;
                                        block3: {
                                            tuple2 = new Tuple2(x0$3, x1$2);
                                            if (tuple2 == null) break block2;
                                            acc = (Seq)tuple2._1();
                                            Option opt = (Option)tuple2._2();
                                            option = opt;
                                            if (!(option instanceof Some)) break block3;
                                            Some some = (Some)option;
                                            Row columnStatsRow = (Row)some.x();
                                            seq = (Seq)acc.$plus$plus((GenTraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{this.$outer.minValueOrdinal$1, this.$outer.maxValueOrdinal$1, this.$outer.nullCountOrdinal$1}))).map((Function1)new Serializable(this, columnStatsRow){
                                                public static final long serialVersionUID = 0L;
                                                private final Row columnStatsRow$1;

                                                public final Object apply(int ord) {
                                                    return this.columnStatsRow$1.get(ord);
                                                }
                                                {
                                                    this.columnStatsRow$1 = columnStatsRow$1;
                                                }
                                            }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
                                            break block4;
                                        }
                                        if (!None$.MODULE$.equals(option)) break block5;
                                        seq = (Seq)acc.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{null, null, this.valueCount$1})), Seq$.MODULE$.canBuildFrom());
                                    }
                                    Seq seq2 = seq;
                                    return seq2;
                                }
                                throw new MatchError((Object)option);
                            }
                            throw new MatchError((Object)tuple2);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.valueCount$1 = valueCount$1;
                        }
                    });
                    Iterable iterable = (Iterable)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.apply(coalescedRowValuesSeq)}));
                    return iterable;
                }
                throw new MatchError((Object)tuple2);
            }
            {
                this.colNameOrdinal$1 = colNameOrdinal$1;
                this.minValueOrdinal$1 = minValueOrdinal$1;
                this.maxValueOrdinal$1 = maxValueOrdinal$1;
                this.fileNameOrdinal$1 = fileNameOrdinal$1;
                this.nullCountOrdinal$1 = nullCountOrdinal$1;
                this.valueCountOrdinal$1 = valueCountOrdinal$1;
                this.sortedTargetColumns$1 = sortedTargetColumns$1;
            }
        }), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(Iterable.class), (Ordering)Ordering.String$.MODULE$).values().flatMap((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Row> apply(Iterable<Row> it) {
                return it;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
        StructType indexSchema = ColumnStatsIndexSupport$.MODULE$.composeIndexSchema((Seq<String>)sortedTargetColumns.toSeq(), tableSchema);
        return spark.createDataFrame(transposedRDD, indexSchema);
    }

    private static Dataset readFullColumnStatsIndexInternal(ColumnStatsIndexSupport $this, SparkSession spark, HoodieMetadataConfig metadataConfig, String tableBasePath) {
        String metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath(tableBasePath);
        return spark.read().format("org.apache.hudi").options((Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter((Properties)metadataConfig.getProps()).asScala()).load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metadataTablePath, MetadataPartitionType.COLUMN_STATS.getPartitionPath()})));
    }

    private static Dataset readColumnStatsIndexForColumnsInternal(ColumnStatsIndexSupport $this, SparkSession spark, Seq targetColumns, HoodieMetadataConfig metadataConfig, String tableBasePath) {
        HoodieSparkEngineContext ctx = new HoodieSparkEngineContext(new JavaSparkContext(spark.sparkContext()));
        HoodieTableMetadata metadataTable = HoodieTableMetadata.create(ctx, metadataConfig, tableBasePath, FileSystemViewStorageConfig.SPILLABLE_DIR.defaultValue());
        Seq encodedTargetColumnNames = (Seq)targetColumns.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String colName) {
                return new ColumnIndexID(colName).asBase64EncodedString();
            }
        }, Seq$.MODULE$.canBuildFrom());
        RDD recordsRDD = JavaRDD$.MODULE$.toRDD(HoodieJavaRDD.getJavaRDD(metadataTable.getRecordsByKeyPrefixes((List)JavaConverters$.MODULE$.seqAsJavaListConverter(encodedTargetColumnNames).asJava(), "column_stats")));
        RDD catalystRowsRDD = recordsRDD.mapPartitions((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Iterator<InternalRow> apply(Iterator<HoodieRecord<HoodieMetadataPayload>> it) {
                Schema metadataRecordSchema = new Schema.Parser().parse(ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$metadataRecordSchemaString());
                Function1<GenericRecord, Option<InternalRow>> converter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(metadataRecordSchema, ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$metadataRecordStructType());
                return it.map((Function1)new Serializable(this, converter){
                    public static final long serialVersionUID = 0L;
                    public final Function1 converter$1;

                    public final InternalRow apply(HoodieRecord<HoodieMetadataPayload> record) {
                        return (InternalRow)HoodieConversionUtils$.MODULE$.toScalaOption(record.getData().getInsertValue(null, null)).flatMap((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ ColumnStatsIndexSupport$$anonfun$15$.anonfun.apply.2 $outer;

                            public final Option<InternalRow> apply(IndexedRecord avroRecord) {
                                return (Option)this.$outer.converter$1.apply((Object)((GenericRecord)avroRecord));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }).orNull(Predef$.MODULE$.$conforms());
                    }
                    {
                        this.converter$1 = converter$1;
                    }
                });
            }
        }, recordsRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        Dataset<Row> metadataTableDF = HoodieUnsafeRDDUtils$.MODULE$.createDataFrame(spark, (RDD<InternalRow>)catalystRowsRDD, ColumnStatsIndexSupport$.MODULE$.org$apache$hudi$ColumnStatsIndexSupport$$metadataRecordStructType());
        return metadataTableDF;
    }

    public static void $init$(ColumnStatsIndexSupport $this) {
    }
}

