/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecificInternalRow;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Try$;

public final class HoodieMergeOnReadRDD$
implements Serializable {
    public static final HoodieMergeOnReadRDD$ MODULE$;
    private final Object CONFIG_INSTANTIATION_LOCK;

    static {
        new HoodieMergeOnReadRDD$();
    }

    public Object CONFIG_INSTANTIATION_LOCK() {
        return this.CONFIG_INSTANTIATION_LOCK;
    }

    public HoodieMergedLogRecordScanner scanLog(List<HoodieLogFile> logFiles, Path partitionPath, Schema logSchema, HoodieTableState tableState, long maxCompactionMemoryInBytes, Configuration hadoopConf, InternalSchema internalSchema) {
        HoodieMergedLogRecordScanner hoodieMergedLogRecordScanner;
        String tablePath = tableState.tablePath();
        FileSystem fs = FSUtils.getFs(tablePath, hadoopConf);
        if (HoodieTableMetadata.isMetadataTable(tablePath)) {
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(tableState.metadataConfig().getProps()).enable(true).build();
            String dataTableBasePath = HoodieTableMetadata.getDataTableBasePathFromMetadataTable(tablePath);
            HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata(new HoodieLocalEngineContext(hadoopConf), metadataConfig, dataTableBasePath, hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/"));
            boolean forceFullScan = true;
            String relativePartitionPath = FSUtils.getRelativePartitionPath(new Path(tablePath), partitionPath);
            hoodieMergedLogRecordScanner = metadataTable.getLogRecordScanner((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(logFiles).asJava(), relativePartitionPath, HoodieConversionUtils$.MODULE$.toJavaOption(new Some((Object)Predef$.MODULE$.boolean2Boolean(forceFullScan)))).getLeft();
        } else {
            HoodieMergedLogRecordScanner.Builder logRecordScannerBuilder = ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(tablePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFiles.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(HoodieLogFile logFile) {
                    return logFile.getPath().toString();
                }
            }, List$.MODULE$.canBuildFrom())).asJava())).withReaderSchema(logSchema).withLatestInstantTime(tableState.latestCommitTimestamp()).withReadBlocksLazily(BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return new StringOps(Predef$.MODULE$.augmentString(this.hadoopConf$1.get("compaction.lazy.block.read.enabled", "true"))).toBoolean();
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }))).withReverseReader(false).withInternalSchema(internalSchema).withBufferSize(hadoopConf.getInt("hoodie.memory.dfs.buffer.max.size", 0x100000)).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(maxCompactionMemoryInBytes)).withSpillableMapBasePath(hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/"));
            Object object = logFiles.nonEmpty() ? logRecordScannerBuilder.withPartition(FSUtils.getRelativePartitionPath(new Path(tableState.tablePath()), ((HoodieLogFile)logFiles.head()).getPath().getParent())) : BoxedUnit.UNIT;
            hoodieMergedLogRecordScanner = logRecordScannerBuilder.build();
        }
        return hoodieMergedLogRecordScanner;
    }

    public InternalSchema scanLog$default$7() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public InternalRow org$apache$hudi$HoodieMergeOnReadRDD$$projectRowUnsafe(InternalRow row, StructType projectedSchema, Seq<Object> ordinals) {
        SpecificInternalRow projectedRow = new SpecificInternalRow(projectedSchema);
        IntRef curIndex = IntRef.create((int)0);
        ((IterableLike)projectedSchema.zip(ordinals, Seq$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(row, projectedRow, curIndex){
            public static final long serialVersionUID = 0L;
            private final InternalRow row$1;
            private final SpecificInternalRow projectedRow$1;
            private final IntRef curIndex$1;

            public final void apply(Tuple2<StructField, Object> x0$2) {
                Tuple2<StructField, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int pos = tuple2._2$mcI$sp();
                    Object curField = this.row$1.isNullAt(pos) ? null : this.row$1.get(pos, field.dataType());
                    this.projectedRow$1.update(this.curIndex$1.elem, curField);
                    ++this.curIndex$1.elem;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.row$1 = row$1;
                this.projectedRow$1 = projectedRow$1;
                this.curIndex$1 = curIndex$1;
            }
        });
        return projectedRow;
    }

    public GenericRecord projectAvroUnsafe(IndexedRecord record, Schema projectedSchema, List<Object> ordinals, GenericRecordBuilder recordBuilder) {
        Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(projectedSchema.getFields()).asScala();
        ValidationUtils.checkState(fields.length() == ordinals.length());
        ((IterableLike)fields.zip(ordinals, Buffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(record, recordBuilder){
            public static final long serialVersionUID = 0L;
            private final IndexedRecord record$1;
            private final GenericRecordBuilder recordBuilder$1;

            public final GenericRecordBuilder apply(Tuple2<Schema.Field, Object> x0$3) {
                Tuple2<Schema.Field, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    Schema.Field field = (Schema.Field)tuple2._1();
                    int pos = tuple2._2$mcI$sp();
                    GenericRecordBuilder genericRecordBuilder = this.recordBuilder$1.set(field, this.record$1.get(pos));
                    return genericRecordBuilder;
                }
                throw new MatchError(tuple2);
            }
            {
                this.record$1 = record$1;
                this.recordBuilder$1 = recordBuilder$1;
            }
        });
        return recordBuilder.build();
    }

    public GenericRecord projectAvro(IndexedRecord record, Schema projectedSchema, GenericRecordBuilder recordBuilder) {
        return this.projectAvroUnsafe(record, projectedSchema, this.org$apache$hudi$HoodieMergeOnReadRDD$$collectFieldOrdinals(projectedSchema, record.getSchema()), recordBuilder);
    }

    public List<Object> org$apache$hudi$HoodieMergeOnReadRDD$$collectFieldOrdinals(Schema projected, Schema source) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(projected.getFields()).asScala()).map((Function1)new Serializable(source){
            public static final long serialVersionUID = 0L;
            private final Schema source$1;

            public final int apply(Schema.Field f) {
                return this.source$1.getField(f.name()).pos();
            }
            {
                this.source$1 = source$1;
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
    }

    public Path org$apache$hudi$HoodieMergeOnReadRDD$$getPartitionPath(HoodieMergeOnReadFileSplit split) {
        return ((Path)split.dataFile().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(PartitionedFile baseFile) {
                return new Path(baseFile.filePath());
            }
        }).getOrElse((Function0)new Serializable(split){
            public static final long serialVersionUID = 0L;
            private final HoodieMergeOnReadFileSplit split$1;

            public final Path apply() {
                return ((HoodieLogFile)this.split$1.logFiles().head()).getPath();
            }
            {
                this.split$1 = split$1;
            }
        })).getParent();
    }

    public boolean org$apache$hudi$HoodieMergeOnReadRDD$$resolveAvroSchemaNullability(Schema schema2) {
        Tuple2<Object, Schema> tuple2 = AvroConversionUtils$.MODULE$.resolveAvroTypeNullability(schema2);
        if (tuple2 != null) {
            boolean nullable;
            boolean bl = nullable = tuple2._1$mcZ$sp();
            return bl;
        }
        throw new MatchError(tuple2);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HoodieMergeOnReadRDD$() {
        MODULE$ = this;
        this.CONFIG_INSTANTIATION_LOCK = new Object();
    }
}

