/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.SparkAdapterSupport$class;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.CustomAvroKeyGenerator;
import org.apache.hudi.keygen.CustomKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.factory.HoodieSparkKeyGeneratorFactory;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.And$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualNullSafe;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class HoodieSparkUtils$
implements SparkAdapterSupport {
    public static final HoodieSparkUtils$ MODULE$;
    private final SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new HoodieSparkUtils$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieSparkUtils$ hoodieSparkUtils$ = this;
        synchronized (hoodieSparkUtils$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport$class.sparkAdapter(this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    @Override
    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    public boolean isSpark2() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("2.");
    }

    public boolean isSpark3() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.");
    }

    public boolean isSpark3_0() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.0");
    }

    public boolean isSpark3_1() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.1");
    }

    public boolean gteqSpark3_1() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater((Object)"3.1");
    }

    public boolean gteqSpark3_1_3() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater$eq((Object)"3.1.3");
    }

    public boolean isSpark3_2() {
        return org.apache.spark.package$.MODULE$.SPARK_VERSION().startsWith("3.2");
    }

    public boolean gteqSpark3_2() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater((Object)"3.2");
    }

    public boolean gteqSpark3_2_1() {
        return new StringOps(Predef$.MODULE$.augmentString(org.apache.spark.package$.MODULE$.SPARK_VERSION())).$greater$eq((Object)"3.2.1");
    }

    public StructType getMetaSchema() {
        return StructType$.MODULE$.apply((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(HoodieRecord.HOODIE_META_COLUMNS).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final StructField apply(String col) {
                return new StructField(col, (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4());
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public boolean isGlobPath(Path pattern) {
        Set set = new StringOps(Predef$.MODULE$.augmentString("{}[]*?\\")).toSet();
        return new StringOps(Predef$.MODULE$.augmentString(pattern.toString())).exists((Function1)new Serializable(set){
            public static final long serialVersionUID = 0L;
            private final Set eta$0$1$1;

            public final boolean apply(Object elem) {
                return this.eta$0$1$1.contains(elem);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        });
    }

    public Seq<Path> globPath(FileSystem fs, Path pattern) {
        ObjectRef basePath = ObjectRef.create((Object)pattern.getParent());
        while (((Path)basePath.elem).getName().equals("*")) {
            basePath.elem = ((Path)basePath.elem).getParent();
        }
        return (Seq)Option$.MODULE$.apply((Object)fs.globStatus(pattern)).map((Function1)new Serializable(fs, basePath){
            public static final long serialVersionUID = 0L;
            public final FileSystem fs$1;
            public final ObjectRef basePath$1;

            public final Seq<Path> apply(FileStatus[] statuses) {
                FileStatus[] nonMetaStatuses = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])statuses).filterNot((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.globPath.1 $outer;

                    public final boolean apply(FileStatus entry) {
                        Path leafPath = entry.getPath();
                        while (!leafPath.equals((Object)((Path)this.$outer.basePath$1.elem)) && !leafPath.getName().equals(".hoodie")) {
                            Path path;
                            path = path.getParent();
                        }
                        return leafPath.getName().equals(".hoodie");
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])nonMetaStatuses).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.globPath.1 $outer;

                    public final Path apply(FileStatus x$1) {
                        return x$1.getPath().makeQualified(this.$outer.fs$1.getUri(), this.$outer.fs$1.getWorkingDirectory());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).toSeq();
            }
            {
                this.fs$1 = fs$1;
                this.basePath$1 = basePath$1;
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Path> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public Seq<Path> globPathIfNecessary(FileSystem fs, Path pattern) {
        return this.isGlobPath(pattern) ? this.globPath(fs, pattern) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{pattern}));
    }

    public Seq<Path> checkAndGlobPathIfNecessary(Seq<String> paths, FileSystem fs) {
        return (Seq)paths.flatMap((Function1)new Serializable(fs){
            public static final long serialVersionUID = 0L;
            private final FileSystem fs$2;

            public final Seq<Path> apply(String path) {
                Path qualified = new Path(path).makeQualified(this.fs$2.getUri(), this.fs$2.getWorkingDirectory());
                return HoodieSparkUtils$.MODULE$.globPathIfNecessary(this.fs$2, qualified);
            }
            {
                this.fs$2 = fs$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace, boolean reconcileToLatestSchema, Option<Schema> latestTableSchema) {
        Object latestTableSchemaConverted = None$.MODULE$;
        latestTableSchemaConverted = latestTableSchema.isPresent() && reconcileToLatestSchema ? new Some((Object)latestTableSchema.get()) : (latestTableSchema.isPresent() ? new Some((Object)latestTableSchema.get()) : None$.MODULE$);
        return this.createRdd(df, structName, recordNamespace, (scala.Option<Schema>)latestTableSchemaConverted);
    }

    public RDD<GenericRecord> createRdd(Dataset<Row> df, String structName, String recordNamespace, scala.Option<Schema> readerAvroSchemaOpt) {
        StructType writerSchema = df.schema();
        Schema writerAvroSchema = AvroConversionUtils$.MODULE$.convertStructTypeToAvroSchema((DataType)writerSchema, structName, recordNamespace);
        Schema readerAvroSchema = (Schema)readerAvroSchemaOpt.getOrElse((Function0)new Serializable(writerAvroSchema){
            public static final long serialVersionUID = 0L;
            private final Schema writerAvroSchema$1;

            public final Schema apply() {
                return this.writerAvroSchema$1;
            }
            {
                this.writerAvroSchema$1 = writerAvroSchema$1;
            }
        });
        boolean sameSchema = writerAvroSchema.equals((Object)readerAvroSchema);
        Tuple2<Object, Schema> tuple2 = AvroConversionUtils$.MODULE$.resolveAvroTypeNullability(writerAvroSchema);
        if (tuple2 != null) {
            boolean nullable;
            boolean bl;
            boolean nullable2 = bl = (nullable = tuple2._1$mcZ$sp());
            String readerAvroSchemaStr = readerAvroSchema.toString();
            String writerAvroSchemaStr = writerAvroSchema.toString();
            return df.queryExecution().toRdd().mapPartitions((Function1)new Serializable(writerSchema, sameSchema, nullable2, readerAvroSchemaStr, writerAvroSchemaStr){
                public static final long serialVersionUID = 0L;
                private final StructType writerSchema$1;
                private final boolean sameSchema$1;
                private final boolean nullable$1;
                private final String readerAvroSchemaStr$1;
                private final String writerAvroSchemaStr$1;

                public final Iterator<GenericRecord> apply(Iterator<InternalRow> rows) {
                    Iterator iterator2;
                    if (rows.isEmpty()) {
                        iterator2 = scala.package$.MODULE$.Iterator().empty();
                    } else {
                        Object object;
                        if (this.sameSchema$1) {
                            object = new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final GenericRecord apply(GenericRecord x) {
                                    return (GenericRecord)Predef$.MODULE$.identity((Object)x);
                                }
                            };
                        } else {
                            Schema readerAvroSchema = new Schema.Parser().parse(this.readerAvroSchemaStr$1);
                            object = new Serializable(this, readerAvroSchema){
                                public static final long serialVersionUID = 0L;
                                private final Schema readerAvroSchema$1;

                                public final GenericRecord apply(GenericRecord x$2) {
                                    return HoodieAvroUtils.rewriteRecord(x$2, this.readerAvroSchema$1);
                                }
                                {
                                    this.readerAvroSchema$1 = readerAvroSchema$1;
                                }
                            };
                        }
                        Serializable transform = object;
                        Schema writerAvroSchema = new Schema.Parser().parse(this.writerAvroSchemaStr$1);
                        Function1<InternalRow, GenericRecord> convert = AvroConversionUtils$.MODULE$.createInternalRowToAvroConverter(this.writerSchema$1, writerAvroSchema, this.nullable$1);
                        iterator2 = rows.map((Function1)new Serializable(this, (Function1)transform, convert){
                            public static final long serialVersionUID = 0L;
                            private final Function1 transform$1;
                            private final Function1 convert$1;

                            public final GenericRecord apply(InternalRow ir) {
                                return (GenericRecord)this.transform$1.apply(this.convert$1.apply((Object)ir));
                            }
                            {
                                this.transform$1 = transform$1;
                                this.convert$1 = convert$1;
                            }
                        });
                    }
                    return iterator2;
                }
                {
                    this.writerSchema$1 = writerSchema$1;
                    this.sameSchema$1 = sameSchema$1;
                    this.nullable$1 = nullable$1;
                    this.readerAvroSchemaStr$1 = readerAvroSchemaStr$1;
                    this.writerAvroSchemaStr$1 = writerAvroSchemaStr$1;
                }
            }, df.queryExecution().toRdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(GenericRecord.class));
        }
        throw new MatchError(tuple2);
    }

    public Option<Schema> createRdd$default$5() {
        return Option.empty();
    }

    public SparkRowSerDe getDeserializer(StructType structType) {
        ExpressionEncoder qual$1 = RowEncoder$.MODULE$.apply(structType);
        Seq x$5 = qual$1.resolveAndBind$default$1();
        Analyzer x$6 = qual$1.resolveAndBind$default$2();
        ExpressionEncoder encoder = qual$1.resolveAndBind(x$5, x$6);
        return this.sparkAdapter().createSparkRowSerDe((ExpressionEncoder<Row>)encoder);
    }

    public Seq<scala.Option<Expression>> convertToCatalystExpressions(Seq<Filter> filters, StructType tableSchema) {
        return (Seq)filters.map((Function1)new Serializable(tableSchema){
            public static final long serialVersionUID = 0L;
            private final StructType tableSchema$1;

            public final scala.Option<Expression> apply(Filter x$3) {
                return HoodieSparkUtils$.MODULE$.convertToCatalystExpression(x$3, this.tableSchema$1);
            }
            {
                this.tableSchema$1 = tableSchema$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public scala.Option<Expression> convertToCatalystExpression(Filter[] filters, StructType tableSchema) {
        Seq<scala.Option<Expression>> expressions = this.convertToCatalystExpressions((Seq<Filter>)Predef$.MODULE$.wrapRefArray((Object[])filters), tableSchema);
        return expressions.forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(scala.Option<Expression> p) {
                return p.isDefined();
            }
        }) ? (expressions.isEmpty() ? None$.MODULE$ : (expressions.length() == 1 ? (scala.Option)expressions.head() : new Some(((TraversableOnce)expressions.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Expression apply(scala.Option<Expression> x$4) {
                return (Expression)x$4.get();
            }
        }, Seq$.MODULE$.canBuildFrom())).reduce((Function2)And$.MODULE$)))) : None$.MODULE$;
    }

    public scala.Option<Expression> convertToCatalystExpression(Filter filter, StructType tableSchema) {
        EqualTo equalTo;
        Filter filter2 = filter;
        if (filter2 instanceof org.apache.spark.sql.sources.EqualTo) {
            org.apache.spark.sql.sources.EqualTo equalTo2 = (org.apache.spark.sql.sources.EqualTo)filter2;
            String attribute = equalTo2.attribute();
            Object value = equalTo2.value();
            equalTo = new EqualTo((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.EqualNullSafe) {
            org.apache.spark.sql.sources.EqualNullSafe equalNullSafe = (org.apache.spark.sql.sources.EqualNullSafe)filter2;
            String attribute = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            equalTo = new EqualNullSafe((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.GreaterThan) {
            org.apache.spark.sql.sources.GreaterThan greaterThan = (org.apache.spark.sql.sources.GreaterThan)filter2;
            String attribute = greaterThan.attribute();
            Object value = greaterThan.value();
            equalTo = new GreaterThan((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.GreaterThanOrEqual) {
            org.apache.spark.sql.sources.GreaterThanOrEqual greaterThanOrEqual = (org.apache.spark.sql.sources.GreaterThanOrEqual)filter2;
            String attribute = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            equalTo = new GreaterThanOrEqual((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.LessThan) {
            org.apache.spark.sql.sources.LessThan lessThan = (org.apache.spark.sql.sources.LessThan)filter2;
            String attribute = lessThan.attribute();
            Object value = lessThan.value();
            equalTo = new LessThan((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof org.apache.spark.sql.sources.LessThanOrEqual) {
            org.apache.spark.sql.sources.LessThanOrEqual lessThanOrEqual = (org.apache.spark.sql.sources.LessThanOrEqual)filter2;
            String attribute = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            equalTo = new LessThanOrEqual((Expression)this.toAttribute(attribute, tableSchema), (Expression)Literal$.MODULE$.create(value, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any()));
        } else if (filter2 instanceof In) {
            In in = (In)filter2;
            String attribute = in.attribute();
            Object[] values2 = in.values();
            AttributeReference attrExp = this.toAttribute(attribute, tableSchema);
            Literal[] valuesExp = (Literal[])Predef$.MODULE$.genericArrayOps((Object)values2).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Literal apply(Object v) {
                    return Literal$.MODULE$.create(v, ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Literal.class)));
            equalTo = new org.apache.spark.sql.catalyst.expressions.In((Expression)attrExp, (Seq)Predef$.MODULE$.wrapRefArray((Object[])valuesExp));
        } else if (filter2 instanceof IsNull) {
            IsNull isNull = (IsNull)filter2;
            String attribute = isNull.attribute();
            equalTo = new org.apache.spark.sql.catalyst.expressions.IsNull((Expression)this.toAttribute(attribute, tableSchema));
        } else if (filter2 instanceof org.apache.spark.sql.sources.IsNotNull) {
            org.apache.spark.sql.sources.IsNotNull isNotNull = (org.apache.spark.sql.sources.IsNotNull)filter2;
            String attribute = isNotNull.attribute();
            equalTo = new IsNotNull((Expression)this.toAttribute(attribute, tableSchema));
        } else if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            scala.Option<Expression> leftExp = this.convertToCatalystExpression(left, tableSchema);
            scala.Option<Expression> rightExp = this.convertToCatalystExpression(right, tableSchema);
            equalTo = leftExp.isEmpty() || rightExp.isEmpty() ? null : new org.apache.spark.sql.catalyst.expressions.And((Expression)leftExp.get(), (Expression)rightExp.get());
        } else if (filter2 instanceof org.apache.spark.sql.sources.Or) {
            org.apache.spark.sql.sources.Or or = (org.apache.spark.sql.sources.Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            scala.Option<Expression> leftExp = this.convertToCatalystExpression(left, tableSchema);
            scala.Option<Expression> rightExp = this.convertToCatalystExpression(right, tableSchema);
            equalTo = leftExp.isEmpty() || rightExp.isEmpty() ? null : new Or((Expression)leftExp.get(), (Expression)rightExp.get());
        } else if (filter2 instanceof Not) {
            Not not = (Not)filter2;
            Filter child = not.child();
            scala.Option<Expression> childExp = this.convertToCatalystExpression(child, tableSchema);
            equalTo = childExp.isEmpty() ? null : new org.apache.spark.sql.catalyst.expressions.Not((Expression)childExp.get());
        } else if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attribute = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator1$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator1$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attribute = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator2$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator2$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attribute = stringContains.attribute();
            String value = stringContains.value();
            AttributeReference leftExp = this.toAttribute(attribute, tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
            public final class Org_apache_hudi_HoodieSparkUtils$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
                }

                public Org_apache_hudi_HoodieSparkUtils$$typecreator3$1() {
                }
            }
            Literal rightExp = Literal$.MODULE$.create((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"%", "%"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{value})), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_hudi_HoodieSparkUtils$$typecreator3$1()));
            equalTo = this.sparkAdapter().createLike((Expression)leftExp, (Expression)rightExp);
        } else {
            equalTo = null;
        }
        return Option$.MODULE$.apply((Object)equalTo);
    }

    public String getPartitionColumns(Properties properties) {
        TypedProperties props = new TypedProperties(properties);
        KeyGenerator keyGenerator = HoodieSparkKeyGeneratorFactory.createKeyGenerator(props);
        return this.getPartitionColumns(keyGenerator, props);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getPartitionColumns(KeyGenerator keyGen, TypedProperties typedProperties) {
        boolean bl = false;
        ObjectRef objectRef = ObjectRef.create(null);
        KeyGenerator keyGenerator = keyGen;
        if (keyGenerator instanceof BaseKeyGenerator) {
            bl = true;
            objectRef.elem = (BaseKeyGenerator)keyGenerator;
            if ((BaseKeyGenerator)objectRef.elem instanceof CustomKeyGenerator) return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).map((Function1)new Serializable(objectRef){
                public static final long serialVersionUID = 0L;
                public final ObjectRef x2$1;

                public final String apply(String pathField) {
                    return (String)Predef$.MODULE$.refArrayOps((Object[])pathField.split(":")).headOption().getOrElse((Function0)new Serializable(this, pathField){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.getPartitionColumns.1 $outer;
                        private final String pathField$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Illegal partition path field format: '", "' for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pathField$1, ((BaseKeyGenerator)this.$outer.x2$1.elem).getClass().getSimpleName()}));
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.pathField$1 = pathField$1;
                        }
                    });
                }
                {
                    this.x2$1 = x2$1;
                }
            }, Buffer$.MODULE$.canBuildFrom())).mkString(",");
            if ((BaseKeyGenerator)objectRef.elem instanceof CustomAvroKeyGenerator) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).map((Function1)new /* invalid duplicate definition of identical inner class */, Buffer$.MODULE$.canBuildFrom())).mkString(",");
            }
        }
        if (!bl) return typedProperties.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key());
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(((BaseKeyGenerator)objectRef.elem).getPartitionPathFields()).asScala()).mkString(",");
    }

    private AttributeReference toAttribute(String columnName, StructType tableSchema) {
        scala.Option field = tableSchema.find((Function1)new Serializable(columnName){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;

            public final boolean apply(StructField p) {
                String string = p.name();
                String string2 = this.columnName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.columnName$1 = columnName$1;
            }
        });
        Predef$.MODULE$.assert(field.isDefined(), (Function0)new Serializable(columnName, tableSchema){
            public static final long serialVersionUID = 0L;
            private final String columnName$1;
            private final StructType tableSchema$2;

            public final String apply() {
                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot find column: ", ", Table Columns are: "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.columnName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.tableSchema$2.fieldNames()).mkString(",")}))).toString();
            }
            {
                this.columnName$1 = columnName$1;
                this.tableSchema$2 = tableSchema$2;
            }
        });
        String x$7 = columnName;
        DataType x$8 = ((StructField)field.get()).dataType();
        boolean x$9 = ((StructField)field.get()).nullable();
        Metadata x$10 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$11 = AttributeReference$.MODULE$.apply$default$5(x$7, x$8, x$9, x$10);
        Seq x$12 = AttributeReference$.MODULE$.apply$default$6(x$7, x$8, x$9, x$10);
        return new AttributeReference(x$7, x$8, x$9, x$10, x$11, x$12);
    }

    public Tuple3<Schema, StructType, InternalSchema> getRequiredSchema(Schema tableAvroSchema, String[] requiredColumns, InternalSchema internalSchema) {
        Tuple3 tuple3;
        if (internalSchema.isEmptySchema() || Predef$.MODULE$.refArrayOps((Object[])requiredColumns).isEmpty()) {
            Map name2Fields = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableAvroSchema.getFields()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, Schema.Field> apply(Schema.Field f) {
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            List requiredFields = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(name2Fields){
                public static final long serialVersionUID = 0L;
                private final Map name2Fields$1;

                public final Schema.Field apply(String c) {
                    return (Schema.Field)this.name2Fields$1.apply((Object)c);
                }
                {
                    this.name2Fields$1 = name2Fields$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Schema.Field.class)))).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Schema.Field apply(Schema.Field f) {
                    return new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Schema.Field.class)))).toList();
            Schema requiredAvroSchema = Schema.createRecord((String)tableAvroSchema.getName(), (String)tableAvroSchema.getDoc(), (String)tableAvroSchema.getNamespace(), (boolean)tableAvroSchema.isError(), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requiredFields).asJava()));
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)internalSchema);
        } else {
            InternalSchema prunedInternalSchema = InternalSchemaUtils.pruneInternalSchema(internalSchema, (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])requiredColumns).toList()).asJava());
            Schema requiredAvroSchema = AvroInternalSchemaConverter.convert(prunedInternalSchema, tableAvroSchema.getName());
            StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
            tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)prunedInternalSchema);
        }
        return tuple3;
    }

    public InternalSchema getRequiredSchema$default$3() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public Seq<AttributeReference> toAttribute(StructType tableSchema) {
        return (Seq)tableSchema.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final AttributeReference apply(StructField field) {
                String x$13 = field.name();
                DataType x$14 = field.dataType();
                boolean x$15 = field.nullable();
                Metadata x$16 = field.metadata();
                ExprId x$17 = AttributeReference$.MODULE$.apply$default$5(x$13, x$14, x$15, x$16);
                Seq x$18 = AttributeReference$.MODULE$.apply$default$6(x$13, x$14, x$15, x$16);
                return new AttributeReference(x$13, x$14, x$15, x$16, x$17, x$18);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Object> collectFieldIndexes(StructType projectedSchema, StructType originalSchema) {
        Map nameToIndex = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])originalSchema.fields()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<StructField, Object> x0$1) {
                Tuple2<StructField, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.name()), (Object)BoxesRunTime.boxToInteger((int)index));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.$conforms());
        return (Seq)projectedSchema.map((Function1)new Serializable(nameToIndex){
            public static final long serialVersionUID = 0L;
            private final Map nameToIndex$1;

            public final int apply(StructField field) {
                return BoxesRunTime.unboxToInt((Object)this.nameToIndex$1.apply((Object)field.name()));
            }
            {
                this.nameToIndex$1 = nameToIndex$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    private HoodieSparkUtils$() {
        MODULE$ = this;
        SparkAdapterSupport$class.$init$(this);
    }
}

