/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.hudi.common.util.ValidationUtils;

public class AvroSchemaUtils {
    private AvroSchemaUtils() {
    }

    public static Schema appendFieldsToSchema(Schema schema2, List<Schema.Field> newFields) {
        List fields = schema2.getFields().stream().map(field -> new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal())).collect(Collectors.toList());
        fields.addAll(newFields);
        Schema newSchema = Schema.createRecord((String)schema2.getName(), (String)schema2.getDoc(), (String)schema2.getNamespace(), (boolean)schema2.isError());
        newSchema.setFields(fields);
        return newSchema;
    }

    public static Schema resolveUnionSchema(Schema schema2, String fieldSchemaFullName) {
        if (schema2.getType() != Schema.Type.UNION) {
            return schema2;
        }
        List innerTypes = schema2.getTypes();
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL && Objects.equals(it.getFullName(), fieldSchemaFullName)).findFirst().orElse(null);
        if (nonNullType == null) {
            throw new AvroRuntimeException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema2));
        }
        return nonNullType;
    }

    public static Schema resolveNullableSchema(Schema schema2) {
        if (schema2.getType() != Schema.Type.UNION) {
            return schema2;
        }
        List innerTypes = schema2.getTypes();
        Schema nonNullType = innerTypes.stream().filter(it -> it.getType() != Schema.Type.NULL).findFirst().orElse(null);
        if (innerTypes.size() != 2 || nonNullType == null) {
            throw new AvroRuntimeException(String.format("Unsupported Avro UNION type %s: Only UNION of a null type and a non-null type is supported", schema2));
        }
        return nonNullType;
    }

    public static Schema createNullableSchema(Schema.Type avroType) {
        ValidationUtils.checkState(avroType != Schema.Type.NULL);
        return Schema.createUnion((Schema[])new Schema[]{Schema.create((Schema.Type)Schema.Type.NULL), Schema.create((Schema.Type)avroType)});
    }

    public static boolean containsFieldInSchema(Schema schema2, String fieldName) {
        try {
            Schema.Field field = schema2.getField(fieldName);
            return field != null;
        }
        catch (Exception e) {
            return false;
        }
    }
}

