/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.Type;
import org.apache.hudi.internal.schema.Types;
import org.apache.hudi.internal.schema.action.InternalSchemaMerger;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.spark.sql.catalyst.util.DateTimeUtils;
import org.apache.spark.sql.execution.vectorized.WritableColumnVector;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.CharType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.VarcharType;

public class SparkInternalSchemaConverter {
    public static final String HOODIE_QUERY_SCHEMA = "hoodie.schema.internal.querySchema";
    public static final String HOODIE_TABLE_PATH = "hoodie.tablePath";
    public static final String HOODIE_VALID_COMMITS_LIST = "hoodie.valid.commits.list";

    private SparkInternalSchemaConverter() {
    }

    public static InternalSchema convertStructTypeToInternalSchema(StructType sparkSchema) {
        Type newType = SparkInternalSchemaConverter.buildTypeFromStructType((DataType)sparkSchema, true, new AtomicInteger(0));
        return new InternalSchema(((Types.RecordType)newType).fields());
    }

    public static Type buildTypeFromStructType(DataType sparkType, Boolean firstVisitRoot, AtomicInteger nextId) {
        if (sparkType instanceof StructType) {
            StructField[] fields = ((StructType)sparkType).fields();
            int nextAssignId = firstVisitRoot != false ? 0 : nextId.get();
            nextId.set(nextAssignId + fields.length);
            ArrayList<Type> newTypes = new ArrayList<Type>();
            for (StructField f : fields) {
                newTypes.add(SparkInternalSchemaConverter.buildTypeFromStructType(f.dataType(), false, nextId));
            }
            ArrayList<Types.Field> newFields = new ArrayList<Types.Field>();
            for (int i = 0; i < newTypes.size(); ++i) {
                StructField f = fields[i];
                newFields.add(Types.Field.get(nextAssignId + i, f.nullable(), f.name(), (Type)newTypes.get(i), f.getComment().isDefined() ? (String)f.getComment().get() : null));
            }
            return Types.RecordType.get(newFields);
        }
        if (sparkType instanceof MapType) {
            MapType map = (MapType)sparkType;
            DataType keyType = map.keyType();
            DataType valueType = map.valueType();
            int keyId = nextId.get();
            int valueId = keyId + 1;
            nextId.set(valueId + 1);
            return Types.MapType.get(keyId, valueId, SparkInternalSchemaConverter.buildTypeFromStructType(keyType, false, nextId), SparkInternalSchemaConverter.buildTypeFromStructType(valueType, false, nextId), map.valueContainsNull());
        }
        if (sparkType instanceof ArrayType) {
            ArrayType array = (ArrayType)sparkType;
            DataType et = array.elementType();
            int elementId = nextId.get();
            nextId.set(elementId + 1);
            return Types.ArrayType.get(elementId, array.containsNull(), SparkInternalSchemaConverter.buildTypeFromStructType(et, false, nextId));
        }
        if (sparkType instanceof UserDefinedType) {
            throw new UnsupportedOperationException("User-defined types are not supported");
        }
        if (sparkType instanceof BooleanType) {
            return Types.BooleanType.get();
        }
        if (sparkType instanceof IntegerType || sparkType instanceof ShortType || sparkType instanceof ByteType) {
            return Types.IntType.get();
        }
        if (sparkType instanceof LongType) {
            return Types.LongType.get();
        }
        if (sparkType instanceof FloatType) {
            return Types.FloatType.get();
        }
        if (sparkType instanceof DoubleType) {
            return Types.DoubleType.get();
        }
        if (sparkType instanceof StringType || sparkType instanceof CharType || sparkType instanceof VarcharType) {
            return Types.StringType.get();
        }
        if (sparkType instanceof DateType) {
            return Types.DateType.get();
        }
        if (sparkType instanceof TimestampType) {
            return Types.TimestampType.get();
        }
        if (sparkType instanceof DecimalType) {
            return Types.DecimalType.get(((DecimalType)sparkType).precision(), ((DecimalType)sparkType).scale());
        }
        if (sparkType instanceof BinaryType) {
            return Types.BinaryType.get();
        }
        throw new UnsupportedOperationException(String.format("Not a supported type: %s", sparkType.catalogString()));
    }

    public static InternalSchema convertAndPruneStructTypeToInternalSchema(StructType sparkSchema, InternalSchema originSchema) {
        List<String> pruneNames = SparkInternalSchemaConverter.collectColNamesFromSparkStruct(sparkSchema);
        return InternalSchemaUtils.pruneInternalSchema(originSchema, pruneNames);
    }

    public static List<String> collectColNamesFromSparkStruct(StructType sparkSchema) {
        ArrayList<String> result = new ArrayList<String>();
        SparkInternalSchemaConverter.collectColNamesFromStructType((DataType)sparkSchema, new LinkedList<String>(), result);
        return result;
    }

    private static void collectColNamesFromStructType(DataType sparkType, Deque<String> fieldNames, List<String> resultSet) {
        if (sparkType instanceof StructType) {
            StructField[] fields;
            for (StructField f : fields = ((StructType)sparkType).fields()) {
                fieldNames.push(f.name());
                SparkInternalSchemaConverter.collectColNamesFromStructType(f.dataType(), fieldNames, resultSet);
                fieldNames.pop();
                SparkInternalSchemaConverter.addFullName(f.dataType(), f.name(), fieldNames, resultSet);
            }
        } else if (sparkType instanceof MapType) {
            MapType map = (MapType)sparkType;
            DataType keyType = map.keyType();
            DataType valueType = map.valueType();
            fieldNames.push("key");
            SparkInternalSchemaConverter.collectColNamesFromStructType(keyType, fieldNames, resultSet);
            fieldNames.pop();
            SparkInternalSchemaConverter.addFullName(keyType, "key", fieldNames, resultSet);
            fieldNames.push("value");
            SparkInternalSchemaConverter.collectColNamesFromStructType(valueType, fieldNames, resultSet);
            fieldNames.poll();
            SparkInternalSchemaConverter.addFullName(valueType, "value", fieldNames, resultSet);
        } else if (sparkType instanceof ArrayType) {
            ArrayType array = (ArrayType)sparkType;
            DataType et = array.elementType();
            fieldNames.push("element");
            SparkInternalSchemaConverter.collectColNamesFromStructType(et, fieldNames, resultSet);
            fieldNames.pop();
            SparkInternalSchemaConverter.addFullName(et, "element", fieldNames, resultSet);
        } else if (sparkType instanceof UserDefinedType) {
            throw new UnsupportedOperationException("User-defined types are not supported");
        }
    }

    private static void addFullName(DataType sparkType, String name, Deque<String> fieldNames, List<String> resultSet) {
        if (!(sparkType instanceof StructType || sparkType instanceof ArrayType || sparkType instanceof MapType)) {
            resultSet.add(InternalSchemaUtils.createFullName(name, fieldNames));
        }
    }

    public static StructType mergeSchema(InternalSchema fileSchema, InternalSchema querySchema) {
        InternalSchema schema2 = new InternalSchemaMerger(fileSchema, querySchema, true, true).mergeSchema();
        return SparkInternalSchemaConverter.constructSparkSchemaFromInternalSchema(schema2);
    }

    public static Map<Integer, Pair<DataType, DataType>> collectTypeChangedCols(InternalSchema schema2, InternalSchema other) {
        return InternalSchemaUtils.collectTypeChangedCols(schema2, other).entrySet().stream().collect(Collectors.toMap(e -> (Integer)e.getKey(), e -> Pair.of(SparkInternalSchemaConverter.constructSparkSchemaFromType((Type)((Pair)e.getValue()).getLeft()), SparkInternalSchemaConverter.constructSparkSchemaFromType((Type)((Pair)e.getValue()).getRight()))));
    }

    public static StructType constructSparkSchemaFromInternalSchema(InternalSchema schema2) {
        return (StructType)SparkInternalSchemaConverter.constructSparkSchemaFromType(schema2.getRecord());
    }

    private static DataType constructSparkSchemaFromType(Type type) {
        switch (type.typeId()) {
            case RECORD: {
                Types.RecordType record = (Types.RecordType)type;
                List<Types.Field> fields = record.fields();
                ArrayList<StructField> structFields = new ArrayList<StructField>();
                for (Types.Field f : fields) {
                    DataType dataType = SparkInternalSchemaConverter.constructSparkSchemaFromType(f.type());
                    StructField structField = StructField.apply((String)f.name(), (DataType)dataType, (boolean)f.isOptional(), (Metadata)Metadata.empty());
                    structField = f.doc() == null ? structField : structField.withComment(f.doc());
                    structFields.add(structField);
                }
                return StructType$.MODULE$.apply(structFields);
            }
            case ARRAY: {
                Types.ArrayType array = (Types.ArrayType)type;
                DataType elementType = SparkInternalSchemaConverter.constructSparkSchemaFromType(array.elementType());
                return ArrayType$.MODULE$.apply(elementType, array.isElementOptional());
            }
            case MAP: {
                Types.MapType map = (Types.MapType)type;
                DataType keyDataType = SparkInternalSchemaConverter.constructSparkSchemaFromType(map.keyType());
                DataType valueDataType = SparkInternalSchemaConverter.constructSparkSchemaFromType(map.valueType());
                return MapType$.MODULE$.apply(keyDataType, valueDataType, map.isValueOptional());
            }
            case BOOLEAN: {
                return BooleanType$.MODULE$;
            }
            case INT: {
                return IntegerType$.MODULE$;
            }
            case LONG: {
                return LongType$.MODULE$;
            }
            case FLOAT: {
                return FloatType$.MODULE$;
            }
            case DOUBLE: {
                return DoubleType$.MODULE$;
            }
            case DATE: {
                return DateType$.MODULE$;
            }
            case TIME: {
                throw new UnsupportedOperationException(String.format("cannot convert %s type to Spark", type));
            }
            case TIMESTAMP: {
                return TimestampType$.MODULE$;
            }
            case STRING: {
                return StringType$.MODULE$;
            }
            case UUID: {
                return StringType$.MODULE$;
            }
            case FIXED: {
                return BinaryType$.MODULE$;
            }
            case BINARY: {
                return BinaryType$.MODULE$;
            }
            case DECIMAL: {
                Types.DecimalType decimal = (Types.DecimalType)type;
                return DecimalType$.MODULE$.apply(decimal.precision(), decimal.scale());
            }
        }
        throw new UnsupportedOperationException(String.format("cannot convert unknown type: %s to Spark", type));
    }

    private static boolean convertIntLongType(WritableColumnVector oldV, WritableColumnVector newV, DataType newType, int len) {
        boolean isInt = oldV.dataType() instanceof IntegerType;
        if (newType instanceof LongType || newType instanceof FloatType || newType instanceof DoubleType || newType instanceof StringType || newType instanceof DecimalType) {
            for (int i = 0; i < len; ++i) {
                if (oldV.isNullAt(i)) {
                    newV.putNull(i);
                    continue;
                }
                if (newType instanceof LongType) {
                    newV.putLong(i, isInt ? (long)oldV.getInt(i) : oldV.getLong(i));
                    continue;
                }
                if (newType instanceof FloatType) {
                    newV.putFloat(i, isInt ? (float)oldV.getInt(i) : (float)oldV.getLong(i));
                    continue;
                }
                if (newType instanceof DoubleType) {
                    newV.putDouble(i, isInt ? (double)oldV.getInt(i) : (double)oldV.getLong(i));
                    continue;
                }
                if (newType instanceof StringType) {
                    newV.putByteArray(i, ((isInt ? (long)oldV.getInt(i) : oldV.getLong(i)) + "").getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                if (!(newType instanceof DecimalType)) continue;
                Decimal oldDecimal = Decimal.apply((long)(isInt ? (long)oldV.getInt(i) : oldV.getLong(i)));
                oldDecimal.changePrecision(((DecimalType)newType).precision(), ((DecimalType)newType).scale());
                newV.putDecimal(i, oldDecimal, ((DecimalType)newType).precision());
            }
            return true;
        }
        return false;
    }

    private static boolean convertFloatType(WritableColumnVector oldV, WritableColumnVector newV, DataType newType, int len) {
        if (newType instanceof DoubleType || newType instanceof StringType || newType instanceof DecimalType) {
            for (int i = 0; i < len; ++i) {
                if (oldV.isNullAt(i)) {
                    newV.putNull(i);
                    continue;
                }
                if (newType instanceof DoubleType) {
                    newV.putDouble(i, Double.valueOf(oldV.getFloat(i) + "").doubleValue());
                    continue;
                }
                if (newType instanceof StringType) {
                    newV.putByteArray(i, (oldV.getFloat(i) + "").getBytes(StandardCharsets.UTF_8));
                    continue;
                }
                if (!(newType instanceof DecimalType)) continue;
                Decimal oldDecimal = Decimal.apply((double)oldV.getFloat(i));
                oldDecimal.changePrecision(((DecimalType)newType).precision(), ((DecimalType)newType).scale());
                newV.putDecimal(i, oldDecimal, ((DecimalType)newType).precision());
            }
            return true;
        }
        return false;
    }

    private static boolean convertDoubleType(WritableColumnVector oldV, WritableColumnVector newV, DataType newType, int len) {
        if (newType instanceof DecimalType || newType instanceof StringType) {
            for (int i = 0; i < len; ++i) {
                if (oldV.isNullAt(i)) {
                    newV.putNull(i);
                    continue;
                }
                if (newType instanceof DecimalType) {
                    Decimal oldDecimal = Decimal.apply((double)oldV.getDouble(i));
                    oldDecimal.changePrecision(((DecimalType)newType).precision(), ((DecimalType)newType).scale());
                    newV.putDecimal(i, oldDecimal, ((DecimalType)newType).precision());
                    continue;
                }
                if (!(newType instanceof StringType)) continue;
                newV.putByteArray(i, (oldV.getDouble(i) + "").getBytes(StandardCharsets.UTF_8));
            }
            return true;
        }
        return false;
    }

    private static boolean convertDecimalType(WritableColumnVector oldV, WritableColumnVector newV, DataType newType, int len) {
        DataType oldType = oldV.dataType();
        if (newType instanceof DecimalType || newType instanceof StringType) {
            for (int i = 0; i < len; ++i) {
                if (oldV.isNullAt(i)) {
                    newV.putNull(i);
                    continue;
                }
                Decimal oldDecimal = oldV.getDecimal(i, ((DecimalType)oldType).precision(), ((DecimalType)oldType).scale());
                if (newType instanceof DecimalType) {
                    oldDecimal.changePrecision(((DecimalType)newType).precision(), ((DecimalType)newType).scale());
                    newV.putDecimal(i, oldDecimal, ((DecimalType)newType).precision());
                    continue;
                }
                if (!(newType instanceof StringType)) continue;
                newV.putByteArray(i, oldDecimal.toString().getBytes(StandardCharsets.UTF_8));
            }
            return true;
        }
        return false;
    }

    private static boolean convertDateType(WritableColumnVector oldV, WritableColumnVector newV, DataType newType, int len) {
        if (newType instanceof StringType) {
            for (int i = 0; i < len; ++i) {
                if (oldV.isNullAt(i)) {
                    newV.putNull(i);
                    continue;
                }
                String res = DateTimeUtils.toJavaDate((int)oldV.getInt(i)).toString();
                newV.putByteArray(i, res.getBytes(StandardCharsets.UTF_8));
            }
            return true;
        }
        return false;
    }

    private static boolean convertStringType(WritableColumnVector oldV, WritableColumnVector newV, DataType newType, int len) {
        if (newType instanceof DateType || newType instanceof DecimalType) {
            for (int i = 0; i < len; ++i) {
                if (oldV.isNullAt(i)) {
                    newV.putNull(i);
                    continue;
                }
                if (newType instanceof DateType) {
                    int days = DateTimeUtils.fromJavaDate((Date)Date.valueOf(oldV.getUTF8String(i).toString()));
                    newV.putInt(i, days);
                    continue;
                }
                if (!(newType instanceof DecimalType)) continue;
                DecimalType decimalType = (DecimalType)newType;
                BigDecimal bigDecimal = new BigDecimal(oldV.getUTF8String(i).toString().trim());
                Decimal sparkDecimal = Decimal.apply((BigDecimal)bigDecimal);
                sparkDecimal.changePrecision(decimalType.precision(), decimalType.scale());
                newV.putDecimal(i, sparkDecimal, decimalType.precision());
            }
            return true;
        }
        return false;
    }

    public static boolean convertColumnVectorType(WritableColumnVector oldV, WritableColumnVector newV, int len) {
        if (len == 0 || oldV == null || newV == null) {
            return false;
        }
        DataType oldType = oldV.dataType();
        DataType newType = newV.dataType();
        if (oldV != null && newType != null) {
            if (oldType instanceof BooleanType) {
                return false;
            }
            if (oldType instanceof ByteType) {
                return false;
            }
            if (oldType instanceof ShortType) {
                return false;
            }
            if (oldType instanceof IntegerType) {
                return SparkInternalSchemaConverter.convertIntLongType(oldV, newV, newType, len);
            }
            if (oldType instanceof LongType) {
                return SparkInternalSchemaConverter.convertIntLongType(oldV, newV, newType, len);
            }
            if (oldType instanceof FloatType) {
                return SparkInternalSchemaConverter.convertFloatType(oldV, newV, newType, len);
            }
            if (oldType instanceof DoubleType) {
                return SparkInternalSchemaConverter.convertDoubleType(oldV, newV, newType, len);
            }
            if (oldType instanceof StringType) {
                return SparkInternalSchemaConverter.convertStringType(oldV, newV, newType, len);
            }
            if (oldType instanceof BinaryType) {
                return false;
            }
            if (oldType instanceof DecimalType) {
                return SparkInternalSchemaConverter.convertDecimalType(oldV, newV, newType, len);
            }
            if (oldType instanceof DateType) {
                return SparkInternalSchemaConverter.convertDateType(oldV, newV, newType, len);
            }
            if (oldType instanceof TimestampType) {
                return false;
            }
            throw new UnsupportedOperationException("Datatype not supported " + oldV);
        }
        return false;
    }
}

