/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;

public abstract class HoodieRecord<T>
implements Serializable {
    public static final String COMMIT_TIME_METADATA_FIELD = "_hoodie_commit_time";
    public static final String COMMIT_SEQNO_METADATA_FIELD = "_hoodie_commit_seqno";
    public static final String RECORD_KEY_METADATA_FIELD = "_hoodie_record_key";
    public static final String PARTITION_PATH_METADATA_FIELD = "_hoodie_partition_path";
    public static final String FILENAME_METADATA_FIELD = "_hoodie_file_name";
    public static final String OPERATION_METADATA_FIELD = "_hoodie_operation";
    public static final String HOODIE_IS_DELETED = "_hoodie_is_deleted";
    public static final List<String> HOODIE_META_COLUMNS = CollectionUtils.createImmutableList("_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name");
    public static final List<String> HOODIE_META_COLUMNS_WITH_OPERATION = CollectionUtils.createImmutableList("_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name", "_hoodie_operation");
    public static final Map<String, Integer> HOODIE_META_COLUMNS_NAME_TO_POS = IntStream.range(0, HOODIE_META_COLUMNS.size()).mapToObj(idx -> Pair.of(HOODIE_META_COLUMNS.get(idx), idx)).collect(Collectors.toMap(Pair::getKey, Pair::getValue));
    public static int RECORD_KEY_META_FIELD_POS = HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_record_key");
    public static int PARTITION_PATH_META_FIELD_POS = HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_partition_path");
    public static int FILENAME_META_FIELD_POS = HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_file_name");
    private HoodieKey key;
    protected T data;
    private HoodieRecordLocation currentLocation;
    private HoodieRecordLocation newLocation;
    private boolean sealed;
    private HoodieOperation operation;

    public HoodieRecord(HoodieKey key, T data) {
        this(key, data, null);
    }

    public HoodieRecord(HoodieKey key, T data, HoodieOperation operation) {
        this.key = key;
        this.data = data;
        this.currentLocation = null;
        this.newLocation = null;
        this.sealed = false;
        this.operation = operation;
    }

    public HoodieRecord(HoodieRecord<T> record) {
        this(record.key, record.data);
        this.currentLocation = record.currentLocation;
        this.newLocation = record.newLocation;
        this.sealed = record.sealed;
        this.operation = record.operation;
    }

    public HoodieRecord() {
    }

    public abstract HoodieRecord<T> newInstance();

    public HoodieKey getKey() {
        return this.key;
    }

    public HoodieOperation getOperation() {
        return this.operation;
    }

    public T getData() {
        if (this.data == null) {
            throw new IllegalStateException("Payload already deflated for record.");
        }
        return this.data;
    }

    public void deflate() {
        this.data = null;
    }

    public HoodieRecord setCurrentLocation(HoodieRecordLocation location) {
        this.checkState();
        assert (this.currentLocation == null);
        this.currentLocation = location;
        return this;
    }

    public HoodieRecordLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public HoodieRecord setNewLocation(HoodieRecordLocation location) {
        this.checkState();
        assert (this.newLocation == null);
        this.newLocation = location;
        return this;
    }

    public Option<HoodieRecordLocation> getNewLocation() {
        return Option.ofNullable(this.newLocation);
    }

    public boolean isCurrentLocationKnown() {
        return this.currentLocation != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieRecord that = (HoodieRecord)o;
        return Objects.equals(this.key, that.key) && Objects.equals(this.data, that.data) && Objects.equals(this.currentLocation, that.currentLocation) && Objects.equals(this.newLocation, that.newLocation);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.data, this.currentLocation, this.newLocation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieRecord{");
        sb.append("key=").append(this.key);
        sb.append(", currentLocation='").append(this.currentLocation).append('\'');
        sb.append(", newLocation='").append(this.newLocation).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static String generateSequenceId(String instantTime, int partitionId, long recordIndex) {
        return instantTime + "_" + partitionId + "_" + recordIndex;
    }

    public String getPartitionPath() {
        assert (this.key != null);
        return this.key.getPartitionPath();
    }

    public String getRecordKey() {
        assert (this.key != null);
        return this.key.getRecordKey();
    }

    public void seal() {
        this.sealed = true;
    }

    public void unseal() {
        this.sealed = false;
    }

    public void checkState() {
        if (this.sealed) {
            throw new UnsupportedOperationException("Not allowed to modify after sealed");
        }
    }
}

