/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log;

import java.util.List;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.log.AbstractHoodieLogRecordReader;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.Option;

public class HoodieUnMergedLogRecordScanner
extends AbstractHoodieLogRecordReader {
    private final LogRecordScannerCallback callback;

    private HoodieUnMergedLogRecordScanner(FileSystem fs, String basePath, List<String> logFilePaths, Schema readerSchema, String latestInstantTime, boolean readBlocksLazily, boolean reverseReader, int bufferSize, LogRecordScannerCallback callback, Option<InstantRange> instantRange) {
        super(fs, basePath, logFilePaths, readerSchema, latestInstantTime, readBlocksLazily, reverseReader, bufferSize, instantRange, false);
        this.callback = callback;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    protected void processNextRecord(HoodieRecord<? extends HoodieRecordPayload> hoodieRecord) throws Exception {
        this.callback.apply(hoodieRecord);
    }

    @Override
    protected void processNextDeletedRecord(DeleteRecord deleteRecord) {
        throw new IllegalStateException("Not expected to see delete records in this log-scan mode. Check Job Config");
    }

    public static class Builder
    extends AbstractHoodieLogRecordReader.Builder {
        private FileSystem fs;
        private String basePath;
        private List<String> logFilePaths;
        private Schema readerSchema;
        private String latestInstantTime;
        private boolean readBlocksLazily;
        private boolean reverseReader;
        private int bufferSize;
        private Option<InstantRange> instantRange = Option.empty();
        private LogRecordScannerCallback callback;

        @Override
        public Builder withFileSystem(FileSystem fs) {
            this.fs = fs;
            return this;
        }

        @Override
        public Builder withBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        @Override
        public Builder withLogFilePaths(List<String> logFilePaths) {
            this.logFilePaths = logFilePaths;
            return this;
        }

        @Override
        public Builder withReaderSchema(Schema schema2) {
            this.readerSchema = schema2;
            return this;
        }

        @Override
        public Builder withLatestInstantTime(String latestInstantTime) {
            this.latestInstantTime = latestInstantTime;
            return this;
        }

        @Override
        public Builder withReadBlocksLazily(boolean readBlocksLazily) {
            this.readBlocksLazily = readBlocksLazily;
            return this;
        }

        @Override
        public Builder withReverseReader(boolean reverseReader) {
            this.reverseReader = reverseReader;
            return this;
        }

        @Override
        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        @Override
        public Builder withInstantRange(Option<InstantRange> instantRange) {
            this.instantRange = instantRange;
            return this;
        }

        public Builder withLogRecordScannerCallback(LogRecordScannerCallback callback) {
            this.callback = callback;
            return this;
        }

        @Override
        public HoodieUnMergedLogRecordScanner build() {
            return new HoodieUnMergedLogRecordScanner(this.fs, this.basePath, this.logFilePaths, this.readerSchema, this.latestInstantTime, this.readBlocksLazily, this.reverseReader, this.bufferSize, this.callback, this.instantRange);
        }
    }

    @FunctionalInterface
    public static interface LogRecordScannerCallback {
        public void apply(HoodieRecord<? extends HoodieRecordPayload> var1) throws Exception;
    }
}

